/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.debugger.commands;

import java.io.PrintWriter;
import org.semanticweb.HermiT.debugger.Debugger;
import org.semanticweb.HermiT.debugger.commands.AbstractCommand;

public class BreakpointTimeCommand
extends AbstractCommand {
    public BreakpointTimeCommand(Debugger debugger) {
        super(debugger);
    }

    public String getCommandName() {
        return "bpTime";
    }

    public String[] getDescription() {
        return new String[]{"timeInSeconds", "sets the break point time"};
    }

    public void printHelp(PrintWriter printWriter) {
        printWriter.println("usage: bpTime timeInSeconds");
        printWriter.println("    Sets the breakpoint time -- that is, after timeInSeconds,");
        printWriter.println("    the debugger will return control to the user.");
    }

    public void execute(String[] stringArray) {
        int n;
        if (stringArray.length < 2) {
            this.m_debugger.getOutput().println("Time is missing.");
            return;
        }
        try {
            n = Integer.parseInt(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            this.m_debugger.getOutput().println("Invalid time.");
            return;
        }
        this.m_debugger.getOutput().println("Breakpoint time is " + n + " seconds.");
        this.m_debugger.setBreakpointTime(n * 1000);
    }
}

