/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.debugger;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.semanticweb.HermiT.Prefixes;
import org.semanticweb.HermiT.debugger.DerivationHistory;

public class DerivationViewer
extends JFrame {
    protected final Prefixes m_prefixes;
    protected final DerivationTreeTreeModel m_derivationTreeTreeModel;
    protected final JTree m_derivationTree;
    protected static final Font s_font = new Font("Serif", 1, 11);
    protected static final Icon DLCLAUSE_APPLICATION_ICON = new TextIcon(Color.YELLOW, Color.BLACK, "R", s_font);
    protected static final Icon DISJUNCT_APPLICATION_ICON = new TextIcon(Color.CYAN, Color.BLACK, "D", s_font);
    protected static final Icon MERGING_ICON = new TextIcon(Color.BLUE, Color.WHITE, "M", s_font);
    protected static final Icon GRAPH_CHECKING_ICON = new TextIcon(Color.DARK_GRAY, Color.WHITE, "G", s_font);
    protected static final Icon CLASH_DETECTION_ICON = new TextIcon(Color.BLACK, Color.WHITE, "C", s_font);
    protected static final Icon EXISTENTIAL_EXPANSION_ICON = new TextIcon(Color.RED, Color.WHITE, "E", s_font);
    protected static final Icon BASE_FACT_ICON = new TextIcon(Color.MAGENTA, Color.WHITE, "B", s_font);

    public DerivationViewer(Prefixes prefixes, DerivationHistory.Fact fact) {
        super("Derivation tree for " + fact.toString(prefixes));
        this.setDefaultCloseOperation(2);
        this.m_prefixes = prefixes;
        this.m_derivationTreeTreeModel = new DerivationTreeTreeModel(fact);
        this.m_derivationTree = new JTree(this.m_derivationTreeTreeModel);
        this.m_derivationTree.setLargeModel(true);
        this.m_derivationTree.setShowsRootHandles(true);
        this.m_derivationTree.setCellRenderer(new DerivationTreeCellRenderer());
        JScrollPane jScrollPane = new JScrollPane(this.m_derivationTree);
        jScrollPane.setPreferredSize(new Dimension(600, 400));
        JButton jButton = new JButton("Refresh");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DerivationViewer.this.refresh();
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)jButton, "South");
        this.setContentPane(jPanel);
        this.getRootPane().setDefaultButton(jButton);
        this.pack();
        this.setLocation(150, 150);
        this.setVisible(true);
    }

    public void refresh() {
        this.m_derivationTreeTreeModel.refresh();
    }

    protected class DerivationTreeCellRenderer
    extends DefaultTreeCellRenderer {
        protected DerivationTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            DerivationHistory.Fact fact = (DerivationHistory.Fact)object;
            DerivationHistory.Derivation derivation = fact.getDerivation();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(fact.toString(DerivationViewer.this.m_prefixes));
            stringBuffer.append(derivation.toString(DerivationViewer.this.m_prefixes));
            super.getTreeCellRendererComponent(jTree, stringBuffer.toString(), bl, bl2, bl3, n, bl4);
            if (derivation instanceof DerivationHistory.DLClauseApplication) {
                this.setIcon(DLCLAUSE_APPLICATION_ICON);
            } else if (derivation instanceof DerivationHistory.DisjunctApplication) {
                this.setIcon(DISJUNCT_APPLICATION_ICON);
            } else if (derivation instanceof DerivationHistory.Merging) {
                this.setIcon(MERGING_ICON);
            } else if (derivation instanceof DerivationHistory.GraphChecking) {
                this.setIcon(GRAPH_CHECKING_ICON);
            } else if (derivation instanceof DerivationHistory.ClashDetection) {
                this.setIcon(CLASH_DETECTION_ICON);
            } else if (derivation instanceof DerivationHistory.ExistentialExpansion) {
                this.setIcon(EXISTENTIAL_EXPANSION_ICON);
            } else if (derivation instanceof DerivationHistory.BaseFact) {
                this.setIcon(BASE_FACT_ICON);
            } else {
                this.setIcon(null);
            }
            return this;
        }
    }

    protected static class TextIcon
    implements Icon,
    Serializable {
        private static final long serialVersionUID = 2955881594360729470L;
        protected static final int WIDTH = 16;
        protected static final int HEIGHT = 16;
        protected final Color m_background;
        protected final Color m_foreground;
        protected final String m_text;
        protected final Font m_font;

        public TextIcon(Color color, Color color2, String string, Font font) {
            this.m_background = color;
            this.m_foreground = color2;
            this.m_text = string;
            this.m_font = font;
        }

        public int getIconHeight() {
            return 16;
        }

        public int getIconWidth() {
            return 16;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            graphics.setColor(this.m_background);
            graphics.fillOval(n + 2, n2 + 2, n + 16 - 2, n2 + 16 - 2);
            graphics.setColor(this.m_foreground);
            Font font = graphics.getFont();
            graphics.setFont(this.m_font);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n3 = n + (16 - fontMetrics.stringWidth(this.m_text)) / 2 + 2;
            int n4 = n2 + (16 + fontMetrics.getAscent() - fontMetrics.getDescent()) / 2;
            graphics.drawString(this.m_text, n3, n4);
            graphics.setFont(font);
            graphics.setColor(color);
        }
    }

    protected static class DerivationTreeTreeModel
    implements TreeModel,
    Serializable {
        private static final long serialVersionUID = 9210217812084186766L;
        protected final EventListenerList m_eventListeners = new EventListenerList();
        protected final DerivationHistory.Fact m_root;

        public DerivationTreeTreeModel(DerivationHistory.Fact fact) {
            this.m_root = fact;
        }

        public void addTreeModelListener(TreeModelListener treeModelListener) {
            this.m_eventListeners.add(TreeModelListener.class, treeModelListener);
        }

        public void removeTreeModelListener(TreeModelListener treeModelListener) {
            this.m_eventListeners.remove(TreeModelListener.class, treeModelListener);
        }

        public Object getChild(Object object, int n) {
            DerivationHistory.Fact fact = (DerivationHistory.Fact)object;
            DerivationHistory.Derivation derivation = fact.getDerivation();
            return derivation.getPremise(n);
        }

        public int getChildCount(Object object) {
            DerivationHistory.Fact fact = (DerivationHistory.Fact)object;
            DerivationHistory.Derivation derivation = fact.getDerivation();
            return derivation.getNumberOfPremises();
        }

        public int getIndexOfChild(Object object, Object object2) {
            DerivationHistory.Fact fact = (DerivationHistory.Fact)object;
            DerivationHistory.Derivation derivation = fact.getDerivation();
            for (int i = 0; i < derivation.getNumberOfPremises(); ++i) {
                if (!object2.equals(derivation.getPremise(i))) continue;
                return i;
            }
            return -1;
        }

        public Object getRoot() {
            return this.m_root;
        }

        public boolean isLeaf(Object object) {
            DerivationHistory.Fact fact = (DerivationHistory.Fact)object;
            DerivationHistory.Derivation derivation = fact.getDerivation();
            return derivation.getNumberOfPremises() == 0;
        }

        public void valueForPathChanged(TreePath treePath, Object object) {
        }

        public void refresh() {
            Object[] objectArray = this.m_eventListeners.getListenerList();
            TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, new Object[]{this.getRoot()});
            for (Object object : objectArray) {
                if (!(object instanceof TreeModelListener)) continue;
                ((TreeModelListener)object).treeStructureChanged(treeModelEvent);
            }
        }
    }
}

