/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.datatypes.rdfplainliteral;

import dk.brics.automaton.Automaton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.HermiT.Prefixes;
import org.semanticweb.HermiT.datatypes.DatatypeHandler;
import org.semanticweb.HermiT.datatypes.MalformedLiteralException;
import org.semanticweb.HermiT.datatypes.UnsupportedFacetException;
import org.semanticweb.HermiT.datatypes.ValueSpaceSubset;
import org.semanticweb.HermiT.datatypes.rdfplainliteral.RDFPlainLiteralDataValue;
import org.semanticweb.HermiT.datatypes.rdfplainliteral.RDFPlainLiteralLengthInterval;
import org.semanticweb.HermiT.datatypes.rdfplainliteral.RDFPlainLiteralLengthValueSpaceSubset;
import org.semanticweb.HermiT.datatypes.rdfplainliteral.RDFPlainLiteralPatternValueSpaceSubset;
import org.semanticweb.HermiT.model.Constant;
import org.semanticweb.HermiT.model.DatatypeRestriction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RDFPlainLiteralDatatypeHandler
implements DatatypeHandler {
    protected static final String XSD_NS = Prefixes.s_semanticWebPrefixes.get("xsd");
    protected static final String RDF_NS = Prefixes.s_semanticWebPrefixes.get("rdf");
    protected static final Map<String, ValueSpaceSubset> s_subsetsByDatatype = new HashMap<String, ValueSpaceSubset>();
    protected static final ValueSpaceSubset EMPTY_SUBSET;
    protected static final Map<String, Set<String>> s_datatypeSupersets;

    protected static void registerPatternDatatype(String string) {
        Automaton automaton = RDFPlainLiteralPatternValueSpaceSubset.getDatatypeAutomaton(string);
        s_subsetsByDatatype.put(string, new RDFPlainLiteralPatternValueSpaceSubset(automaton));
    }

    @Override
    public Set<String> getManagedDatatypeURIs() {
        return s_subsetsByDatatype.keySet();
    }

    @Override
    public Object parseLiteral(String string, String string2) throws MalformedLiteralException {
        Object object;
        assert (s_subsetsByDatatype.containsKey(string2));
        if ((RDF_NS + "PlainLiteral").equals(string2)) {
            int n = string.lastIndexOf(64);
            if (n == -1) {
                throw new MalformedLiteralException(string, string2);
            }
            String string3 = string.substring(0, n);
            String string4 = string.substring(n + 1);
            object = string4.length() == 0 ? string3 : new RDFPlainLiteralDataValue(string3, string4);
        } else {
            object = string;
        }
        if (s_subsetsByDatatype.get(string2).containsDataValue(object)) {
            return object;
        }
        throw new MalformedLiteralException(string, string2);
    }

    @Override
    public void validateDatatypeRestriction(DatatypeRestriction datatypeRestriction) throws UnsupportedFacetException {
        String string = datatypeRestriction.getDatatypeURI();
        assert (s_subsetsByDatatype.containsKey(string));
        for (int i = datatypeRestriction.getNumberOfFacetRestrictions() - 1; i >= 0; --i) {
            String string2 = datatypeRestriction.getFacetURI(i);
            Constant constant = datatypeRestriction.getFacetValue(i);
            Object object = constant.getDataValue();
            if ((XSD_NS + "minLength").equals(string2) || (XSD_NS + "maxLength").equals(string2) || (XSD_NS + "length").equals(string2)) {
                if (object instanceof Integer) {
                    int n = (Integer)object;
                    if (n >= 0 && n != Integer.MAX_VALUE) continue;
                    throw new UnsupportedFacetException("The datatype restriction " + this.toString() + " cannot be handled. The facet with URI '" + string2 + "' does not support integer " + n + " as value. " + (n < 0 ? "The value should not be negative. " : "The value is outside of the supported integer range, i.e., it is larger than 2147483647"));
                }
                throw new UnsupportedFacetException("The datatype rdf:PlainLiteral accepts only integers as facet values for the facet with URI '" + string2 + "', but in the ontology we have a datatype restriction " + this.toString() + ". The value '" + constant.toString() + "' does not seem to be an integer.");
            }
            if ((XSD_NS + "pattern").equals(string2)) {
                if (object instanceof String) {
                    String string3 = (String)object;
                    if (RDFPlainLiteralPatternValueSpaceSubset.isValidPattern(string3)) continue;
                    throw new UnsupportedFacetException("String '" + string3 + "' in the datatype restriction " + this.toString() + " is not a valid regular expression.");
                }
                throw new UnsupportedFacetException("The facet with URI '" + string2 + "' supports only strings as values, but '" + constant.toString() + "' in the restriction " + this.toString() + " does not seem to be a string. It is an instance of the class " + constant.getClass() + ". ");
            }
            if ((RDF_NS + "langRange").equals(string2)) {
                if (object instanceof String) continue;
                throw new UnsupportedFacetException("The facet with URI '" + string2 + "' supports only strings as values, but '" + constant.toString() + "' in the restriction " + this.toString() + " does not seem to be a string. It is an instance of the class " + constant.getClass() + ". ");
            }
            throw new UnsupportedFacetException("Facet with URI '" + string2 + "' is not supported on rdf:PlainLiteral; only xsd:minLength, xsd:maxLength, xsd:length, xsd:pattern, and rdf:langRange are supported, but the ontology contains the restriction: " + this.toString());
        }
    }

    @Override
    public ValueSpaceSubset createValueSpaceSubset(DatatypeRestriction datatypeRestriction) {
        String string = datatypeRestriction.getDatatypeURI();
        assert (s_subsetsByDatatype.containsKey(string));
        if (datatypeRestriction.getNumberOfFacetRestrictions() == 0) {
            return s_subsetsByDatatype.get(string);
        }
        if (this.needsAutomatons(datatypeRestriction)) {
            Automaton automaton = this.getAutomatonFor(datatypeRestriction);
            if (automaton == null) {
                return EMPTY_SUBSET;
            }
            return new RDFPlainLiteralPatternValueSpaceSubset(automaton);
        }
        RDFPlainLiteralLengthInterval[] rDFPlainLiteralLengthIntervalArray = this.getIntervalsFor(datatypeRestriction);
        if (rDFPlainLiteralLengthIntervalArray[0] == null && rDFPlainLiteralLengthIntervalArray[1] == null) {
            return EMPTY_SUBSET;
        }
        if (rDFPlainLiteralLengthIntervalArray[0] != null && rDFPlainLiteralLengthIntervalArray[1] != null) {
            return new RDFPlainLiteralLengthValueSpaceSubset(rDFPlainLiteralLengthIntervalArray[0], rDFPlainLiteralLengthIntervalArray[1]);
        }
        if (rDFPlainLiteralLengthIntervalArray[0] == null && rDFPlainLiteralLengthIntervalArray[1] != null) {
            return new RDFPlainLiteralLengthValueSpaceSubset(rDFPlainLiteralLengthIntervalArray[1]);
        }
        return new RDFPlainLiteralLengthValueSpaceSubset(rDFPlainLiteralLengthIntervalArray[0]);
    }

    @Override
    public ValueSpaceSubset conjoinWithDR(ValueSpaceSubset valueSpaceSubset, DatatypeRestriction datatypeRestriction) {
        String string = datatypeRestriction.getDatatypeURI();
        assert (s_subsetsByDatatype.containsKey(string));
        if (valueSpaceSubset == EMPTY_SUBSET) {
            return EMPTY_SUBSET;
        }
        if (valueSpaceSubset instanceof RDFPlainLiteralPatternValueSpaceSubset || this.needsAutomatons(datatypeRestriction)) {
            Automaton automaton = this.getAutomatonFor(datatypeRestriction);
            if (automaton == null) {
                return EMPTY_SUBSET;
            }
            Automaton automaton2 = this.getAutomatonFor(valueSpaceSubset);
            if (automaton2 == null) {
                return EMPTY_SUBSET;
            }
            Automaton automaton3 = automaton2.intersection(automaton);
            if (automaton3.isEmpty()) {
                return EMPTY_SUBSET;
            }
            return new RDFPlainLiteralPatternValueSpaceSubset(automaton3);
        }
        RDFPlainLiteralLengthInterval[] rDFPlainLiteralLengthIntervalArray = this.getIntervalsFor(datatypeRestriction);
        if (rDFPlainLiteralLengthIntervalArray[0] == null && rDFPlainLiteralLengthIntervalArray[1] == null) {
            return EMPTY_SUBSET;
        }
        List<RDFPlainLiteralLengthInterval> list = ((RDFPlainLiteralLengthValueSpaceSubset)valueSpaceSubset).m_intervals;
        ArrayList<RDFPlainLiteralLengthInterval> arrayList = new ArrayList<RDFPlainLiteralLengthInterval>();
        for (int i = 0; i < list.size(); ++i) {
            RDFPlainLiteralLengthInterval rDFPlainLiteralLengthInterval;
            RDFPlainLiteralLengthInterval rDFPlainLiteralLengthInterval2 = list.get(i);
            if (rDFPlainLiteralLengthIntervalArray[0] != null && (rDFPlainLiteralLengthInterval = rDFPlainLiteralLengthInterval2.intersectWith(rDFPlainLiteralLengthIntervalArray[0])) != null) {
                arrayList.add(rDFPlainLiteralLengthInterval);
            }
            if (rDFPlainLiteralLengthIntervalArray[1] == null || (rDFPlainLiteralLengthInterval = rDFPlainLiteralLengthInterval2.intersectWith(rDFPlainLiteralLengthIntervalArray[1])) == null) continue;
            arrayList.add(rDFPlainLiteralLengthInterval);
        }
        if (arrayList.isEmpty()) {
            return EMPTY_SUBSET;
        }
        return new RDFPlainLiteralLengthValueSpaceSubset(arrayList);
    }

    @Override
    public ValueSpaceSubset conjoinWithDRNegation(ValueSpaceSubset valueSpaceSubset, DatatypeRestriction datatypeRestriction) {
        String string = datatypeRestriction.getDatatypeURI();
        assert (s_subsetsByDatatype.containsKey(string));
        if (valueSpaceSubset == EMPTY_SUBSET) {
            return EMPTY_SUBSET;
        }
        if (valueSpaceSubset instanceof RDFPlainLiteralPatternValueSpaceSubset || this.needsAutomatons(datatypeRestriction)) {
            Automaton automaton = this.getAutomatonFor(datatypeRestriction);
            if (automaton == null) {
                return valueSpaceSubset;
            }
            Automaton automaton2 = this.getAutomatonFor(valueSpaceSubset);
            if (automaton2 == null) {
                return EMPTY_SUBSET;
            }
            Automaton automaton3 = automaton2.minus(automaton);
            if (automaton3.isEmpty()) {
                return EMPTY_SUBSET;
            }
            return new RDFPlainLiteralPatternValueSpaceSubset(automaton3);
        }
        RDFPlainLiteralLengthInterval[] rDFPlainLiteralLengthIntervalArray = this.getIntervalsFor(datatypeRestriction);
        if (rDFPlainLiteralLengthIntervalArray[0] == null && rDFPlainLiteralLengthIntervalArray[1] == null) {
            return valueSpaceSubset;
        }
        ArrayList<RDFPlainLiteralLengthInterval> arrayList = new ArrayList<RDFPlainLiteralLengthInterval>(4);
        if (rDFPlainLiteralLengthIntervalArray[0] != null) {
            if (rDFPlainLiteralLengthIntervalArray[0].m_minLength > 0) {
                arrayList.add(new RDFPlainLiteralLengthInterval(RDFPlainLiteralLengthInterval.LanguageTagMode.PRESENT, 0, rDFPlainLiteralLengthIntervalArray[0].m_minLength - 1));
            }
            if (rDFPlainLiteralLengthIntervalArray[0].m_maxLength < Integer.MAX_VALUE) {
                arrayList.add(new RDFPlainLiteralLengthInterval(RDFPlainLiteralLengthInterval.LanguageTagMode.PRESENT, rDFPlainLiteralLengthIntervalArray[0].m_maxLength + 1, Integer.MAX_VALUE));
            }
        } else {
            arrayList.add(new RDFPlainLiteralLengthInterval(RDFPlainLiteralLengthInterval.LanguageTagMode.PRESENT, 0, Integer.MAX_VALUE));
        }
        if (rDFPlainLiteralLengthIntervalArray[1] != null) {
            if (rDFPlainLiteralLengthIntervalArray[1].m_minLength > 0) {
                arrayList.add(new RDFPlainLiteralLengthInterval(RDFPlainLiteralLengthInterval.LanguageTagMode.ABSENT, 0, rDFPlainLiteralLengthIntervalArray[1].m_minLength - 1));
            }
            if (rDFPlainLiteralLengthIntervalArray[1].m_maxLength < Integer.MAX_VALUE) {
                arrayList.add(new RDFPlainLiteralLengthInterval(RDFPlainLiteralLengthInterval.LanguageTagMode.ABSENT, rDFPlainLiteralLengthIntervalArray[1].m_maxLength + 1, Integer.MAX_VALUE));
            }
        } else {
            arrayList.add(new RDFPlainLiteralLengthInterval(RDFPlainLiteralLengthInterval.LanguageTagMode.ABSENT, 0, Integer.MAX_VALUE));
        }
        List<RDFPlainLiteralLengthInterval> list = ((RDFPlainLiteralLengthValueSpaceSubset)valueSpaceSubset).m_intervals;
        ArrayList<RDFPlainLiteralLengthInterval> arrayList2 = new ArrayList<RDFPlainLiteralLengthInterval>();
        for (int i = 0; i < list.size(); ++i) {
            RDFPlainLiteralLengthInterval rDFPlainLiteralLengthInterval = list.get(i);
            for (int j = arrayList.size() - 1; j >= 0; --j) {
                RDFPlainLiteralLengthInterval rDFPlainLiteralLengthInterval2 = (RDFPlainLiteralLengthInterval)arrayList.get(j);
                RDFPlainLiteralLengthInterval rDFPlainLiteralLengthInterval3 = rDFPlainLiteralLengthInterval.intersectWith(rDFPlainLiteralLengthInterval2);
                if (rDFPlainLiteralLengthInterval3 == null) continue;
                arrayList2.add(rDFPlainLiteralLengthInterval3);
            }
        }
        if (arrayList2.isEmpty()) {
            return EMPTY_SUBSET;
        }
        return new RDFPlainLiteralLengthValueSpaceSubset(arrayList2);
    }

    protected boolean needsAutomatons(DatatypeRestriction datatypeRestriction) {
        String string = datatypeRestriction.getDatatypeURI();
        if (s_subsetsByDatatype.get(string) instanceof RDFPlainLiteralLengthValueSpaceSubset) {
            for (int i = datatypeRestriction.getNumberOfFacetRestrictions() - 1; i >= 0; --i) {
                String string2 = datatypeRestriction.getFacetURI(i);
                if (!(XSD_NS + "pattern").equals(string2) && !(RDF_NS + "langRange").equals(string2)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected RDFPlainLiteralLengthInterval[] getIntervalsFor(DatatypeRestriction datatypeRestriction) {
        RDFPlainLiteralLengthInterval[] rDFPlainLiteralLengthIntervalArray = new RDFPlainLiteralLengthInterval[2];
        String string = datatypeRestriction.getDatatypeURI();
        assert (s_subsetsByDatatype.get(string) instanceof RDFPlainLiteralLengthValueSpaceSubset);
        int n = 0;
        int n2 = Integer.MAX_VALUE;
        for (int i = datatypeRestriction.getNumberOfFacetRestrictions() - 1; i >= 0; --i) {
            String string2 = datatypeRestriction.getFacetURI(i);
            assert ((XSD_NS + "minLength").equals(string2) || (XSD_NS + "maxLength").equals(string2) || (XSD_NS + "length").equals(string2));
            int n3 = (Integer)datatypeRestriction.getFacetValue(i).getDataValue();
            if ((XSD_NS + "minLength").equals(string2)) {
                n = Math.max(n, n3);
                continue;
            }
            if ((XSD_NS + "maxLength").equals(string2)) {
                n2 = Math.min(n2, n3);
                continue;
            }
            if (!(XSD_NS + "length").equals(string2)) continue;
            n = Math.max(n, n3);
            n2 = Math.min(n2, n3);
        }
        if (n <= n2) {
            if ((RDF_NS + "PlainLiteral").equals(string)) {
                rDFPlainLiteralLengthIntervalArray[0] = new RDFPlainLiteralLengthInterval(RDFPlainLiteralLengthInterval.LanguageTagMode.PRESENT, n, n2);
                rDFPlainLiteralLengthIntervalArray[1] = new RDFPlainLiteralLengthInterval(RDFPlainLiteralLengthInterval.LanguageTagMode.ABSENT, n, n2);
            } else if ((XSD_NS + "string").equals(string)) {
                rDFPlainLiteralLengthIntervalArray[1] = new RDFPlainLiteralLengthInterval(RDFPlainLiteralLengthInterval.LanguageTagMode.ABSENT, n, n2);
            }
        }
        return rDFPlainLiteralLengthIntervalArray;
    }

    protected Automaton getAutomatonFor(ValueSpaceSubset valueSpaceSubset) {
        if (valueSpaceSubset instanceof RDFPlainLiteralPatternValueSpaceSubset) {
            return ((RDFPlainLiteralPatternValueSpaceSubset)valueSpaceSubset).m_automaton;
        }
        return RDFPlainLiteralPatternValueSpaceSubset.toAutomaton((RDFPlainLiteralLengthValueSpaceSubset)valueSpaceSubset);
    }

    protected Automaton getAutomatonFor(DatatypeRestriction datatypeRestriction) {
        String string = datatypeRestriction.getDatatypeURI();
        Automaton automaton = RDFPlainLiteralPatternValueSpaceSubset.getDatatypeAutomaton(string);
        int n = 0;
        int n2 = Integer.MAX_VALUE;
        for (int i = datatypeRestriction.getNumberOfFacetRestrictions() - 1; i >= 0; --i) {
            Automaton automaton2;
            String string2;
            String string3 = datatypeRestriction.getFacetURI(i);
            Object object = datatypeRestriction.getFacetValue(i).getDataValue();
            if ((XSD_NS + "minLength").equals(string3)) {
                n = Math.max(n, (Integer)object);
                continue;
            }
            if ((XSD_NS + "maxLength").equals(string3)) {
                n2 = Math.min(n2, (Integer)object);
                continue;
            }
            if ((XSD_NS + "length").equals(string3)) {
                n = Math.max(n, (Integer)object);
                n2 = Math.min(n2, (Integer)object);
                continue;
            }
            if ((XSD_NS + "pattern").equals(string3)) {
                string2 = (String)object;
                automaton2 = RDFPlainLiteralPatternValueSpaceSubset.getPatternAutomaton(string2);
                automaton = automaton.intersection(automaton2);
                continue;
            }
            if ((RDF_NS + "langRange").equals(string3)) {
                string2 = (String)object;
                automaton2 = RDFPlainLiteralPatternValueSpaceSubset.getLanguageRangeAutomaton(string2);
                automaton = automaton.intersection(automaton2);
                continue;
            }
            throw new UnsupportedFacetException("Facet with URI '" + string3 + "' not supported on '" + string + "'.");
        }
        if (n > n2) {
            return null;
        }
        if (n != 0 || n2 != Integer.MAX_VALUE) {
            automaton = automaton.intersection(RDFPlainLiteralPatternValueSpaceSubset.toAutomaton(n, n2));
        }
        if (automaton.isEmpty()) {
            return null;
        }
        return automaton;
    }

    @Override
    public boolean isSubsetOf(String string, String string2) {
        assert (s_subsetsByDatatype.containsKey(string));
        assert (s_subsetsByDatatype.containsKey(string2));
        return s_datatypeSupersets.get(string).contains(string2);
    }

    @Override
    public boolean isDisjointWith(String string, String string2) {
        assert (s_subsetsByDatatype.containsKey(string));
        assert (s_subsetsByDatatype.containsKey(string2));
        return false;
    }

    static {
        s_subsetsByDatatype.put(RDF_NS + "PlainLiteral", new RDFPlainLiteralLengthValueSpaceSubset(new RDFPlainLiteralLengthInterval(RDFPlainLiteralLengthInterval.LanguageTagMode.ABSENT, 0, Integer.MAX_VALUE), new RDFPlainLiteralLengthInterval(RDFPlainLiteralLengthInterval.LanguageTagMode.PRESENT, 0, Integer.MAX_VALUE)));
        s_subsetsByDatatype.put(XSD_NS + "string", new RDFPlainLiteralLengthValueSpaceSubset(new RDFPlainLiteralLengthInterval(RDFPlainLiteralLengthInterval.LanguageTagMode.ABSENT, 0, Integer.MAX_VALUE)));
        RDFPlainLiteralDatatypeHandler.registerPatternDatatype(XSD_NS + "normalizedString");
        RDFPlainLiteralDatatypeHandler.registerPatternDatatype(XSD_NS + "token");
        RDFPlainLiteralDatatypeHandler.registerPatternDatatype(XSD_NS + "Name");
        RDFPlainLiteralDatatypeHandler.registerPatternDatatype(XSD_NS + "NCName");
        RDFPlainLiteralDatatypeHandler.registerPatternDatatype(XSD_NS + "NMTOKEN");
        RDFPlainLiteralDatatypeHandler.registerPatternDatatype(XSD_NS + "language");
        EMPTY_SUBSET = new RDFPlainLiteralLengthValueSpaceSubset();
        s_datatypeSupersets = new HashMap<String, Set<String>>();
        String[][] stringArrayArray = new String[][]{{RDF_NS + "PlainLiteral", RDF_NS + "PlainLiteral"}, {XSD_NS + "string", RDF_NS + "PlainLiteral", XSD_NS + "string"}, {XSD_NS + "normalizedString", RDF_NS + "PlainLiteral", XSD_NS + "string", XSD_NS + "normalizedString"}, {XSD_NS + "token", RDF_NS + "PlainLiteral", XSD_NS + "string", XSD_NS + "normalizedString", XSD_NS + "token"}, {XSD_NS + "Name", RDF_NS + "PlainLiteral", XSD_NS + "string", XSD_NS + "normalizedString", XSD_NS + "token", XSD_NS + "Name"}, {XSD_NS + "NCName", RDF_NS + "PlainLiteral", XSD_NS + "string", XSD_NS + "normalizedString", XSD_NS + "token", XSD_NS + "Name", XSD_NS + "NCName"}, {XSD_NS + "NMTOKEN", RDF_NS + "PlainLiteral", XSD_NS + "string", XSD_NS + "normalizedString", XSD_NS + "token", XSD_NS + "NMTOKEN"}, {XSD_NS + "language", RDF_NS + "PlainLiteral", XSD_NS + "string", XSD_NS + "normalizedString", XSD_NS + "token", XSD_NS + "language"}};
        for (int i = 0; i < stringArrayArray.length; ++i) {
            String string = stringArrayArray[i][0];
            HashSet<String> hashSet = new HashSet<String>();
            for (int j = 1; j < stringArrayArray[i].length; ++j) {
                hashSet.add(stringArrayArray[i][j]);
            }
            s_datatypeSupersets.put(string, hashSet);
        }
    }
}

