/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.datatypes.owlreal;

import java.util.Collection;
import org.semanticweb.HermiT.datatypes.owlreal.BoundType;
import org.semanticweb.HermiT.datatypes.owlreal.MinusInfinity;
import org.semanticweb.HermiT.datatypes.owlreal.NumberRange;
import org.semanticweb.HermiT.datatypes.owlreal.Numbers;
import org.semanticweb.HermiT.datatypes.owlreal.PlusInfinity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberInterval {
    protected final NumberRange m_baseRange;
    protected final NumberRange m_excludedRange;
    protected final Number m_lowerBound;
    protected final BoundType m_lowerBoundType;
    protected final Number m_upperBound;
    protected final BoundType m_upperBoundType;

    public NumberInterval(NumberRange numberRange, NumberRange numberRange2, Number number, BoundType boundType, Number number2, BoundType boundType2) {
        assert (!NumberInterval.isIntervalEmpty(numberRange, numberRange2, number, boundType, number2, boundType2));
        this.m_baseRange = numberRange;
        this.m_excludedRange = numberRange2;
        if (this.m_baseRange == NumberRange.INTEGER) {
            if (MinusInfinity.INSTANCE.equals(number)) {
                this.m_lowerBound = number;
                this.m_lowerBoundType = boundType;
            } else {
                this.m_lowerBound = Numbers.getNearestIntegerInBound(number, Numbers.BoundaryDirection.LOWER, boundType == BoundType.INCLUSIVE);
                this.m_lowerBoundType = BoundType.INCLUSIVE;
            }
            if (PlusInfinity.INSTANCE.equals(number2)) {
                this.m_upperBound = number2;
                this.m_upperBoundType = boundType2;
            } else {
                this.m_upperBound = Numbers.getNearestIntegerInBound(number2, Numbers.BoundaryDirection.UPPER, boundType2 == BoundType.INCLUSIVE);
                this.m_upperBoundType = BoundType.INCLUSIVE;
            }
        } else {
            this.m_lowerBound = number;
            this.m_lowerBoundType = boundType;
            this.m_upperBound = number2;
            this.m_upperBoundType = boundType2;
        }
    }

    public NumberInterval intersectWith(NumberInterval numberInterval) {
        BoundType boundType;
        Number number;
        BoundType boundType2;
        Number number2;
        NumberRange numberRange;
        NumberRange numberRange2 = NumberRange.intersection(this.m_baseRange, numberInterval.m_baseRange);
        if (NumberRange.isSubsetOf(numberRange2, numberRange = NumberRange.union(this.m_excludedRange, numberInterval.m_excludedRange))) {
            return null;
        }
        int n = Numbers.compare(this.m_lowerBound, numberInterval.m_lowerBound);
        if (n < 0) {
            number2 = numberInterval.m_lowerBound;
            boundType2 = numberInterval.m_lowerBoundType;
        } else if (n > 0) {
            number2 = this.m_lowerBound;
            boundType2 = this.m_lowerBoundType;
        } else {
            number2 = this.m_lowerBound;
            boundType2 = BoundType.getMoreRestrictive(this.m_lowerBoundType, numberInterval.m_lowerBoundType);
        }
        int n2 = Numbers.compare(this.m_upperBound, numberInterval.m_upperBound);
        if (n2 < 0) {
            number = this.m_upperBound;
            boundType = this.m_upperBoundType;
        } else if (n2 > 0) {
            number = numberInterval.m_upperBound;
            boundType = numberInterval.m_upperBoundType;
        } else {
            number = this.m_upperBound;
            boundType = BoundType.getMoreRestrictive(this.m_upperBoundType, numberInterval.m_upperBoundType);
        }
        if (NumberInterval.isIntervalEmpty(numberRange2, numberRange, number2, boundType2, number, boundType)) {
            return null;
        }
        if (this.isEqual(numberRange2, numberRange, number2, boundType2, number, boundType)) {
            return this;
        }
        if (numberInterval.isEqual(numberRange2, numberRange, number2, boundType2, number, boundType)) {
            return numberInterval;
        }
        return new NumberInterval(numberRange2, numberRange, number2, boundType2, number, boundType);
    }

    protected boolean isEqual(NumberRange numberRange, NumberRange numberRange2, Number number, BoundType boundType, Number number2, BoundType boundType2) {
        return this.m_baseRange.equals((Object)numberRange) && this.m_excludedRange.equals((Object)numberRange2) && this.m_lowerBound.equals(number) && this.m_lowerBoundType.equals((Object)boundType) && this.m_upperBound.equals(number2) && this.m_upperBoundType.equals((Object)boundType2);
    }

    public int subtractSizeFrom(int n) {
        if (n <= 0) {
            return 0;
        }
        if (this.m_lowerBound.equals(this.m_upperBound)) {
            return n - 1;
        }
        if (this.m_baseRange.isDense()) {
            return 0;
        }
        if (MinusInfinity.INSTANCE.equals(this.m_lowerBound) || PlusInfinity.INSTANCE.equals(this.m_upperBound)) {
            return 0;
        }
        return Numbers.subtractIntegerIntervalSizeFrom(this.m_lowerBound, this.m_upperBound, n);
    }

    public boolean containsNumber(Number number) {
        NumberRange numberRange = NumberRange.getMostSpecificRange(number);
        if (!NumberRange.isSubsetOf(numberRange, this.m_baseRange) || NumberRange.isSubsetOf(numberRange, this.m_excludedRange)) {
            return false;
        }
        int n = Numbers.compare(this.m_lowerBound, number);
        if (n > 0 || n == 0 && this.m_lowerBoundType == BoundType.EXCLUSIVE) {
            return false;
        }
        int n2 = Numbers.compare(this.m_upperBound, number);
        return n2 >= 0 && (n2 != 0 || this.m_upperBoundType != BoundType.EXCLUSIVE);
    }

    public void enumerateNumbers(Collection<Object> collection) {
        if (this.m_lowerBound.equals(this.m_upperBound)) {
            collection.add(this.m_lowerBound);
        } else {
            if (this.m_baseRange.isDense()) {
                throw new IllegalStateException("The data range is infinite.");
            }
            if (MinusInfinity.INSTANCE.equals(this.m_lowerBound) || PlusInfinity.INSTANCE.equals(this.m_upperBound)) {
                throw new IllegalStateException("The data range is infinite.");
            }
            Number number = this.m_lowerBound;
            while (!number.equals(this.m_upperBound)) {
                collection.add(number);
                number = Numbers.nextInteger(number);
            }
            collection.add(this.m_upperBound);
        }
    }

    protected static boolean isIntervalEmpty(NumberRange numberRange, NumberRange numberRange2, Number number, BoundType boundType, Number number2, BoundType boundType2) {
        if (NumberRange.isSubsetOf(numberRange, numberRange2)) {
            return true;
        }
        int n = Numbers.compare(number, number2);
        if (n > 0) {
            return true;
        }
        if (n == 0) {
            if (boundType == BoundType.EXCLUSIVE || boundType2 == BoundType.EXCLUSIVE || MinusInfinity.INSTANCE.equals(number) || PlusInfinity.INSTANCE.equals(number)) {
                return true;
            }
            NumberRange numberRange3 = NumberRange.getMostSpecificRange(number);
            return !NumberRange.isSubsetOf(numberRange3, numberRange) || NumberRange.isSubsetOf(numberRange3, numberRange2);
        }
        if (numberRange.isDense()) {
            return false;
        }
        if (MinusInfinity.INSTANCE.equals(number) || PlusInfinity.INSTANCE.equals(number2)) {
            return false;
        }
        Number number3 = Numbers.getNearestIntegerInBound(number, Numbers.BoundaryDirection.LOWER, boundType == BoundType.INCLUSIVE);
        Number number4 = Numbers.getNearestIntegerInBound(number2, Numbers.BoundaryDirection.UPPER, boundType2 == BoundType.INCLUSIVE);
        return Numbers.compare(number3, number4) > 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.m_baseRange.toString());
        if (this.m_excludedRange != NumberRange.NOTHING) {
            stringBuffer.append('\\');
            stringBuffer.append(this.m_excludedRange.toString());
        }
        if (this.m_lowerBoundType == BoundType.INCLUSIVE) {
            stringBuffer.append('[');
        } else {
            stringBuffer.append('<');
        }
        stringBuffer.append(this.m_lowerBound.toString());
        stringBuffer.append(" .. ");
        stringBuffer.append(this.m_upperBound.toString());
        if (this.m_upperBoundType == BoundType.INCLUSIVE) {
            stringBuffer.append(']');
        } else {
            stringBuffer.append('>');
        }
        return stringBuffer.toString();
    }
}

