/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.datatypes.floatnum;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.HermiT.Prefixes;
import org.semanticweb.HermiT.datatypes.DatatypeHandler;
import org.semanticweb.HermiT.datatypes.MalformedLiteralException;
import org.semanticweb.HermiT.datatypes.UnsupportedFacetException;
import org.semanticweb.HermiT.datatypes.ValueSpaceSubset;
import org.semanticweb.HermiT.datatypes.floatnum.EmptyFloatSubset;
import org.semanticweb.HermiT.datatypes.floatnum.EntireFloatSubset;
import org.semanticweb.HermiT.datatypes.floatnum.FloatInterval;
import org.semanticweb.HermiT.datatypes.floatnum.NoNaNFloatSubset;
import org.semanticweb.HermiT.model.DatatypeRestriction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatDatatypeHandler
implements DatatypeHandler {
    protected static final String XSD_NS = Prefixes.s_semanticWebPrefixes.get("xsd");
    protected static final String XSD_FLOAT = XSD_NS + "float";
    protected static final ValueSpaceSubset FLOAT_ENTIRE = new EntireFloatSubset();
    protected static final ValueSpaceSubset EMPTY_SUBSET = new EmptyFloatSubset();
    protected static final Set<String> s_managedDatatypeURIs = Collections.singleton(XSD_FLOAT);
    protected static final Set<String> s_supportedFacetURIs = new HashSet<String>();

    @Override
    public Set<String> getManagedDatatypeURIs() {
        return s_managedDatatypeURIs;
    }

    @Override
    public Object parseLiteral(String string, String string2) throws MalformedLiteralException {
        assert (XSD_FLOAT.equals(string2));
        try {
            return Float.valueOf(Float.parseFloat(string));
        }
        catch (NumberFormatException numberFormatException) {
            if (string.equals("INF")) {
                return Float.valueOf(Float.POSITIVE_INFINITY);
            }
            if (string.equals("-INF")) {
                return Float.valueOf(Float.NEGATIVE_INFINITY);
            }
            throw new MalformedLiteralException(string, string2);
        }
    }

    @Override
    public void validateDatatypeRestriction(DatatypeRestriction datatypeRestriction) throws UnsupportedFacetException {
        assert (XSD_FLOAT.equals(datatypeRestriction.getDatatypeURI()));
        for (int i = datatypeRestriction.getNumberOfFacetRestrictions() - 1; i >= 0; --i) {
            String string = datatypeRestriction.getFacetURI(i);
            if (!s_supportedFacetURIs.contains(string)) {
                throw new UnsupportedFacetException("A facet with URI '" + string + "' is not supported on xsd:float. The xsd:float datatype supports only xsd:minInclusive, xsd:maxInclusive, xsd:minExclusive, and xsd:maxExclusive, but the ontology contains a datatype restriction " + this.toString());
            }
            Object object = datatypeRestriction.getFacetValue(i).getDataValue();
            if (object instanceof Float) continue;
            throw new UnsupportedFacetException("The '" + string + "' facet takes only floats as values when used on an xsd:float datatype, but the ontology contains a datatype restriction " + this.toString());
        }
    }

    @Override
    public ValueSpaceSubset createValueSpaceSubset(DatatypeRestriction datatypeRestriction) {
        assert (XSD_FLOAT.equals(datatypeRestriction.getDatatypeURI()));
        if (datatypeRestriction.getNumberOfFacetRestrictions() == 0) {
            return FLOAT_ENTIRE;
        }
        FloatInterval floatInterval = this.getIntervalFor(datatypeRestriction);
        if (floatInterval == null) {
            return EMPTY_SUBSET;
        }
        return new NoNaNFloatSubset(floatInterval);
    }

    @Override
    public ValueSpaceSubset conjoinWithDR(ValueSpaceSubset valueSpaceSubset, DatatypeRestriction datatypeRestriction) {
        assert (XSD_FLOAT.equals(datatypeRestriction.getDatatypeURI()));
        if (datatypeRestriction.getNumberOfFacetRestrictions() == 0 || valueSpaceSubset == EMPTY_SUBSET) {
            return valueSpaceSubset;
        }
        FloatInterval floatInterval = this.getIntervalFor(datatypeRestriction);
        if (floatInterval == null) {
            return EMPTY_SUBSET;
        }
        if (valueSpaceSubset == FLOAT_ENTIRE) {
            return new NoNaNFloatSubset(floatInterval);
        }
        NoNaNFloatSubset noNaNFloatSubset = (NoNaNFloatSubset)valueSpaceSubset;
        List<FloatInterval> list = noNaNFloatSubset.m_intervals;
        ArrayList<FloatInterval> arrayList = new ArrayList<FloatInterval>();
        for (int i = 0; i < list.size(); ++i) {
            FloatInterval floatInterval2 = list.get(i);
            FloatInterval floatInterval3 = floatInterval2.intersectWith(floatInterval);
            if (floatInterval3 == null) continue;
            arrayList.add(floatInterval3);
        }
        if (arrayList.isEmpty()) {
            return EMPTY_SUBSET;
        }
        return new NoNaNFloatSubset(arrayList);
    }

    @Override
    public ValueSpaceSubset conjoinWithDRNegation(ValueSpaceSubset valueSpaceSubset, DatatypeRestriction datatypeRestriction) {
        assert (XSD_FLOAT.equals(datatypeRestriction.getDatatypeURI()));
        if (datatypeRestriction.getNumberOfFacetRestrictions() == 0 || valueSpaceSubset == EMPTY_SUBSET) {
            return EMPTY_SUBSET;
        }
        FloatInterval floatInterval = this.getIntervalFor(datatypeRestriction);
        if (floatInterval == null) {
            return valueSpaceSubset;
        }
        if (valueSpaceSubset == FLOAT_ENTIRE) {
            ArrayList<FloatInterval> arrayList = new ArrayList<FloatInterval>();
            if (!FloatInterval.areIdentical(floatInterval.m_lowerBoundInclusive, Float.NEGATIVE_INFINITY)) {
                arrayList.add(new FloatInterval(Float.NEGATIVE_INFINITY, FloatInterval.previousFloat(floatInterval.m_lowerBoundInclusive)));
            }
            if (!FloatInterval.areIdentical(floatInterval.m_upperBoundInclusive, Float.POSITIVE_INFINITY)) {
                arrayList.add(new FloatInterval(FloatInterval.nextFloat(floatInterval.m_upperBoundInclusive), Float.POSITIVE_INFINITY));
            }
            if (arrayList.isEmpty()) {
                return EMPTY_SUBSET;
            }
            return new NoNaNFloatSubset(arrayList);
        }
        NoNaNFloatSubset noNaNFloatSubset = (NoNaNFloatSubset)valueSpaceSubset;
        FloatInterval floatInterval2 = null;
        if (!FloatInterval.areIdentical(floatInterval.m_lowerBoundInclusive, Float.NEGATIVE_INFINITY)) {
            floatInterval2 = new FloatInterval(Float.NEGATIVE_INFINITY, FloatInterval.previousFloat(floatInterval.m_lowerBoundInclusive));
        }
        FloatInterval floatInterval3 = null;
        if (!FloatInterval.areIdentical(floatInterval.m_upperBoundInclusive, Float.POSITIVE_INFINITY)) {
            floatInterval3 = new FloatInterval(FloatInterval.nextFloat(floatInterval.m_upperBoundInclusive), Float.POSITIVE_INFINITY);
        }
        List<FloatInterval> list = noNaNFloatSubset.m_intervals;
        ArrayList<FloatInterval> arrayList = new ArrayList<FloatInterval>();
        for (int i = 0; i < list.size(); ++i) {
            FloatInterval floatInterval4;
            FloatInterval floatInterval5 = list.get(i);
            if (floatInterval2 != null && (floatInterval4 = floatInterval5.intersectWith(floatInterval2)) != null) {
                arrayList.add(floatInterval4);
            }
            if (floatInterval3 == null || (floatInterval4 = floatInterval5.intersectWith(floatInterval3)) == null) continue;
            arrayList.add(floatInterval4);
        }
        if (arrayList.isEmpty()) {
            return EMPTY_SUBSET;
        }
        return new NoNaNFloatSubset(arrayList);
    }

    protected FloatInterval getIntervalFor(DatatypeRestriction datatypeRestriction) {
        assert (datatypeRestriction.getNumberOfFacetRestrictions() != 0);
        float f = Float.NEGATIVE_INFINITY;
        float f2 = Float.POSITIVE_INFINITY;
        for (int i = datatypeRestriction.getNumberOfFacetRestrictions() - 1; i >= 0; --i) {
            String string = datatypeRestriction.getFacetURI(i);
            float f3 = ((Float)datatypeRestriction.getFacetValue(i).getDataValue()).floatValue();
            if ((XSD_NS + "minInclusive").equals(string)) {
                if (FloatInterval.areIdentical(f3, 0.0f)) {
                    f3 = -0.0f;
                }
                if (!FloatInterval.isSmallerEqual(f, f3)) continue;
                f = f3;
                continue;
            }
            if ((XSD_NS + "minExclusive").equals(string)) {
                if (FloatInterval.areIdentical(f3, -0.0f)) {
                    f3 = 0.0f;
                }
                if (!FloatInterval.isSmallerEqual(f, f3 = FloatInterval.nextFloat(f3))) continue;
                f = f3;
                continue;
            }
            if ((XSD_NS + "maxInclusive").equals(string)) {
                if (FloatInterval.areIdentical(f3, -0.0f)) {
                    f3 = 0.0f;
                }
                if (!FloatInterval.isSmallerEqual(f3, f2)) continue;
                f2 = f3;
                continue;
            }
            if ((XSD_NS + "maxExclusive").equals(string)) {
                if (FloatInterval.areIdentical(f3, 0.0f)) {
                    f3 = -0.0f;
                }
                if (!FloatInterval.isSmallerEqual(f3 = FloatInterval.previousFloat(f3), f2)) continue;
                f2 = f3;
                continue;
            }
            throw new IllegalStateException("Internal error: facet '" + string + "' is not supported by xsd:float.");
        }
        if (FloatInterval.isIntervalEmpty(f, f2)) {
            return null;
        }
        return new FloatInterval(f, f2);
    }

    @Override
    public boolean isSubsetOf(String string, String string2) {
        assert (XSD_FLOAT.equals(string));
        assert (XSD_FLOAT.equals(string2));
        return true;
    }

    @Override
    public boolean isDisjointWith(String string, String string2) {
        assert (XSD_FLOAT.equals(string));
        assert (XSD_FLOAT.equals(string2));
        return false;
    }

    static {
        s_supportedFacetURIs.add(XSD_NS + "minInclusive");
        s_supportedFacetURIs.add(XSD_NS + "minExclusive");
        s_supportedFacetURIs.add(XSD_NS + "maxInclusive");
        s_supportedFacetURIs.add(XSD_NS + "maxExclusive");
    }
}

