/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.semanticweb.HermiT.Reasoner;
import org.semanticweb.HermiT.model.AtomicRole;
import org.semanticweb.HermiT.model.InternalDatatype;
import org.semanticweb.HermiT.tableau.ReasoningTaskDescription;
import org.semanticweb.HermiT.tableau.Tableau;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntailmentChecker
implements OWLAxiomVisitorEx<Boolean> {
    private final OWLDataFactory factory;
    private final Reasoner reasoner;
    protected Set<OWLAxiom> anonymousIndividualAxioms = new HashSet<OWLAxiom>();

    public EntailmentChecker(Reasoner reasoner, OWLDataFactory oWLDataFactory) {
        this.reasoner = reasoner;
        this.factory = oWLDataFactory;
    }

    public boolean entails(Set<? extends OWLAxiom> set) {
        this.anonymousIndividualAxioms.clear();
        for (OWLAxiom oWLAxiom : set) {
            if (!oWLAxiom.isLogicalAxiom() || ((Boolean)oWLAxiom.accept((OWLAxiomVisitorEx)this)).booleanValue()) continue;
            return false;
        }
        return this.checkAnonymousIndividuals();
    }

    public boolean entails(OWLAxiom oWLAxiom) {
        if (!((Boolean)oWLAxiom.accept((OWLAxiomVisitorEx)this)).booleanValue()) {
            return false;
        }
        return this.checkAnonymousIndividuals();
    }

    protected boolean checkAnonymousIndividuals() {
        if (this.anonymousIndividualAxioms.isEmpty()) {
            return true;
        }
        AnonymousIndividualForestBuilder anonymousIndividualForestBuilder = new AnonymousIndividualForestBuilder();
        anonymousIndividualForestBuilder.constructConceptsForAnonymousIndividuals(this.factory, this.anonymousIndividualAxioms);
        for (OWLAxiom oWLAxiom : anonymousIndividualForestBuilder.getAnonIndAxioms()) {
            if (((Boolean)oWLAxiom.accept((OWLAxiomVisitorEx)this)).booleanValue()) continue;
            return false;
        }
        for (OWLAxiom oWLAxiom : anonymousIndividualForestBuilder.getAnonNoNamedIndAxioms()) {
            Tableau tableau = this.reasoner.getTableau(oWLAxiom);
            if (!tableau.isSatisfiable(true, true, null, null, null, null, null, new ReasoningTaskDescription(false, "Anonymous individual check: " + oWLAxiom.toString(), new Object[0]))) continue;
            return false;
        }
        return true;
    }

    public Boolean visit(OWLAnnotationAssertionAxiom oWLAnnotationAssertionAxiom) {
        return Boolean.TRUE;
    }

    public Boolean visit(OWLSubAnnotationPropertyOfAxiom oWLSubAnnotationPropertyOfAxiom) {
        return Boolean.TRUE;
    }

    public Boolean visit(OWLAnnotationPropertyDomainAxiom oWLAnnotationPropertyDomainAxiom) {
        return Boolean.TRUE;
    }

    public Boolean visit(OWLAnnotationPropertyRangeAxiom oWLAnnotationPropertyRangeAxiom) {
        return Boolean.TRUE;
    }

    public Boolean visit(OWLDeclarationAxiom oWLDeclarationAxiom) {
        return Boolean.TRUE;
    }

    public Boolean visit(OWLImportsDeclaration oWLImportsDeclaration) {
        return Boolean.TRUE;
    }

    public Boolean visit(OWLDifferentIndividualsAxiom oWLDifferentIndividualsAxiom) {
        ArrayList arrayList = new ArrayList(oWLDifferentIndividualsAxiom.getIndividuals());
        for (OWLIndividual oWLIndividual : arrayList) {
            if (!oWLIndividual.isAnonymous()) continue;
            throw new IllegalArgumentException("OWLDifferentIndividualsAxiom axioms are not allowed to be used with anonymous individuals (see OWL 2 Syntax Sec 11.2) but the axiom " + oWLDifferentIndividualsAxiom + " cotains an anonymous individual. ");
        }
        for (int i = 0; i < arrayList.size() - 1; ++i) {
            OWLIndividual oWLIndividual;
            oWLIndividual = ((OWLIndividual)arrayList.get(i)).asOWLNamedIndividual();
            for (int j = i + 1; j < arrayList.size(); ++j) {
                OWLNamedIndividual oWLNamedIndividual = ((OWLIndividual)arrayList.get(j)).asOWLNamedIndividual();
                if (this.reasoner.hasType((OWLNamedIndividual)oWLIndividual, (OWLClassExpression)this.factory.getOWLObjectComplementOf((OWLClassExpression)this.factory.getOWLObjectOneOf(new OWLIndividual[]{oWLNamedIndividual})), false)) continue;
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    public Boolean visit(OWLSameIndividualAxiom oWLSameIndividualAxiom) {
        for (OWLIndividual oWLIndividual : oWLSameIndividualAxiom.getIndividuals()) {
            if (!oWLIndividual.isAnonymous()) continue;
            throw new IllegalArgumentException("OWLSameIndividualAxiom axioms are not allowed to be used with anonymous individuals (see OWL 2 Syntax Sec 11.2) but the axiom " + oWLSameIndividualAxiom + " cotains an anonymous individual. ");
        }
        Iterator iterator = oWLSameIndividualAxiom.getIndividuals().iterator();
        if (iterator.hasNext()) {
            OWLIndividual oWLIndividual;
            oWLIndividual = ((OWLIndividual)iterator.next()).asOWLNamedIndividual();
            while (iterator.hasNext()) {
                OWLNamedIndividual oWLNamedIndividual = ((OWLIndividual)iterator.next()).asOWLNamedIndividual();
                if (this.reasoner.isSameIndividual((OWLNamedIndividual)oWLIndividual, oWLNamedIndividual)) continue;
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    public Boolean visit(OWLClassAssertionAxiom oWLClassAssertionAxiom) {
        OWLIndividual oWLIndividual = oWLClassAssertionAxiom.getIndividual();
        if (oWLIndividual.isAnonymous()) {
            this.anonymousIndividualAxioms.add((OWLAxiom)oWLClassAssertionAxiom);
            return true;
        }
        OWLClassExpression oWLClassExpression = oWLClassAssertionAxiom.getClassExpression();
        return this.reasoner.hasType(oWLIndividual.asOWLNamedIndividual(), oWLClassExpression, false);
    }

    public Boolean visit(OWLObjectPropertyAssertionAxiom oWLObjectPropertyAssertionAxiom) {
        OWLIndividual oWLIndividual = oWLObjectPropertyAssertionAxiom.getSubject();
        OWLIndividual oWLIndividual2 = (OWLIndividual)oWLObjectPropertyAssertionAxiom.getObject();
        if (oWLIndividual.isAnonymous() || oWLIndividual2.isAnonymous()) {
            this.anonymousIndividualAxioms.add((OWLAxiom)oWLObjectPropertyAssertionAxiom);
            return true;
        }
        return this.reasoner.hasObjectPropertyRelationship(oWLIndividual.asOWLNamedIndividual(), (OWLObjectPropertyExpression)oWLObjectPropertyAssertionAxiom.getProperty(), oWLIndividual2.asOWLNamedIndividual());
    }

    public Boolean visit(OWLNegativeObjectPropertyAssertionAxiom oWLNegativeObjectPropertyAssertionAxiom) {
        if (oWLNegativeObjectPropertyAssertionAxiom.getSubject().isAnonymous() || ((OWLIndividual)oWLNegativeObjectPropertyAssertionAxiom.getObject()).isAnonymous()) {
            throw new IllegalArgumentException("NegativeObjectPropertyAssertion axioms are not allowed to be used with anonymous individuals (see OWL 2 Syntax Sec 11.2) but the axiom " + oWLNegativeObjectPropertyAssertionAxiom + " cotains an anonymous subject or object. ");
        }
        OWLObjectHasValue oWLObjectHasValue = this.factory.getOWLObjectHasValue((OWLObjectPropertyExpression)oWLNegativeObjectPropertyAssertionAxiom.getProperty(), (OWLIndividual)oWLNegativeObjectPropertyAssertionAxiom.getObject());
        OWLObjectComplementOf oWLObjectComplementOf = this.factory.getOWLObjectComplementOf((OWLClassExpression)oWLObjectHasValue);
        return this.reasoner.hasType(oWLNegativeObjectPropertyAssertionAxiom.getSubject().asOWLNamedIndividual(), (OWLClassExpression)oWLObjectComplementOf, false);
    }

    public Boolean visit(OWLDataPropertyAssertionAxiom oWLDataPropertyAssertionAxiom) {
        OWLIndividual oWLIndividual = oWLDataPropertyAssertionAxiom.getSubject();
        if (oWLIndividual.isAnonymous()) {
            this.anonymousIndividualAxioms.add((OWLAxiom)oWLDataPropertyAssertionAxiom);
            return true;
        }
        return this.reasoner.hasDataPropertyRelationship(oWLIndividual.asOWLNamedIndividual(), ((OWLDataPropertyExpression)oWLDataPropertyAssertionAxiom.getProperty()).asOWLDataProperty(), (OWLLiteral)oWLDataPropertyAssertionAxiom.getObject());
    }

    public Boolean visit(OWLNegativeDataPropertyAssertionAxiom oWLNegativeDataPropertyAssertionAxiom) {
        if (oWLNegativeDataPropertyAssertionAxiom.getSubject().isAnonymous()) {
            throw new IllegalArgumentException("NegativeDataPropertyAssertion axioms are not allowed to be used with anonymous individuals (see OWL 2 Syntax Sec 11.2) and the subject " + oWLNegativeDataPropertyAssertionAxiom.getSubject() + " of the axiom " + oWLNegativeDataPropertyAssertionAxiom + " is anonymous. ");
        }
        OWLDataHasValue oWLDataHasValue = this.factory.getOWLDataHasValue((OWLDataPropertyExpression)oWLNegativeDataPropertyAssertionAxiom.getProperty(), (OWLLiteral)oWLNegativeDataPropertyAssertionAxiom.getObject());
        OWLObjectComplementOf oWLObjectComplementOf = this.factory.getOWLObjectComplementOf((OWLClassExpression)oWLDataHasValue);
        return this.reasoner.hasType(oWLNegativeDataPropertyAssertionAxiom.getSubject().asOWLNamedIndividual(), (OWLClassExpression)oWLObjectComplementOf, false);
    }

    public Boolean visit(OWLObjectPropertyDomainAxiom oWLObjectPropertyDomainAxiom) {
        return this.reasoner.isSubClassOf((OWLClassExpression)this.factory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)oWLObjectPropertyDomainAxiom.getProperty(), (OWLClassExpression)this.factory.getOWLThing()), oWLObjectPropertyDomainAxiom.getDomain());
    }

    public Boolean visit(OWLObjectPropertyRangeAxiom oWLObjectPropertyRangeAxiom) {
        return this.reasoner.isSubClassOf((OWLClassExpression)this.factory.getOWLThing(), (OWLClassExpression)this.factory.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)oWLObjectPropertyRangeAxiom.getProperty(), (OWLClassExpression)oWLObjectPropertyRangeAxiom.getRange()));
    }

    public Boolean visit(OWLInverseObjectPropertiesAxiom oWLInverseObjectPropertiesAxiom) {
        OWLObjectPropertyExpression oWLObjectPropertyExpression;
        OWLObjectPropertyExpression oWLObjectPropertyExpression2 = oWLInverseObjectPropertiesAxiom.getFirstProperty().getInverseProperty();
        return this.reasoner.isSubObjectPropertyExpressionOf(oWLObjectPropertyExpression2, oWLObjectPropertyExpression = oWLInverseObjectPropertiesAxiom.getSecondProperty()) && this.reasoner.isSubObjectPropertyExpressionOf(oWLObjectPropertyExpression, oWLObjectPropertyExpression2);
    }

    public Boolean visit(OWLSymmetricObjectPropertyAxiom oWLSymmetricObjectPropertyAxiom) {
        return this.reasoner.isSymmetric((OWLObjectPropertyExpression)oWLSymmetricObjectPropertyAxiom.getProperty());
    }

    public Boolean visit(OWLTransitiveObjectPropertyAxiom oWLTransitiveObjectPropertyAxiom) {
        return this.reasoner.isTransitive((OWLObjectPropertyExpression)oWLTransitiveObjectPropertyAxiom.getProperty());
    }

    public Boolean visit(OWLReflexiveObjectPropertyAxiom oWLReflexiveObjectPropertyAxiom) {
        return this.reasoner.isReflexive((OWLObjectPropertyExpression)oWLReflexiveObjectPropertyAxiom.getProperty());
    }

    public Boolean visit(OWLIrreflexiveObjectPropertyAxiom oWLIrreflexiveObjectPropertyAxiom) {
        return this.reasoner.isIrreflexive((OWLObjectPropertyExpression)oWLIrreflexiveObjectPropertyAxiom.getProperty());
    }

    public Boolean visit(OWLAsymmetricObjectPropertyAxiom oWLAsymmetricObjectPropertyAxiom) {
        return this.reasoner.isAsymmetric((OWLObjectPropertyExpression)oWLAsymmetricObjectPropertyAxiom.getProperty());
    }

    public Boolean visit(OWLEquivalentObjectPropertiesAxiom oWLEquivalentObjectPropertiesAxiom) {
        Set set = oWLEquivalentObjectPropertiesAxiom.getProperties();
        Iterator iterator = set.iterator();
        if (iterator.hasNext()) {
            OWLObjectPropertyExpression oWLObjectPropertyExpression = (OWLObjectPropertyExpression)iterator.next();
            while (iterator.hasNext()) {
                OWLObjectPropertyExpression oWLObjectPropertyExpression2 = (OWLObjectPropertyExpression)iterator.next();
                if (this.reasoner.isSubObjectPropertyExpressionOf(oWLObjectPropertyExpression, oWLObjectPropertyExpression2) && this.reasoner.isSubObjectPropertyExpressionOf(oWLObjectPropertyExpression2, oWLObjectPropertyExpression)) continue;
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    public Boolean visit(OWLSubObjectPropertyOfAxiom oWLSubObjectPropertyOfAxiom) {
        return this.reasoner.isSubObjectPropertyExpressionOf((OWLObjectPropertyExpression)oWLSubObjectPropertyOfAxiom.getSubProperty(), (OWLObjectPropertyExpression)oWLSubObjectPropertyOfAxiom.getSuperProperty());
    }

    public Boolean visit(OWLSubPropertyChainOfAxiom oWLSubPropertyChainOfAxiom) {
        return this.reasoner.isSubObjectPropertyExpressionOf(oWLSubPropertyChainOfAxiom.getPropertyChain(), oWLSubPropertyChainOfAxiom.getSuperProperty());
    }

    public Boolean visit(OWLDisjointObjectPropertiesAxiom oWLDisjointObjectPropertiesAxiom) {
        int n = oWLDisjointObjectPropertiesAxiom.getProperties().size();
        OWLObjectPropertyExpression[] oWLObjectPropertyExpressionArray = oWLDisjointObjectPropertiesAxiom.getProperties().toArray(new OWLObjectPropertyExpression[n]);
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                if (this.reasoner.isDisjointObjectProperty(oWLObjectPropertyExpressionArray[i], oWLObjectPropertyExpressionArray[j])) continue;
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    public Boolean visit(OWLFunctionalObjectPropertyAxiom oWLFunctionalObjectPropertyAxiom) {
        return this.reasoner.isFunctional((OWLObjectPropertyExpression)oWLFunctionalObjectPropertyAxiom.getProperty());
    }

    public Boolean visit(OWLInverseFunctionalObjectPropertyAxiom oWLInverseFunctionalObjectPropertyAxiom) {
        return this.reasoner.isInverseFunctional((OWLObjectPropertyExpression)oWLInverseFunctionalObjectPropertyAxiom.getProperty());
    }

    public Boolean visit(OWLDataPropertyDomainAxiom oWLDataPropertyDomainAxiom) {
        return this.reasoner.isSubClassOf((OWLClassExpression)this.factory.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)oWLDataPropertyDomainAxiom.getProperty(), (OWLDataRange)this.factory.getTopDatatype()), oWLDataPropertyDomainAxiom.getDomain());
    }

    public Boolean visit(OWLDataPropertyRangeAxiom oWLDataPropertyRangeAxiom) {
        return this.reasoner.isSubClassOf((OWLClassExpression)this.factory.getOWLThing(), (OWLClassExpression)this.factory.getOWLDataAllValuesFrom((OWLDataPropertyExpression)oWLDataPropertyRangeAxiom.getProperty(), (OWLDataRange)oWLDataPropertyRangeAxiom.getRange()));
    }

    public Boolean visit(OWLEquivalentDataPropertiesAxiom oWLEquivalentDataPropertiesAxiom) {
        Set set = oWLEquivalentDataPropertiesAxiom.getProperties();
        Iterator iterator = set.iterator();
        if (iterator.hasNext()) {
            OWLDataProperty oWLDataProperty = ((OWLDataPropertyExpression)iterator.next()).asOWLDataProperty();
            while (iterator.hasNext()) {
                OWLDataProperty oWLDataProperty2;
                OWLDataProperty oWLDataProperty3 = oWLDataProperty.asOWLDataProperty();
                if (this.reasoner.isSubDataPropertyOf(oWLDataProperty3, oWLDataProperty2 = ((OWLDataPropertyExpression)iterator.next()).asOWLDataProperty()) && this.reasoner.isSubDataPropertyOf(oWLDataProperty2, oWLDataProperty3)) continue;
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    public Boolean visit(OWLSubDataPropertyOfAxiom oWLSubDataPropertyOfAxiom) {
        return this.reasoner.isSubDataPropertyOf(((OWLDataPropertyExpression)oWLSubDataPropertyOfAxiom.getSubProperty()).asOWLDataProperty(), ((OWLDataPropertyExpression)oWLSubDataPropertyOfAxiom.getSuperProperty()).asOWLDataProperty());
    }

    public Boolean visit(OWLDisjointDataPropertiesAxiom oWLDisjointDataPropertiesAxiom) {
        int n = oWLDisjointDataPropertiesAxiom.getProperties().size();
        OWLDataPropertyExpression[] oWLDataPropertyExpressionArray = oWLDisjointDataPropertiesAxiom.getProperties().toArray(new OWLDataPropertyExpression[n]);
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                OWLDataSomeValuesFrom oWLDataSomeValuesFrom = this.factory.getOWLDataSomeValuesFrom(oWLDataPropertyExpressionArray[i], (OWLDataRange)this.factory.getOWLDatatype(IRI.create((String)InternalDatatype.RDFS_LITERAL.getIRI())));
                OWLDataSomeValuesFrom oWLDataSomeValuesFrom2 = this.factory.getOWLDataSomeValuesFrom(oWLDataPropertyExpressionArray[j], (OWLDataRange)this.factory.getOWLDatatype(IRI.create((String)InternalDatatype.RDFS_LITERAL.getIRI())));
                OWLDataMaxCardinality oWLDataMaxCardinality = this.factory.getOWLDataMaxCardinality(1, (OWLDataPropertyExpression)this.factory.getOWLDataProperty(IRI.create((String)AtomicRole.TOP_DATA_ROLE.getIRI())));
                OWLObjectIntersectionOf oWLObjectIntersectionOf = this.factory.getOWLObjectIntersectionOf(new OWLClassExpression[]{oWLDataSomeValuesFrom, oWLDataSomeValuesFrom2, oWLDataMaxCardinality});
                if (!this.reasoner.isSatisfiable((OWLClassExpression)oWLObjectIntersectionOf)) continue;
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    public Boolean visit(OWLFunctionalDataPropertyAxiom oWLFunctionalDataPropertyAxiom) {
        return this.reasoner.isFunctional(((OWLDataPropertyExpression)oWLFunctionalDataPropertyAxiom.getProperty()).asOWLDataProperty());
    }

    public Boolean visit(OWLSubClassOfAxiom oWLSubClassOfAxiom) {
        return this.reasoner.isSubClassOf(oWLSubClassOfAxiom.getSubClass(), oWLSubClassOfAxiom.getSuperClass());
    }

    public Boolean visit(OWLEquivalentClassesAxiom oWLEquivalentClassesAxiom) {
        boolean bl = true;
        Iterator iterator = oWLEquivalentClassesAxiom.getClassExpressions().iterator();
        if (iterator.hasNext()) {
            OWLClassExpression oWLClassExpression = (OWLClassExpression)iterator.next();
            while (iterator.hasNext() && bl) {
                OWLClassExpression oWLClassExpression2 = (OWLClassExpression)iterator.next();
                bl = this.reasoner.isSubClassOf(oWLClassExpression, oWLClassExpression2) && this.reasoner.isSubClassOf(oWLClassExpression2, oWLClassExpression);
            }
        }
        return bl;
    }

    public Boolean visit(OWLDisjointClassesAxiom oWLDisjointClassesAxiom) {
        int n = oWLDisjointClassesAxiom.getClassExpressions().size();
        OWLClassExpression[] oWLClassExpressionArray = oWLDisjointClassesAxiom.getClassExpressions().toArray(new OWLClassExpression[n]);
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                OWLObjectComplementOf oWLObjectComplementOf = this.factory.getOWLObjectComplementOf(oWLClassExpressionArray[j]);
                if (this.reasoner.isSubClassOf(oWLClassExpressionArray[i], (OWLClassExpression)oWLObjectComplementOf)) continue;
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    public Boolean visit(OWLDisjointUnionAxiom oWLDisjointUnionAxiom) {
        OWLClass oWLClass = oWLDisjointUnionAxiom.getOWLClass();
        HashSet<OWLObjectComplementOf> hashSet = new HashSet<OWLObjectComplementOf>(oWLDisjointUnionAxiom.getClassExpressions());
        hashSet.add(this.factory.getOWLObjectComplementOf((OWLClassExpression)oWLClass));
        OWLObjectUnionOf oWLObjectUnionOf = this.factory.getOWLObjectUnionOf(hashSet);
        OWLObjectUnionOf oWLObjectUnionOf2 = this.factory.getOWLObjectUnionOf(new OWLClassExpression[]{this.factory.getOWLObjectComplementOf((OWLClassExpression)this.factory.getOWLObjectUnionOf(oWLDisjointUnionAxiom.getClassExpressions())), oWLClass});
        HashSet<OWLObjectUnionOf> hashSet2 = new HashSet<OWLObjectUnionOf>();
        hashSet2.add(oWLObjectUnionOf);
        hashSet2.add(oWLObjectUnionOf2);
        int n = oWLDisjointUnionAxiom.getClassExpressions().size();
        OWLClassExpression[] oWLClassExpressionArray = oWLDisjointUnionAxiom.getClassExpressions().toArray(new OWLClassExpression[n]);
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                hashSet2.add(this.factory.getOWLObjectUnionOf(new OWLClassExpression[]{this.factory.getOWLObjectComplementOf(oWLClassExpressionArray[i]), this.factory.getOWLObjectComplementOf(oWLClassExpressionArray[j])}));
            }
        }
        OWLObjectIntersectionOf oWLObjectIntersectionOf = this.factory.getOWLObjectIntersectionOf(hashSet2);
        return !this.reasoner.isSatisfiable((OWLClassExpression)this.factory.getOWLObjectComplementOf((OWLClassExpression)oWLObjectIntersectionOf));
    }

    public Boolean visit(OWLDatatypeDefinitionAxiom oWLDatatypeDefinitionAxiom) {
        this.reasoner.throwInconsistentOntologyExceptionIfNecessary();
        if (!this.reasoner.isConsistent()) {
            return true;
        }
        if (this.reasoner.m_dlOntology.hasDatatypes()) {
            OWLDataFactory oWLDataFactory = this.reasoner.getDataFactory();
            OWLAnonymousIndividual oWLAnonymousIndividual = oWLDataFactory.getOWLAnonymousIndividual("fresh-individual");
            OWLDataProperty oWLDataProperty = oWLDataFactory.getOWLDataProperty(IRI.create((String)"fresh-data-property"));
            OWLDataRange oWLDataRange = oWLDatatypeDefinitionAxiom.getDataRange();
            OWLDatatype oWLDatatype = oWLDatatypeDefinitionAxiom.getDatatype();
            OWLDataIntersectionOf oWLDataIntersectionOf = oWLDataFactory.getOWLDataIntersectionOf(new OWLDataRange[]{oWLDataFactory.getOWLDataComplementOf(oWLDataRange), oWLDatatype});
            OWLDataIntersectionOf oWLDataIntersectionOf2 = oWLDataFactory.getOWLDataIntersectionOf(new OWLDataRange[]{oWLDataFactory.getOWLDataComplementOf((OWLDataRange)oWLDatatype), oWLDataRange});
            OWLDataUnionOf oWLDataUnionOf = oWLDataFactory.getOWLDataUnionOf(new OWLDataRange[]{oWLDataIntersectionOf, oWLDataIntersectionOf2});
            OWLDataSomeValuesFrom oWLDataSomeValuesFrom = oWLDataFactory.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)oWLDataProperty, (OWLDataRange)oWLDataUnionOf);
            OWLClassAssertionAxiom oWLClassAssertionAxiom = oWLDataFactory.getOWLClassAssertionAxiom((OWLClassExpression)oWLDataSomeValuesFrom, (OWLIndividual)oWLAnonymousIndividual);
            Tableau tableau = this.reasoner.getTableau(new OWLAxiom[]{oWLClassAssertionAxiom});
            return !tableau.isSatisfiable(true, true, null, null, null, null, null, ReasoningTaskDescription.isAxiomEntailed(oWLDatatypeDefinitionAxiom));
        }
        return false;
    }

    public Boolean visit(SWRLRule sWRLRule) {
        throw new UnsupportedOperationException();
    }

    public Boolean visit(OWLHasKeyAxiom oWLHasKeyAxiom) {
        OWLNamedIndividual oWLNamedIndividual;
        this.reasoner.throwFreshEntityExceptionIfNecessary(new OWLObject[]{oWLHasKeyAxiom});
        this.reasoner.throwInconsistentOntologyExceptionIfNecessary();
        if (!this.reasoner.isConsistent()) {
            return true;
        }
        OWLOntologyManager oWLOntologyManager = OWLManager.createOWLOntologyManager();
        OWLDataFactory oWLDataFactory = oWLOntologyManager.getOWLDataFactory();
        OWLNamedIndividual oWLNamedIndividual2 = oWLDataFactory.getOWLNamedIndividual(IRI.create((String)"internal:named-fresh-individual-A"));
        OWLNamedIndividual oWLNamedIndividual3 = oWLDataFactory.getOWLNamedIndividual(IRI.create((String)"internal:named-fresh-individual-B"));
        HashSet<Object> hashSet = new HashSet<Object>();
        hashSet.add(oWLDataFactory.getOWLClassAssertionAxiom(oWLHasKeyAxiom.getClassExpression(), (OWLIndividual)oWLNamedIndividual2));
        hashSet.add(oWLDataFactory.getOWLClassAssertionAxiom(oWLHasKeyAxiom.getClassExpression(), (OWLIndividual)oWLNamedIndividual3));
        int n = 0;
        for (OWLObjectPropertyExpression oWLObjectPropertyExpression : oWLHasKeyAxiom.getObjectPropertyExpressions()) {
            oWLNamedIndividual = oWLDataFactory.getOWLNamedIndividual(IRI.create((String)("internal:named-fresh-individual-" + n)));
            hashSet.add(oWLDataFactory.getOWLObjectPropertyAssertionAxiom(oWLObjectPropertyExpression, (OWLIndividual)oWLNamedIndividual2, (OWLIndividual)oWLNamedIndividual));
            hashSet.add(oWLDataFactory.getOWLObjectPropertyAssertionAxiom(oWLObjectPropertyExpression, (OWLIndividual)oWLNamedIndividual3, (OWLIndividual)oWLNamedIndividual));
            ++n;
        }
        for (OWLObjectPropertyExpression oWLObjectPropertyExpression : oWLHasKeyAxiom.getDataPropertyExpressions()) {
            oWLNamedIndividual = oWLDataFactory.getOWLDatatype(IRI.create((String)"internal:anonymous-constants"));
            OWLLiteral oWLLiteral = oWLDataFactory.getOWLLiteral("internal:constant-" + n, (OWLDatatype)oWLNamedIndividual);
            hashSet.add(oWLDataFactory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)oWLObjectPropertyExpression, (OWLIndividual)oWLNamedIndividual2, oWLLiteral));
            hashSet.add(oWLDataFactory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)oWLObjectPropertyExpression, (OWLIndividual)oWLNamedIndividual3, oWLLiteral));
            ++n;
        }
        hashSet.add(oWLDataFactory.getOWLDifferentIndividualsAxiom(new OWLIndividual[]{oWLNamedIndividual2, oWLNamedIndividual3}));
        Tableau tableau = this.reasoner.getTableau(hashSet.toArray(new OWLAxiom[hashSet.size()]));
        return !tableau.isSatisfiable(true, true, null, null, null, null, null, ReasoningTaskDescription.isAxiomEntailed(oWLHasKeyAxiom));
    }

    protected class Edge {
        public final OWLAnonymousIndividual first;
        public final OWLAnonymousIndividual second;

        public Edge(OWLAnonymousIndividual oWLAnonymousIndividual, OWLAnonymousIndividual oWLAnonymousIndividual2) {
            this.first = oWLAnonymousIndividual;
            this.second = oWLAnonymousIndividual2;
        }

        public int hashCode() {
            return 13 + 3 * (this.first != null ? this.first.hashCode() : 0) + 7 * (this.second != null ? this.second.hashCode() : 0);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Edge edge = (Edge)object;
            return this.first.equals(edge.first) && this.second.equals(edge.second);
        }

        public String toString() {
            return "(" + this.first + ", " + this.second + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AnonymousIndividualForestBuilder
    implements OWLAxiomVisitor {
        protected final Set<OWLNamedIndividual> namedNodes = new HashSet<OWLNamedIndividual>();
        protected final Set<OWLAnonymousIndividual> nodes = new HashSet<OWLAnonymousIndividual>();
        protected final Map<OWLAnonymousIndividual, Set<OWLAnonymousIndividual>> edges = new HashMap<OWLAnonymousIndividual, Set<OWLAnonymousIndividual>>();
        protected final Map<OWLAnonymousIndividual, Map<OWLNamedIndividual, Set<OWLObjectPropertyExpression>>> specialOPEdges = new HashMap<OWLAnonymousIndividual, Map<OWLNamedIndividual, Set<OWLObjectPropertyExpression>>>();
        protected final Map<OWLAnonymousIndividual, Set<OWLClassExpression>> nodelLabels = new HashMap<OWLAnonymousIndividual, Set<OWLClassExpression>>();
        protected final Map<Edge, OWLObjectProperty> edgeOPLabels = new HashMap<Edge, OWLObjectProperty>();
        protected final Set<OWLAxiom> anonIndAxioms = new HashSet<OWLAxiom>();
        protected final Set<OWLAxiom> anonNoNamedIndAxioms = new HashSet<OWLAxiom>();

        protected AnonymousIndividualForestBuilder() {
        }

        public void constructConceptsForAnonymousIndividuals(OWLDataFactory oWLDataFactory, Set<OWLAxiom> set) {
            for (OWLAxiom object2 : set) {
                object2.accept((OWLAxiomVisitor)this);
            }
            Set<Set<OWLAnonymousIndividual>> set2 = this.getComponents();
            Map<Set<OWLAnonymousIndividual>, OWLAnonymousIndividual> map = this.findSuitableRoots(set2);
            for (Set<OWLAnonymousIndividual> set3 : map.keySet()) {
                Object object;
                OWLAnonymousIndividual oWLAnonymousIndividual = map.get(set3);
                if (!this.specialOPEdges.containsKey(oWLAnonymousIndividual)) {
                    object = this.getClassExpressionFor(oWLDataFactory, oWLAnonymousIndividual, null);
                    this.anonNoNamedIndAxioms.add((OWLAxiom)oWLDataFactory.getOWLSubClassOfAxiom((OWLClassExpression)oWLDataFactory.getOWLThing(), (OWLClassExpression)oWLDataFactory.getOWLObjectComplementOf((OWLClassExpression)object)));
                    continue;
                }
                object = this.specialOPEdges.get(oWLAnonymousIndividual);
                if (object.size() != 1) {
                    throw new RuntimeException("Internal error: HermiT decided that the anonymous individuals form a valid forest, but actually they do not. ");
                }
                OWLNamedIndividual oWLNamedIndividual = (OWLNamedIndividual)object.keySet().iterator().next();
                Set set4 = (Set)object.get(oWLNamedIndividual);
                if (set4.size() != 1) {
                    throw new RuntimeException("Internal error: HermiT decided that the anonymous individuals form a valid forest, but actually they do not. ");
                }
                OWLObjectPropertyExpression oWLObjectPropertyExpression = ((OWLObjectPropertyExpression)set4.iterator().next()).getInverseProperty().getSimplified();
                OWLClassExpression oWLClassExpression = this.getClassExpressionFor(oWLDataFactory, oWLAnonymousIndividual, null);
                this.anonIndAxioms.add((OWLAxiom)oWLDataFactory.getOWLClassAssertionAxiom((OWLClassExpression)oWLDataFactory.getOWLObjectSomeValuesFrom(oWLObjectPropertyExpression, oWLClassExpression), (OWLIndividual)oWLNamedIndividual));
            }
        }

        public Set<OWLAxiom> getAnonIndAxioms() {
            return this.anonIndAxioms;
        }

        public Set<OWLAxiom> getAnonNoNamedIndAxioms() {
            return this.anonNoNamedIndAxioms;
        }

        protected OWLClassExpression getClassExpressionFor(OWLDataFactory oWLDataFactory, OWLAnonymousIndividual oWLAnonymousIndividual, OWLAnonymousIndividual oWLAnonymousIndividual2) {
            Set<OWLAnonymousIndividual> set = this.edges.get(oWLAnonymousIndividual);
            if (set == null || set.size() == 1 && set.iterator().next() == oWLAnonymousIndividual2) {
                if (!this.nodelLabels.containsKey(oWLAnonymousIndividual)) {
                    return oWLDataFactory.getOWLThing();
                }
                if (this.nodelLabels.get(oWLAnonymousIndividual).size() == 1) {
                    return this.nodelLabels.get(oWLAnonymousIndividual).iterator().next();
                }
                return oWLDataFactory.getOWLObjectIntersectionOf(this.nodelLabels.get(oWLAnonymousIndividual));
            }
            HashSet<OWLObjectSomeValuesFrom> hashSet = new HashSet<OWLObjectSomeValuesFrom>();
            for (OWLAnonymousIndividual oWLAnonymousIndividual3 : set) {
                OWLObjectProperty oWLObjectProperty;
                Edge edge = new Edge(oWLAnonymousIndividual, oWLAnonymousIndividual3);
                if (this.edgeOPLabels.containsKey(edge)) {
                    oWLObjectProperty = this.edgeOPLabels.get(edge);
                } else {
                    edge = new Edge(oWLAnonymousIndividual3, oWLAnonymousIndividual);
                    if (!this.edgeOPLabels.containsKey(edge)) {
                        throw new RuntimeException("Internal error: some edge in the forest of anonymous individuals has no edge label although it should. ");
                    }
                    oWLObjectProperty = this.edgeOPLabels.get(edge);
                }
                hashSet.add(oWLDataFactory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)oWLObjectProperty, this.getClassExpressionFor(oWLDataFactory, oWLAnonymousIndividual3, oWLAnonymousIndividual)));
            }
            return hashSet.size() == 1 ? (OWLClassExpression)hashSet.iterator().next() : oWLDataFactory.getOWLObjectIntersectionOf(hashSet);
        }

        protected Map<Set<OWLAnonymousIndividual>, OWLAnonymousIndividual> findSuitableRoots(Set<Set<OWLAnonymousIndividual>> set) {
            HashMap<Set<OWLAnonymousIndividual>, OWLAnonymousIndividual> hashMap = new HashMap<Set<OWLAnonymousIndividual>, OWLAnonymousIndividual>();
            for (Set<OWLAnonymousIndividual> set2 : set) {
                OWLAnonymousIndividual oWLAnonymousIndividual = null;
                OWLAnonymousIndividual oWLAnonymousIndividual2 = null;
                for (OWLAnonymousIndividual oWLAnonymousIndividual3 : set2) {
                    if (this.specialOPEdges.containsKey(oWLAnonymousIndividual3)) {
                        if (this.specialOPEdges.get(oWLAnonymousIndividual3).size() >= 2) continue;
                        oWLAnonymousIndividual2 = oWLAnonymousIndividual3;
                        continue;
                    }
                    oWLAnonymousIndividual = oWLAnonymousIndividual3;
                }
                if (oWLAnonymousIndividual == null && oWLAnonymousIndividual2 == null) {
                    throw new IllegalArgumentException("Invalid input ontology: One of the trees in the forst of anomnymous individuals has no root that satisfies the criteria on roots (cf. OWL 2 Structural Specification and Functional-Style Syntax, Sec. 11.2).");
                }
                if (oWLAnonymousIndividual2 != null) {
                    hashMap.put(set2, oWLAnonymousIndividual2);
                    continue;
                }
                hashMap.put(set2, oWLAnonymousIndividual);
            }
            return hashMap;
        }

        protected Set<Set<OWLAnonymousIndividual>> getComponents() {
            HashSet<Set<OWLAnonymousIndividual>> hashSet = new HashSet<Set<OWLAnonymousIndividual>>();
            if (this.nodes.isEmpty()) {
                return hashSet;
            }
            Set<OWLAnonymousIndividual> set = this.nodes;
            ArrayList<Edge> arrayList = new ArrayList<Edge>();
            while (!set.isEmpty()) {
                HashSet<OWLAnonymousIndividual> hashSet2 = new HashSet<OWLAnonymousIndividual>();
                Edge edge = new Edge(set.iterator().next(), null);
                arrayList.add(edge);
                while (!arrayList.isEmpty()) {
                    edge = (Edge)arrayList.remove(0);
                    hashSet2.add(edge.first);
                    if (!this.edges.containsKey(edge.first)) continue;
                    for (OWLAnonymousIndividual oWLAnonymousIndividual : this.edges.get(edge.first)) {
                        if (edge.second != null && oWLAnonymousIndividual.getID().equals(edge.second.getID())) continue;
                        for (Edge edge2 : arrayList) {
                            if (edge2.first != oWLAnonymousIndividual) continue;
                            throw new IllegalArgumentException("Invalid input ontology: The anonymous individuals cannot be arranged into a forest as required (cf. OWL 2 Structural Specification and Functional-Style Syntax, Sec. 11.2) because there is a cycle. ");
                        }
                        arrayList.add(new Edge(oWLAnonymousIndividual, edge.first));
                    }
                }
                hashSet.add(hashSet2);
                set.removeAll(hashSet2);
            }
            return hashSet;
        }

        public void visit(OWLClassAssertionAxiom oWLClassAssertionAxiom) {
            if (oWLClassAssertionAxiom.getClassExpression().isOWLThing()) {
                return;
            }
            OWLIndividual oWLIndividual = oWLClassAssertionAxiom.getIndividual();
            if (!oWLIndividual.isAnonymous()) {
                this.namedNodes.add(oWLIndividual.asOWLNamedIndividual());
            } else {
                this.nodes.add(oWLIndividual.asOWLAnonymousIndividual());
                if (this.nodelLabels.containsKey(oWLIndividual)) {
                    this.nodelLabels.get(oWLIndividual).add(oWLClassAssertionAxiom.getClassExpression());
                } else {
                    HashSet<OWLClassExpression> hashSet = new HashSet<OWLClassExpression>();
                    hashSet.add(oWLClassAssertionAxiom.getClassExpression());
                    this.nodelLabels.put(oWLIndividual.asOWLAnonymousIndividual(), hashSet);
                }
            }
        }

        public void visit(OWLObjectPropertyAssertionAxiom oWLObjectPropertyAssertionAxiom) {
            OWLIndividual oWLIndividual = oWLObjectPropertyAssertionAxiom.getSubject();
            OWLIndividual oWLIndividual2 = (OWLIndividual)oWLObjectPropertyAssertionAxiom.getObject();
            OWLObjectPropertyExpression oWLObjectPropertyExpression = ((OWLObjectPropertyExpression)oWLObjectPropertyAssertionAxiom.getProperty()).getSimplified();
            if (!oWLIndividual.isAnonymous() && !oWLIndividual2.isAnonymous()) {
                return;
            }
            if (!oWLIndividual.isAnonymous() && oWLIndividual2.isAnonymous() || oWLIndividual.isAnonymous() && !oWLIndividual2.isAnonymous()) {
                OWLNamedIndividual oWLNamedIndividual;
                if (!oWLIndividual.isAnonymous() && oWLIndividual2.isAnonymous()) {
                    oWLNamedIndividual = oWLIndividual;
                    oWLIndividual = oWLIndividual2;
                    oWLIndividual2 = oWLNamedIndividual;
                    oWLObjectPropertyExpression = oWLObjectPropertyExpression.getInverseProperty().getSimplified();
                }
                oWLNamedIndividual = oWLIndividual2.asOWLNamedIndividual();
                OWLAnonymousIndividual oWLAnonymousIndividual = oWLIndividual.asOWLAnonymousIndividual();
                this.namedNodes.add(oWLNamedIndividual);
                this.nodes.add(oWLAnonymousIndividual);
                if (this.specialOPEdges.containsKey(oWLAnonymousIndividual)) {
                    Map<OWLNamedIndividual, Set<OWLObjectPropertyExpression>> map = this.specialOPEdges.get(oWLAnonymousIndividual);
                    if (map.containsKey(oWLNamedIndividual)) {
                        map.get(oWLNamedIndividual).add(oWLObjectPropertyExpression);
                    } else {
                        map = new HashMap<OWLNamedIndividual, Set<OWLObjectPropertyExpression>>();
                        HashSet<OWLObjectPropertyExpression> hashSet = new HashSet<OWLObjectPropertyExpression>();
                        hashSet.add(oWLObjectPropertyExpression);
                        map.put(oWLNamedIndividual, hashSet);
                        this.specialOPEdges.put(oWLAnonymousIndividual, map);
                    }
                } else {
                    HashMap hashMap = new HashMap();
                    HashSet<OWLObjectPropertyExpression> hashSet = new HashSet<OWLObjectPropertyExpression>();
                    hashSet.add(oWLObjectPropertyExpression);
                    hashMap.put(oWLNamedIndividual, hashSet);
                    this.specialOPEdges.put(oWLAnonymousIndividual, hashMap);
                }
            } else {
                HashSet<Object> hashSet;
                OWLIndividual oWLIndividual3;
                OWLObjectProperty oWLObjectProperty;
                if (oWLObjectPropertyExpression.isAnonymous()) {
                    oWLObjectProperty = oWLObjectPropertyExpression.getNamedProperty();
                    oWLIndividual3 = oWLIndividual;
                    oWLIndividual = oWLIndividual2;
                    oWLIndividual2 = oWLIndividual3;
                } else {
                    oWLObjectProperty = oWLObjectPropertyExpression.asOWLObjectProperty();
                }
                oWLIndividual3 = oWLIndividual.asOWLAnonymousIndividual();
                OWLAnonymousIndividual oWLAnonymousIndividual = oWLIndividual2.asOWLAnonymousIndividual();
                this.nodes.add((OWLAnonymousIndividual)oWLIndividual3);
                this.nodes.add(oWLAnonymousIndividual);
                if (this.edges.containsKey(oWLIndividual3) && this.edges.get(oWLIndividual3).contains(oWLAnonymousIndividual) || this.edges.containsKey(oWLAnonymousIndividual) && this.edges.get(oWLAnonymousIndividual).contains(oWLIndividual3)) {
                    throw new IllegalArgumentException("Invalid input ontology: There are two object property assertions for the same anonymous individuals, which is not allowed (see OWL 2 Syntax Sec 11.2). ");
                }
                if (this.edges.containsKey(oWLIndividual3)) {
                    this.edges.get(oWLIndividual3).add(oWLAnonymousIndividual);
                } else {
                    hashSet = new HashSet<Object>();
                    hashSet.add(oWLAnonymousIndividual);
                    this.edges.put((OWLAnonymousIndividual)oWLIndividual3, hashSet);
                }
                if (this.edges.containsKey(oWLAnonymousIndividual)) {
                    this.edges.get(oWLAnonymousIndividual).add((OWLAnonymousIndividual)oWLIndividual3);
                } else {
                    hashSet = new HashSet();
                    hashSet.add(oWLIndividual3);
                    this.edges.put(oWLAnonymousIndividual, hashSet);
                }
                this.edgeOPLabels.put(new Edge((OWLAnonymousIndividual)oWLIndividual3, oWLAnonymousIndividual), oWLObjectProperty);
            }
        }

        public void visit(OWLDataPropertyAssertionAxiom oWLDataPropertyAssertionAxiom) {
            if (!oWLDataPropertyAssertionAxiom.getSubject().isAnonymous()) {
                return;
            }
            OWLAnonymousIndividual oWLAnonymousIndividual = oWLDataPropertyAssertionAxiom.getSubject().asOWLAnonymousIndividual();
            this.nodes.add(oWLAnonymousIndividual);
            OWLDataHasValue oWLDataHasValue = EntailmentChecker.this.factory.getOWLDataHasValue((OWLDataPropertyExpression)oWLDataPropertyAssertionAxiom.getProperty(), (OWLLiteral)oWLDataPropertyAssertionAxiom.getObject());
            if (this.nodelLabels.containsKey(oWLAnonymousIndividual)) {
                this.nodelLabels.get(oWLAnonymousIndividual).add((OWLClassExpression)oWLDataHasValue);
            } else {
                HashSet<OWLDataHasValue> hashSet = new HashSet<OWLDataHasValue>();
                hashSet.add(oWLDataHasValue);
                this.nodelLabels.put(oWLAnonymousIndividual, hashSet);
            }
        }

        public void visit(OWLDeclarationAxiom oWLDeclarationAxiom) {
        }

        public void visit(OWLSubClassOfAxiom oWLSubClassOfAxiom) {
        }

        public void visit(OWLNegativeObjectPropertyAssertionAxiom oWLNegativeObjectPropertyAssertionAxiom) {
        }

        public void visit(OWLAsymmetricObjectPropertyAxiom oWLAsymmetricObjectPropertyAxiom) {
        }

        public void visit(OWLReflexiveObjectPropertyAxiom oWLReflexiveObjectPropertyAxiom) {
        }

        public void visit(OWLDisjointClassesAxiom oWLDisjointClassesAxiom) {
        }

        public void visit(OWLDataPropertyDomainAxiom oWLDataPropertyDomainAxiom) {
        }

        public void visit(OWLObjectPropertyDomainAxiom oWLObjectPropertyDomainAxiom) {
        }

        public void visit(OWLEquivalentObjectPropertiesAxiom oWLEquivalentObjectPropertiesAxiom) {
        }

        public void visit(OWLNegativeDataPropertyAssertionAxiom oWLNegativeDataPropertyAssertionAxiom) {
        }

        public void visit(OWLDifferentIndividualsAxiom oWLDifferentIndividualsAxiom) {
        }

        public void visit(OWLDisjointDataPropertiesAxiom oWLDisjointDataPropertiesAxiom) {
        }

        public void visit(OWLDisjointObjectPropertiesAxiom oWLDisjointObjectPropertiesAxiom) {
        }

        public void visit(OWLObjectPropertyRangeAxiom oWLObjectPropertyRangeAxiom) {
        }

        public void visit(OWLFunctionalObjectPropertyAxiom oWLFunctionalObjectPropertyAxiom) {
        }

        public void visit(OWLSubObjectPropertyOfAxiom oWLSubObjectPropertyOfAxiom) {
        }

        public void visit(OWLDisjointUnionAxiom oWLDisjointUnionAxiom) {
        }

        public void visit(OWLSymmetricObjectPropertyAxiom oWLSymmetricObjectPropertyAxiom) {
        }

        public void visit(OWLDataPropertyRangeAxiom oWLDataPropertyRangeAxiom) {
        }

        public void visit(OWLFunctionalDataPropertyAxiom oWLFunctionalDataPropertyAxiom) {
        }

        public void visit(OWLEquivalentDataPropertiesAxiom oWLEquivalentDataPropertiesAxiom) {
        }

        public void visit(OWLEquivalentClassesAxiom oWLEquivalentClassesAxiom) {
        }

        public void visit(OWLTransitiveObjectPropertyAxiom oWLTransitiveObjectPropertyAxiom) {
        }

        public void visit(OWLIrreflexiveObjectPropertyAxiom oWLIrreflexiveObjectPropertyAxiom) {
        }

        public void visit(OWLSubDataPropertyOfAxiom oWLSubDataPropertyOfAxiom) {
        }

        public void visit(OWLInverseFunctionalObjectPropertyAxiom oWLInverseFunctionalObjectPropertyAxiom) {
        }

        public void visit(OWLSameIndividualAxiom oWLSameIndividualAxiom) {
        }

        public void visit(OWLSubPropertyChainOfAxiom oWLSubPropertyChainOfAxiom) {
        }

        public void visit(OWLInverseObjectPropertiesAxiom oWLInverseObjectPropertiesAxiom) {
        }

        public void visit(OWLHasKeyAxiom oWLHasKeyAxiom) {
        }

        public void visit(OWLDatatypeDefinitionAxiom oWLDatatypeDefinitionAxiom) {
        }

        public void visit(SWRLRule sWRLRule) {
        }

        public void visit(OWLAnnotationAssertionAxiom oWLAnnotationAssertionAxiom) {
        }

        public void visit(OWLSubAnnotationPropertyOfAxiom oWLSubAnnotationPropertyOfAxiom) {
        }

        public void visit(OWLAnnotationPropertyDomainAxiom oWLAnnotationPropertyDomainAxiom) {
        }

        public void visit(OWLAnnotationPropertyRangeAxiom oWLAnnotationPropertyRangeAxiom) {
        }
    }
}

