/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.soap.impl.llom;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMConstants;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.MTOMXMLStreamWriter;
import org.apache.axiom.om.impl.llom.OMNodeImpl;
import org.apache.axiom.om.impl.util.OMSerializerUtil;
import org.apache.axiom.soap.SOAP12Version;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPProcessingException;
import org.apache.axiom.soap.SOAPVersion;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.apache.axiom.soap.impl.llom.SOAPBodyImpl;
import org.apache.axiom.soap.impl.llom.SOAPElement;
import org.apache.axiom.soap.impl.llom.SOAPHeaderImpl;

public class SOAPEnvelopeImpl
extends SOAPElement
implements SOAPEnvelope,
OMConstants {
    public SOAPEnvelopeImpl(OMXMLParserWrapper builder, SOAPFactory factory) {
        super(null, "Envelope", builder, factory);
        this.factory = factory;
    }

    public SOAPEnvelopeImpl(OMNamespace ns, SOAPFactory factory) {
        super("Envelope", ns, factory);
        this.factory = factory;
    }

    public SOAPVersion getVersion() {
        return ((SOAPFactory)this.factory).getSOAPVersion();
    }

    public SOAPHeader getHeader() throws OMException {
        OMElement e = this.getFirstElement();
        if (e instanceof SOAPHeader) {
            return (SOAPHeader)e;
        }
        return null;
    }

    private void checkChild(OMNode child) {
        if (child instanceof OMElement && !(child instanceof SOAPHeader) && !(child instanceof SOAPBody)) {
            throw new SOAPProcessingException("SOAP Envelope can not have children other than SOAP Header and Body", "Sender");
        }
    }

    public void addChild(OMNode child) {
        if (this.getVersion() instanceof SOAP12Version) {
            this.checkChild(child);
        }
        if (child instanceof SOAPHeader) {
            if (this.done) {
                SOAPBody body = this.getBody();
                if (body != null) {
                    body.insertSiblingBefore(child);
                    return;
                }
            } else {
                for (OMNode node = this.lastChild; node != null; node = node.getPreviousOMSibling()) {
                    if (!(node instanceof SOAPBody)) continue;
                    node.insertSiblingBefore(child);
                    return;
                }
            }
        }
        super.addChild(child);
    }

    public SOAPBody getBody() throws OMException {
        OMElement element = this.getFirstElement();
        if (element != null) {
            OMNode node;
            if ("Body".equals(element.getLocalName())) {
                return (SOAPBody)element;
            }
            for (node = element.getNextOMSibling(); node != null && node.getType() != 1; node = node.getNextOMSibling()) {
            }
            element = (OMElement)node;
            if (node != null && "Body".equals(element.getLocalName())) {
                return (SOAPBody)element;
            }
            throw new OMException("SOAPEnvelope must contain a body element which is either first or second child element of the SOAPEnvelope.");
        }
        return null;
    }

    public OMNode detach() throws OMException {
        return this;
    }

    protected void checkParent(OMElement parent) throws SOAPProcessingException {
    }

    protected void internalSerialize(XMLStreamWriter writer2, boolean cache) throws XMLStreamException {
        SOAPBody body;
        SOAPHeader header;
        MTOMXMLStreamWriter writer = (MTOMXMLStreamWriter)writer2;
        if (!writer.isIgnoreXMLDeclaration()) {
            String charSetEncoding = writer.getCharSetEncoding();
            String xmlVersion = writer.getXmlVersion();
            writer.getXmlStreamWriter().writeStartDocument(charSetEncoding == null ? "utf-8" : charSetEncoding, xmlVersion == null ? "1.0" : xmlVersion);
        }
        if (cache) {
            OMSerializerUtil.serializeStartpart(this, writer);
            header = this.getHeader();
            if (header != null && header.getFirstOMChild() != null) {
                ((SOAPHeaderImpl)header).internalSerialize(writer);
            }
            if ((body = this.getBody()) != null) {
                ((SOAPBodyImpl)body).internalSerialize(writer);
            }
            OMSerializerUtil.serializeEndpart(writer);
        } else if (this.done || this.builder == null) {
            OMSerializerUtil.serializeStartpart(this, writer);
            header = this.getHeader();
            if (header != null && header.getFirstOMChild() != null) {
                this.serializeInternally((OMNodeImpl)((Object)header), writer);
            }
            if ((body = this.getBody()) != null) {
                this.serializeInternally((OMNodeImpl)((Object)body), writer);
            }
            OMSerializerUtil.serializeEndpart(writer);
        } else {
            OMSerializerUtil.serializeByPullStream(this, writer, cache);
        }
    }

    private void serializeInternally(OMNodeImpl child, MTOMXMLStreamWriter writer) throws XMLStreamException {
        if (!(child instanceof OMElement) || child.isComplete() || child.builder == null) {
            child.internalSerializeAndConsume(writer);
        } else {
            OMElement element = (OMElement)((Object)child);
            element.getBuilder().setCache(false);
            OMSerializerUtil.serializeByPullStream(element, writer, false);
        }
        child.getNextOMSibling();
    }

    public boolean hasFault() {
        QName payloadQName = this.getPayloadQName_Optimized();
        if (payloadQName != null && "Fault".equals(payloadQName.getLocalPart())) {
            String ns = payloadQName.getNamespaceURI();
            return ns != null && ("http://schemas.xmlsoap.org/soap/envelope/".equals(ns) || "http://www.w3.org/2003/05/soap-envelope".equals(ns));
        }
        SOAPBody body = this.getBody();
        return body == null ? false : body.hasFault();
    }

    public String getSOAPBodyFirstElementLocalName() {
        QName payloadQName = this.getPayloadQName_Optimized();
        if (payloadQName != null) {
            return payloadQName.getLocalPart();
        }
        SOAPBody body = this.getBody();
        return body == null ? null : body.getFirstElementLocalName();
    }

    public OMNamespace getSOAPBodyFirstElementNS() {
        QName payloadQName = this.getPayloadQName_Optimized();
        if (payloadQName != null) {
            return this.factory.createOMNamespace(payloadQName.getNamespaceURI(), payloadQName.getPrefix());
        }
        SOAPBody body = this.getBody();
        return body == null ? null : body.getFirstElementNS();
    }

    private QName getPayloadQName_Optimized() {
        OMXMLParserWrapper builder = this.getBuilder();
        if (builder instanceof StAXSOAPModelBuilder) {
            try {
                QName payloadQName = (QName)((StAXSOAPModelBuilder)builder).getReaderProperty("org.apache.axiom.SOAPBodyFirstChildElementQName");
                return payloadQName;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }
}

