/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.codegeneration.test;

import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.protege.owl.codegeneration.CodeGenerationOptions;
import org.protege.owl.codegeneration.DefaultWorker;
import org.protege.owl.codegeneration.Utilities;
import org.protege.owl.codegeneration.inference.CodeGenerationInference;
import org.protege.owl.codegeneration.inference.ReasonerBasedInference;
import org.protege.owl.codegeneration.inference.SimpleInference;
import org.protege.owl.codegeneration.names.IriNames;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;

public class GenerateTestCode {
    public static Logger LOGGER = Logger.getLogger(GenerateTestCode.class);

    public static void main(String[] args) throws Exception {
        GenerateTestCode.generateSimpleJavaCode();
        LOGGER.info((Object)"All code generated.");
    }

    private static void generateSimpleJavaCode() throws OWLOntologyCreationException, InstantiationException, IllegalAccessException, ClassNotFoundException, IOException {
        File outputFolder = new File("target/generated-sources");
        Utilities.deleteFolder(outputFolder);
        GenerateTestCode.generateSimpleJavaCode("CodeGeneration001.owl", "inferred.testSimple", "MySimpleFactory", true, outputFolder);
        GenerateTestCode.generateSimpleJavaCode("CodeGeneration001.owl", "std.testSimple02", "MySimpleStdFactory", false, outputFolder);
        GenerateTestCode.generateSimpleJavaCode("pizza.owl", "inferred.pizza", "MyPizzaFactory", true, outputFolder);
    }

    private static void generateSimpleJavaCode(String ontologyName, String packageName, String factoryName, boolean useInference, File outputFolder) throws OWLOntologyCreationException, InstantiationException, IllegalAccessException, ClassNotFoundException, IOException {
        CodeGenerationInference inference;
        long startTime = System.currentTimeMillis();
        String fullPackageName = "org.protege.owl.codegeneration." + packageName;
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLOntology owlOntology = manager.loadOntologyFromOntologyDocument(new File("src/test/resources/" + ontologyName));
        CodeGenerationOptions options = new CodeGenerationOptions();
        options.setPackage(fullPackageName);
        options.setFactoryClassName(factoryName);
        options.setOutputFolder(outputFolder);
        if (useInference) {
            OWLReasonerFactory rFactory = (OWLReasonerFactory)Class.forName("org.semanticweb.HermiT.Reasoner$ReasonerFactory").newInstance();
            OWLReasoner reasoner = rFactory.createNonBufferingReasoner(owlOntology);
            inference = new ReasonerBasedInference(owlOntology, reasoner);
        } else {
            inference = new SimpleInference(owlOntology);
        }
        DefaultWorker.generateCode(owlOntology, options, new IriNames(owlOntology, options), inference);
        LOGGER.info((Object)("Generating source code for ontology " + ontologyName + " (" + (useInference ? "inferred - " : "asserted -") + (System.currentTimeMillis() - startTime) + "ms)."));
    }
}

