/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.codegeneration.property;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.protege.owl.codegeneration.inference.CodeGenerationInference;
import org.protege.owl.codegeneration.names.CodeGenerationNames;
import org.protege.owl.codegeneration.property.JavaPropertyDeclarations;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;

public class JavaPropertyDeclarationCache {
    private CodeGenerationInference inference;
    private CodeGenerationNames names;
    private Map<OWLClass, Map<OWLEntity, JavaPropertyDeclarations>> class2Property2DeclarationMap = new HashMap<OWLClass, Map<OWLEntity, JavaPropertyDeclarations>>();

    public JavaPropertyDeclarationCache(CodeGenerationInference inference, CodeGenerationNames names) {
        this.inference = inference;
        this.names = names;
        this.generateCache();
    }

    private void generateCache() {
        OWLDataFactory factory = this.inference.getOWLOntology().getOWLOntologyManager().getOWLDataFactory();
        HashSet<OWLClass> explored = new HashSet<OWLClass>();
        OWLClass thing = factory.getOWLThing();
        for (JavaPropertyDeclarations declarations : this.inference.getJavaPropertyDeclarations(thing, this.names)) {
            this.add(thing, declarations.getOwlProperty(), declarations);
        }
        explored.add(thing);
        this.generateChildren(thing, explored);
    }

    private void generateChildren(OWLClass parent, Set<OWLClass> explored) {
        Map<Object, JavaPropertyDeclarations> parentProperty2DeclarationMap = this.class2Property2DeclarationMap.get(parent);
        if (parentProperty2DeclarationMap == null) {
            parentProperty2DeclarationMap = Collections.emptyMap();
        }
        for (OWLClass child : this.inference.getSubClasses(parent)) {
            if (explored.contains(child)) continue;
            this.copyDeclarations(parentProperty2DeclarationMap, parent, child);
            explored.add(child);
            this.generateChildren(child, explored);
        }
    }

    private void copyDeclarations(Map<OWLEntity, JavaPropertyDeclarations> parentProperty2DeclarationMap, OWLClass parent, OWLClass child) {
        OWLEntity property;
        for (Map.Entry<OWLEntity, JavaPropertyDeclarations> entry : parentProperty2DeclarationMap.entrySet()) {
            property = entry.getKey();
            JavaPropertyDeclarations declarations = entry.getValue();
            this.add(child, property, declarations.specializeTo(child));
        }
        for (JavaPropertyDeclarations childDeclarations : this.inference.getJavaPropertyDeclarations(child, this.names)) {
            property = childDeclarations.getOwlProperty();
            if (parentProperty2DeclarationMap.containsKey(property)) continue;
            this.add(child, property, childDeclarations);
        }
    }

    private void add(OWLClass owlClass, OWLEntity property, JavaPropertyDeclarations declarations) {
        Map<OWLEntity, JavaPropertyDeclarations> property2DeclarationsMap = this.class2Property2DeclarationMap.get(owlClass);
        if (property2DeclarationsMap == null) {
            property2DeclarationsMap = new HashMap<OWLEntity, JavaPropertyDeclarations>();
            this.class2Property2DeclarationMap.put(owlClass, property2DeclarationsMap);
        }
        property2DeclarationsMap.put(property, declarations);
    }

    public JavaPropertyDeclarations get(OWLClass clazz, OWLEntity property) {
        Map<OWLEntity, JavaPropertyDeclarations> property2DeclarationMap = this.class2Property2DeclarationMap.get(clazz);
        JavaPropertyDeclarations decls = null;
        if (property2DeclarationMap != null) {
            decls = property2DeclarationMap.get(property);
        }
        return decls;
    }

    public Set<OWLObjectProperty> getObjectPropertiesForClass(OWLClass owlClass) {
        return this.getPropertiesForClass(owlClass, OWLObjectProperty.class);
    }

    public Set<OWLDataProperty> getDataPropertiesForClass(OWLClass owlClass) {
        return this.getPropertiesForClass(owlClass, OWLDataProperty.class);
    }

    private <X extends Comparable<OWLObject>> Set<X> getPropertiesForClass(OWLClass owlClass, Class<? extends X> javaClass) {
        Map<OWLEntity, JavaPropertyDeclarations> property2DeclarationMap = this.class2Property2DeclarationMap.get(owlClass);
        if (property2DeclarationMap == null) {
            return Collections.emptySet();
        }
        TreeSet<X> properties = new TreeSet<X>();
        for (OWLEntity property : property2DeclarationMap.keySet()) {
            if (!javaClass.isAssignableFrom(property.getClass())) continue;
            properties.add(javaClass.cast(property));
        }
        return properties;
    }
}

