/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.codegeneration.property;

import java.util.Map;
import org.protege.owl.codegeneration.SubstitutionVariable;
import org.protege.owl.codegeneration.inference.CodeGenerationInference;
import org.protege.owl.codegeneration.names.CodeGenerationNames;
import org.protege.owl.codegeneration.property.JavaPropertyDeclarations;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLObjectProperty;

public class JavaObjectPropertyDeclarations
implements JavaPropertyDeclarations {
    private CodeGenerationInference inference;
    private CodeGenerationNames names;
    private OWLObjectProperty property;

    public JavaObjectPropertyDeclarations(CodeGenerationInference inference, CodeGenerationNames names, OWLObjectProperty property) {
        this.inference = inference;
        this.names = names;
        this.property = property;
    }

    public OWLObjectProperty getOwlProperty() {
        return this.property;
    }

    @Override
    public JavaPropertyDeclarations specializeTo(OWLClass subclass) {
        return this;
    }

    @Override
    public void configureSubstitutions(Map<SubstitutionVariable, String> substitutions) {
        substitutions.put(SubstitutionVariable.PROPERTY_RANGE_IMPLEMENTATION, this.getObjectPropertyRange(false));
        substitutions.put(SubstitutionVariable.PROPERTY_RANGE, this.getObjectPropertyRange(true));
    }

    private String getObjectPropertyRange(boolean isInterface) {
        OWLClass range = this.inference.getRange(this.property);
        if (range == null || !this.inference.getOwlClasses().contains(range)) {
            return isInterface ? "WrappedIndividual" : "WrappedIndividualImpl";
        }
        return isInterface ? this.names.getInterfaceName(range) : this.names.getImplementationName(range);
    }
}

