/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.codegeneration.property;

import java.util.Map;
import org.protege.owl.codegeneration.HandledDatatypes;
import org.protege.owl.codegeneration.SubstitutionVariable;
import org.protege.owl.codegeneration.inference.CodeGenerationInference;
import org.protege.owl.codegeneration.property.JavaPropertyDeclarations;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;

public class JavaDataPropertyDeclarations
implements JavaPropertyDeclarations {
    private CodeGenerationInference inference;
    private OWLClass owlClass;
    private OWLDataProperty property;

    public JavaDataPropertyDeclarations(CodeGenerationInference inference, OWLClass owlClass, OWLDataProperty property) {
        this.inference = inference;
        this.owlClass = owlClass;
        this.property = property;
    }

    public OWLDataProperty getOwlProperty() {
        return this.property;
    }

    @Override
    public JavaPropertyDeclarations specializeTo(OWLClass subclass) {
        return new JavaDataPropertyDeclarations(this.inference, subclass, this.property);
    }

    @Override
    public void configureSubstitutions(Map<SubstitutionVariable, String> substitutions) {
        substitutions.put(SubstitutionVariable.PROPERTY_RANGE_FOR_CLASS, this.getDataPropertyRangeForClass());
        substitutions.put(SubstitutionVariable.PROPERTY_RANGE, this.getDataPropertyRange());
    }

    private String getDataPropertyRange() {
        OWLDatatype dt = this.inference.getRange(this.property);
        return this.getDataPropertyJavaName(dt);
    }

    private String getDataPropertyRangeForClass() {
        OWLDatatype dt = this.inference.getRange(this.owlClass, this.property);
        return this.getDataPropertyJavaName(dt);
    }

    private String getDataPropertyJavaName(OWLDatatype dt) {
        String dataPropertyRange = null;
        dataPropertyRange = dt == null ? "Object" : this.getOwlDataTypeAsJavaClassString(dt);
        return dataPropertyRange;
    }

    private String getOwlDataTypeAsJavaClassString(OWLDatatype owlDatatype) {
        for (HandledDatatypes handled : HandledDatatypes.values()) {
            if (!handled.isMatch(owlDatatype)) continue;
            return handled.getJavaClass();
        }
        return "Object";
    }
}

