/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.codegeneration.names;

import org.protege.owl.codegeneration.CodeGenerationOptions;
import org.protege.owl.codegeneration.names.AbstractCodeGenerationNames;
import org.protege.owl.codegeneration.names.NamingUtilities;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.util.ShortFormProvider;
import org.semanticweb.owlapi.util.SimpleShortFormProvider;

public class IriNames
extends AbstractCodeGenerationNames {
    private OWLOntology ontology;
    private ShortFormProvider provider;

    public IriNames(OWLOntology ontology, CodeGenerationOptions options) {
        super(options);
        this.ontology = ontology;
        this.provider = new SimpleShortFormProvider();
    }

    @Override
    public String getInterfaceName(OWLClass owlClass) {
        String name = this.provider.getShortForm((OWLEntity)owlClass);
        name = NamingUtilities.convertToJavaIdentifier(name);
        name = NamingUtilities.convertInitialLetterToUpperCase(name);
        return name;
    }

    @Override
    public String getClassName(OWLClass owlClass) {
        String name = this.provider.getShortForm((OWLEntity)owlClass);
        name = NamingUtilities.convertToJavaIdentifier(name);
        return name;
    }

    @Override
    public String getObjectPropertyName(OWLObjectProperty owlObjectProperty) {
        String name = this.provider.getShortForm((OWLEntity)owlObjectProperty);
        name = NamingUtilities.convertToJavaIdentifier(name);
        return name;
    }

    @Override
    public String getDataPropertyName(OWLDataProperty owlDataProperty) {
        String name = this.provider.getShortForm((OWLEntity)owlDataProperty);
        name = NamingUtilities.convertToJavaIdentifier(name);
        return name;
    }
}

