/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.codegeneration.inference;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.protege.owl.codegeneration.inference.CodeGenerationInference;
import org.protege.owl.codegeneration.names.CodeGenerationNames;
import org.protege.owl.codegeneration.property.JavaDataPropertyDeclarations;
import org.protege.owl.codegeneration.property.JavaObjectPropertyDeclarations;
import org.protege.owl.codegeneration.property.JavaPropertyDeclarations;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLOntology;

public class SimpleInference
implements CodeGenerationInference {
    private OWLOntology ontology;
    private OWLDataFactory factory;
    private Set<OWLClass> topLevelClasses;
    private Map<OWLClass, Set<OWLClass>> inferredSubclassMap = new TreeMap<OWLClass, Set<OWLClass>>();
    private Map<OWLClass, Set<OWLClass>> indirectSuperclassMap = new HashMap<OWLClass, Set<OWLClass>>();
    private Map<OWLClass, Set<OWLEntity>> domainMap;
    private Map<OWLObjectProperty, OWLClass> objectRangeMap;
    private Map<OWLDataProperty, OWLDatatype> dataRangeMap;

    public SimpleInference(OWLOntology ontology) {
        this.ontology = ontology;
        this.factory = ontology.getOWLOntologyManager().getOWLDataFactory();
    }

    @Override
    public OWLOntology getOWLOntology() {
        return this.ontology;
    }

    @Override
    public void preCompute() {
    }

    @Override
    public void flush() {
    }

    @Override
    public Collection<OWLClass> getOwlClasses() {
        HashSet<OWLClass> classes = new HashSet<OWLClass>(this.ontology.getClassesInSignature());
        classes.remove(this.factory.getOWLThing());
        return classes;
    }

    @Override
    public Collection<OWLClass> getSubClasses(OWLClass owlClass) {
        if (this.topLevelClasses == null) {
            this.initializeInferredSubclasses();
        }
        if (owlClass.equals(this.factory.getOWLThing())) {
            return Collections.unmodifiableCollection(this.topLevelClasses);
        }
        TreeSet<OWLClass> subClasses = new TreeSet<OWLClass>();
        for (OWLClassExpression ce : owlClass.getSubClasses(this.ontology)) {
            if (ce.isAnonymous()) continue;
            subClasses.add(ce.asOWLClass());
        }
        Set<OWLClass> inferredSubclasses = this.inferredSubclassMap.get(owlClass);
        if (inferredSubclasses != null) {
            subClasses.addAll(inferredSubclasses);
        }
        return subClasses;
    }

    @Override
    public Collection<OWLClass> getSuperClasses(OWLClass owlClass) {
        HashSet<OWLClass> superClasses = new HashSet<OWLClass>();
        for (OWLClassExpression ce : owlClass.getSuperClasses(this.ontology.getImportsClosure())) {
            if (!ce.isAnonymous()) {
                superClasses.add(ce.asOWLClass());
                continue;
            }
            if (!(ce instanceof OWLObjectIntersectionOf)) continue;
            superClasses.addAll(this.getNamedConjuncts((OWLObjectIntersectionOf)ce));
        }
        for (OWLClassExpression ce : owlClass.getEquivalentClasses(this.ontology.getImportsClosure())) {
            if (!(ce instanceof OWLObjectIntersectionOf)) continue;
            superClasses.addAll(this.getNamedConjuncts((OWLObjectIntersectionOf)ce));
        }
        superClasses.remove(this.factory.getOWLThing());
        return superClasses;
    }

    private Collection<OWLClass> getNamedConjuncts(OWLObjectIntersectionOf ce) {
        HashSet<OWLClass> conjuncts = new HashSet<OWLClass>();
        for (OWLClassExpression conjunct : ce.getOperands()) {
            if (conjunct.isAnonymous()) continue;
            conjuncts.add(conjunct.asOWLClass());
        }
        return conjuncts;
    }

    @Override
    public Set<JavaPropertyDeclarations> getJavaPropertyDeclarations(OWLClass cls, CodeGenerationNames names) {
        if (this.domainMap == null) {
            this.initializeDomainMap();
        }
        HashSet<JavaPropertyDeclarations> declarations = new HashSet<JavaPropertyDeclarations>();
        Set<OWLEntity> domains = this.domainMap.get(cls);
        if (domains != null) {
            for (OWLEntity property : domains) {
                if (property instanceof OWLObjectProperty) {
                    declarations.add(new JavaObjectPropertyDeclarations(this, names, (OWLObjectProperty)property));
                    continue;
                }
                declarations.add(new JavaDataPropertyDeclarations(this, cls, (OWLDataProperty)property));
            }
        }
        return declarations;
    }

    @Override
    public OWLClass getRange(OWLObjectProperty p) {
        if (this.objectRangeMap == null) {
            this.intializeObjectRangeMap();
        }
        return this.objectRangeMap.get(p);
    }

    @Override
    public OWLClass getRange(OWLClass owlClass, OWLObjectProperty p) {
        return this.getRange(p);
    }

    @Override
    public OWLDatatype getRange(OWLDataProperty p) {
        if (this.dataRangeMap == null) {
            this.intializeDataRangeMap();
        }
        return this.dataRangeMap.get(p);
    }

    @Override
    public OWLDatatype getRange(OWLClass owlClass, OWLDataProperty p) {
        return this.getRange(p);
    }

    @Override
    public Collection<OWLNamedIndividual> getIndividuals(OWLClass owlClass) {
        HashSet<OWLNamedIndividual> individuals = new HashSet<OWLNamedIndividual>();
        for (OWLIndividual i : owlClass.getIndividuals(this.ontology)) {
            if (i.isAnonymous()) continue;
            individuals.add(i.asOWLNamedIndividual());
        }
        return individuals;
    }

    @Override
    public boolean canAs(OWLNamedIndividual i, OWLClass c) {
        Collection<OWLClass> types = this.getTypes(i);
        if (types.contains(c)) {
            return true;
        }
        for (OWLClass type : types) {
            if (!this.getIndirectSuperClasses(type).contains(c)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<OWLClass> getTypes(OWLNamedIndividual i) {
        HashSet<OWLClass> types = new HashSet<OWLClass>();
        for (OWLClassExpression ce : i.getTypes(this.ontology.getImportsClosure())) {
            if (ce.isAnonymous()) continue;
            types.add(ce.asOWLClass());
        }
        return types;
    }

    private void initializeInferredSubclasses() {
        this.topLevelClasses = new TreeSet<OWLClass>();
        for (OWLClass owlClass : this.ontology.getClassesInSignature()) {
            boolean foundParent = false;
            for (OWLClassExpression parent : owlClass.getSuperClasses(this.ontology)) {
                if (!this.hasGoodDirectSuperClass(owlClass, parent) && !this.searchForSuperclassesFromIntersection(owlClass, parent)) continue;
                foundParent = true;
            }
            for (OWLClassExpression parent : owlClass.getEquivalentClasses(this.ontology)) {
                if (!this.searchForSuperclassesFromIntersection(owlClass, parent)) continue;
                foundParent = true;
            }
            if (foundParent) continue;
            this.topLevelClasses.add(owlClass);
        }
    }

    private boolean hasGoodDirectSuperClass(OWLClass child, OWLClassExpression parent) {
        return !parent.isAnonymous() && !parent.equals(this.factory.getOWLThing());
    }

    private boolean searchForSuperclassesFromIntersection(OWLClass child, OWLClassExpression parent) {
        if (parent instanceof OWLObjectIntersectionOf) {
            for (OWLClassExpression conjunct : ((OWLObjectIntersectionOf)parent).getOperands()) {
                if (conjunct.isAnonymous() || conjunct.equals(this.factory.getOWLThing())) continue;
                Set<OWLClass> inferredSubclasses = this.inferredSubclassMap.get(conjunct);
                if (inferredSubclasses == null) {
                    inferredSubclasses = new TreeSet<OWLClass>();
                    this.inferredSubclassMap.put(conjunct.asOWLClass(), inferredSubclasses);
                }
                inferredSubclasses.add(child);
                return true;
            }
        }
        return false;
    }

    private void initializeDomainMap() {
        Set<OWLEntity> domains;
        OWLClass owlClass;
        this.domainMap = new HashMap<OWLClass, Set<OWLEntity>>();
        for (OWLObjectPropertyDomainAxiom axiom : this.ontology.getAxioms(AxiomType.OBJECT_PROPERTY_DOMAIN)) {
            if (axiom.getDomain().isAnonymous() || ((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) continue;
            owlClass = axiom.getDomain().asOWLClass();
            domains = this.domainMap.get(owlClass);
            if (domains == null) {
                domains = new HashSet<OWLEntity>();
                this.domainMap.put(owlClass, domains);
            }
            domains.add((OWLEntity)((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty());
        }
        for (OWLObjectPropertyDomainAxiom axiom : this.ontology.getAxioms(AxiomType.DATA_PROPERTY_DOMAIN)) {
            if (axiom.getDomain().isAnonymous() || ((OWLDataPropertyExpression)axiom.getProperty()).isAnonymous()) continue;
            owlClass = axiom.getDomain().asOWLClass();
            domains = this.domainMap.get(owlClass);
            if (domains == null) {
                domains = new HashSet<OWLEntity>();
                this.domainMap.put(owlClass, domains);
            }
            domains.add((OWLEntity)((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty());
        }
    }

    private void intializeObjectRangeMap() {
        this.objectRangeMap = new HashMap<OWLObjectProperty, OWLClass>();
        for (OWLObjectPropertyRangeAxiom axiom : this.ontology.getAxioms(AxiomType.OBJECT_PROPERTY_RANGE)) {
            OWLObjectProperty property;
            if (((OWLClassExpression)axiom.getRange()).isAnonymous() || ((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous() || this.objectRangeMap.get(property = ((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()) != null) continue;
            this.objectRangeMap.put(property, ((OWLClassExpression)axiom.getRange()).asOWLClass());
        }
    }

    private void intializeDataRangeMap() {
        this.dataRangeMap = new HashMap<OWLDataProperty, OWLDatatype>();
        for (OWLDataPropertyRangeAxiom axiom : this.ontology.getAxioms(AxiomType.DATA_PROPERTY_RANGE)) {
            if (((OWLDataPropertyExpression)axiom.getProperty()).isAnonymous()) continue;
            OWLDataProperty property = ((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty();
            OWLDatatype dt = this.getContainingDatatype((OWLDataRange)axiom.getRange());
            if (this.dataRangeMap.get(property) != null || dt == null) continue;
            this.dataRangeMap.put(property, dt);
        }
    }

    private OWLDatatype getContainingDatatype(OWLDataRange range) {
        if (range instanceof OWLDatatype) {
            return (OWLDatatype)range;
        }
        if (range instanceof OWLDatatypeRestriction) {
            return ((OWLDatatypeRestriction)range).getDatatype();
        }
        return null;
    }

    private Set<OWLClass> getIndirectSuperClasses(OWLClass cls) {
        Set<OWLClass> superClasses = this.indirectSuperclassMap.get(cls);
        if (superClasses == null) {
            superClasses = new HashSet<OWLClass>();
            this.addIndirectSuperClasses(superClasses, cls);
            this.indirectSuperclassMap.put(cls, superClasses);
        }
        return superClasses;
    }

    private void addIndirectSuperClasses(Set<OWLClass> superClasses, OWLClass cls) {
        Collection<OWLClass> newSuperClasses = this.getSuperClasses(cls);
        newSuperClasses.removeAll(superClasses);
        superClasses.addAll(newSuperClasses);
        for (OWLClass newSuperClass : newSuperClasses) {
            this.addIndirectSuperClasses(superClasses, newSuperClass);
        }
    }
}

