/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.codegeneration.inference;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.protege.owl.codegeneration.HandledDatatypes;
import org.protege.owl.codegeneration.inference.CodeGenerationInference;
import org.protege.owl.codegeneration.names.CodeGenerationNames;
import org.protege.owl.codegeneration.property.JavaDataPropertyDeclarations;
import org.protege.owl.codegeneration.property.JavaObjectPropertyDeclarations;
import org.protege.owl.codegeneration.property.JavaPropertyDeclarations;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.reasoner.InferenceType;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public class ReasonerBasedInference
implements CodeGenerationInference {
    public static final Logger LOGGER = Logger.getLogger(ReasonerBasedInference.class);
    private OWLOntology ontology;
    private OWLReasoner reasoner;
    private OWLDataFactory factory;
    private Set<OWLClass> allClasses;
    private Map<OWLClass, Set<OWLEntity>> domainMap;
    private Map<OWLClass, Map<OWLObjectProperty, OWLClass>> objectRangeMap = new HashMap<OWLClass, Map<OWLObjectProperty, OWLClass>>();
    private Map<OWLClass, Map<OWLDataProperty, OWLDatatype>> dataRangeMap = new HashMap<OWLClass, Map<OWLDataProperty, OWLDatatype>>();

    public ReasonerBasedInference(OWLOntology ontology, OWLReasoner reasoner) {
        this.ontology = ontology;
        this.reasoner = reasoner;
        this.factory = ontology.getOWLOntologyManager().getOWLDataFactory();
    }

    @Override
    public OWLOntology getOWLOntology() {
        return this.ontology;
    }

    @Override
    public void preCompute() {
        this.reasoner.precomputeInferences(new InferenceType[]{InferenceType.CLASS_HIERARCHY, InferenceType.CLASS_ASSERTIONS});
    }

    @Override
    public void flush() {
        this.reasoner.flush();
    }

    @Override
    public Collection<OWLClass> getOwlClasses() {
        if (this.allClasses == null) {
            this.allClasses = new HashSet<OWLClass>(this.ontology.getClassesInSignature());
            this.allClasses.removeAll(this.reasoner.getUnsatisfiableClasses().getEntities());
            this.allClasses.removeAll(this.reasoner.getEquivalentClasses((OWLClassExpression)this.factory.getOWLThing()).getEntities());
        }
        return this.allClasses;
    }

    @Override
    public Collection<OWLClass> getSubClasses(OWLClass owlClass) {
        return this.reasoner.getSubClasses((OWLClassExpression)owlClass, true).getFlattened();
    }

    @Override
    public Collection<OWLClass> getSuperClasses(OWLClass owlClass) {
        return this.reasoner.getSuperClasses((OWLClassExpression)owlClass, true).getFlattened();
    }

    @Override
    public Set<JavaPropertyDeclarations> getJavaPropertyDeclarations(OWLClass cls, CodeGenerationNames names) {
        if (this.domainMap == null) {
            this.initializeDomainMap();
        }
        HashSet<JavaPropertyDeclarations> declarations = new HashSet<JavaPropertyDeclarations>();
        if (this.domainMap.get(cls) != null) {
            for (OWLEntity p : this.domainMap.get(cls)) {
                if (p instanceof OWLObjectProperty) {
                    declarations.add(new JavaObjectPropertyDeclarations(this, names, (OWLObjectProperty)p));
                    continue;
                }
                if (!(p instanceof OWLDataProperty)) continue;
                declarations.add(new JavaDataPropertyDeclarations(this, cls, (OWLDataProperty)p));
            }
        }
        return declarations;
    }

    @Override
    public OWLClass getRange(OWLObjectProperty p) {
        return this.getRange(this.factory.getOWLThing(), p);
    }

    @Override
    public OWLClass getRange(OWLClass owlClass, OWLObjectProperty p) {
        OWLClass cls;
        Map<OWLObjectProperty, OWLClass> property2RangeMap = this.objectRangeMap.get(owlClass);
        if (property2RangeMap == null) {
            property2RangeMap = new HashMap<OWLObjectProperty, OWLClass>();
            this.objectRangeMap.put(owlClass, property2RangeMap);
        }
        if ((cls = property2RangeMap.get(p)) == null) {
            OWLObjectSomeValuesFrom possibleValues = this.factory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)this.factory.getOWLObjectInverseOf((OWLObjectPropertyExpression)p), (OWLClassExpression)owlClass);
            Set classes = this.reasoner.getEquivalentClasses((OWLClassExpression)possibleValues).getEntities();
            if (classes != null && !classes.isEmpty()) {
                cls = (OWLClass)ReasonerBasedInference.asSingleton(classes, this.ontology);
            } else {
                classes = this.reasoner.getSuperClasses((OWLClassExpression)possibleValues, true).getFlattened();
                cls = (OWLClass)ReasonerBasedInference.asSingleton(classes, this.ontology);
            }
            property2RangeMap.put(p, cls);
        }
        return cls;
    }

    @Override
    public OWLDatatype getRange(OWLDataProperty p) {
        return this.getRange(this.factory.getOWLThing(), p);
    }

    @Override
    public OWLDatatype getRange(OWLClass owlClass, OWLDataProperty p) {
        OWLDatatype range;
        Map<OWLDataProperty, OWLDatatype> property2RangeMap = this.dataRangeMap.get(owlClass);
        if (property2RangeMap == null) {
            property2RangeMap = new HashMap<OWLDataProperty, OWLDatatype>();
            this.dataRangeMap.put(owlClass, property2RangeMap);
        }
        if ((range = property2RangeMap.get(p)) == null) {
            for (HandledDatatypes handled : HandledDatatypes.values()) {
                OWLDatatype dt = this.factory.getOWLDatatype(handled.getIri());
                OWLObjectComplementOf couldHaveOtherValues = this.factory.getOWLObjectComplementOf((OWLClassExpression)this.factory.getOWLDataAllValuesFrom((OWLDataPropertyExpression)p, (OWLDataRange)dt));
                OWLObjectIntersectionOf classCouldHaveOtherValues = this.factory.getOWLObjectIntersectionOf(new OWLClassExpression[]{owlClass, couldHaveOtherValues});
                if (this.reasoner.isSatisfiable((OWLClassExpression)classCouldHaveOtherValues)) continue;
                range = dt;
                break;
            }
            if (range != null) {
                property2RangeMap.put(p, range);
            }
        }
        return range;
    }

    @Override
    public Collection<OWLNamedIndividual> getIndividuals(OWLClass owlClass) {
        return this.reasoner.getInstances((OWLClassExpression)owlClass, false).getFlattened();
    }

    @Override
    public boolean canAs(OWLNamedIndividual i, OWLClass c) {
        OWLDataFactory factory = this.ontology.getOWLOntologyManager().getOWLDataFactory();
        return this.reasoner.isSatisfiable((OWLClassExpression)factory.getOWLObjectIntersectionOf(new OWLClassExpression[]{c, factory.getOWLObjectOneOf(new OWLIndividual[]{i})}));
    }

    @Override
    public Collection<OWLClass> getTypes(OWLNamedIndividual i) {
        return this.reasoner.getTypes(i, true).getFlattened();
    }

    private static <X extends OWLEntity> X asSingleton(Collection<X> xs, OWLOntology owlOntology) {
        OWLEntity result = null;
        for (OWLEntity x : xs) {
            if (!owlOntology.containsEntityInSignature(x, true)) continue;
            if (result == null) {
                result = x;
                continue;
            }
            return null;
        }
        return (X)result;
    }

    private void initializeDomainMap() {
        OWLObjectSomeValuesFrom mustHavePropertyValue;
        this.domainMap = new HashMap<OWLClass, Set<OWLEntity>>();
        for (OWLObjectProperty p : this.ontology.getObjectPropertiesInSignature()) {
            mustHavePropertyValue = this.factory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)p, (OWLClassExpression)this.factory.getOWLThing());
            this.addPropertyToDomainMap((OWLEntity)p, (OWLClassExpression)mustHavePropertyValue);
        }
        for (OWLObjectProperty p : this.ontology.getDataPropertiesInSignature()) {
            mustHavePropertyValue = this.factory.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)p, (OWLDataRange)this.factory.getTopDatatype());
            this.addPropertyToDomainMap((OWLEntity)p, (OWLClassExpression)mustHavePropertyValue);
        }
    }

    private void addPropertyToDomainMap(OWLEntity p, OWLClassExpression mustHavePropertyValue) {
        Set equivalents = this.reasoner.getEquivalentClasses(mustHavePropertyValue).getEntities();
        if (!equivalents.isEmpty()) {
            for (OWLClass domain : equivalents) {
                this.addToDomainMap(domain, p);
            }
        } else {
            for (OWLClass domain : this.reasoner.getSuperClasses(mustHavePropertyValue, true).getFlattened()) {
                this.addToDomainMap(domain, p);
            }
        }
    }

    private void addToDomainMap(OWLClass domain, OWLEntity property) {
        Set<OWLEntity> properties = this.domainMap.get(domain);
        if (properties == null) {
            properties = new TreeSet<OWLEntity>();
            this.domainMap.put(domain, properties);
        }
        properties.add(property);
    }
}

