/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.codegeneration.impl;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.protege.owl.codegeneration.WrappedIndividual;
import org.protege.owl.codegeneration.impl.CodeGenerationHelper;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.util.OWLEntityRemover;
import org.semanticweb.owlapi.util.ShortFormProvider;
import org.semanticweb.owlapi.util.SimpleShortFormProvider;

public class WrappedIndividualImpl
implements WrappedIndividual {
    private OWLOntology owlOntology;
    private OWLNamedIndividual owlIndividual;
    private CodeGenerationHelper delegate;

    public WrappedIndividualImpl(OWLOntology owlOntology, IRI iri) {
        this(owlOntology, owlOntology.getOWLOntologyManager().getOWLDataFactory().getOWLNamedIndividual(iri));
    }

    public WrappedIndividualImpl(OWLOntology owlOntology, OWLNamedIndividual owlIndividual) {
        this.owlOntology = owlOntology;
        this.owlIndividual = owlIndividual;
        this.delegate = new CodeGenerationHelper(owlOntology, owlIndividual);
    }

    @Override
    public OWLOntology getOwlOntology() {
        return this.owlOntology;
    }

    @Override
    public OWLNamedIndividual getOwlIndividual() {
        return this.owlIndividual;
    }

    protected CodeGenerationHelper getDelegate() {
        return this.delegate;
    }

    @Override
    public void assertOwlType(OWLClassExpression type) {
        OWLOntologyManager manager = this.owlOntology.getOWLOntologyManager();
        OWLDataFactory factory = manager.getOWLDataFactory();
        manager.addAxiom(this.owlOntology, (OWLAxiom)factory.getOWLClassAssertionAxiom(type, (OWLIndividual)this.owlIndividual));
    }

    public void delete() {
        OWLEntityRemover remover = new OWLEntityRemover(this.getOwlOntology().getOWLOntologyManager(), Collections.singleton(this.getOwlOntology()));
        this.owlIndividual.accept((OWLEntityVisitor)remover);
        this.getOwlOntology().getOWLOntologyManager().applyChanges(remover.getChanges());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WrappedIndividual)) {
            return false;
        }
        WrappedIndividual other = (WrappedIndividual)obj;
        return other.getOwlOntology().equals(this.owlOntology) && other.getOwlIndividual().equals(this.owlIndividual);
    }

    public int hashCode() {
        return this.owlOntology.hashCode() + 42 * this.owlIndividual.hashCode();
    }

    @Override
    public int compareTo(WrappedIndividual o) {
        return this.owlIndividual.compareTo((Object)o.getOwlIndividual());
    }

    public String toString() {
        SimpleShortFormProvider provider = new SimpleShortFormProvider();
        StringBuffer sb = new StringBuffer();
        this.printTypes(sb, (ShortFormProvider)provider);
        sb.append('(');
        this.printObjectPropertyValues(sb, (ShortFormProvider)provider);
        this.printDataPropertyValues(sb, (ShortFormProvider)provider);
        sb.append(')');
        return sb.toString();
    }

    private void printTypes(StringBuffer sb, ShortFormProvider provider) {
        TreeSet<OWLClass> types = new TreeSet<OWLClass>();
        for (OWLClassExpression ce : this.owlIndividual.getTypes(this.owlOntology)) {
            if (ce.isAnonymous()) continue;
            types.add(ce.asOWLClass());
        }
        if (types.size() > 1) {
            sb.append('[');
        } else if (types.size() == 0) {
            sb.append("Untyped");
        }
        boolean firstTime = true;
        for (OWLClass type : types) {
            if (firstTime) {
                firstTime = false;
            } else {
                sb.append(", ");
            }
            sb.append(provider.getShortForm((OWLEntity)type));
        }
        if (types.size() > 1) {
            sb.append(']');
        }
    }

    private void printObjectPropertyValues(StringBuffer sb, ShortFormProvider provider) {
        TreeMap valueMap = new TreeMap(this.owlIndividual.getObjectPropertyValues(this.owlOntology));
        for (Map.Entry entry : valueMap.entrySet()) {
            OWLObjectPropertyExpression pe = (OWLObjectPropertyExpression)entry.getKey();
            Set values = (Set)entry.getValue();
            if (pe.isAnonymous()) continue;
            OWLObjectProperty property = pe.asOWLObjectProperty();
            sb.append(provider.getShortForm((OWLEntity)property));
            sb.append(": ");
            boolean firstTime = true;
            for (OWLIndividual value : values) {
                if (value.isAnonymous()) continue;
                if (firstTime) {
                    firstTime = false;
                } else {
                    sb.append(", ");
                }
                sb.append(provider.getShortForm((OWLEntity)value.asOWLNamedIndividual()));
            }
            sb.append("; ");
        }
    }

    private void printDataPropertyValues(StringBuffer sb, ShortFormProvider provider) {
        TreeMap valueMap = new TreeMap(this.owlIndividual.getDataPropertyValues(this.owlOntology));
        for (Map.Entry entry : valueMap.entrySet()) {
            OWLDataProperty property = ((OWLDataPropertyExpression)entry.getKey()).asOWLDataProperty();
            Set values = (Set)entry.getValue();
            sb.append(provider.getShortForm((OWLEntity)property));
            sb.append(": ");
            boolean firstTime = true;
            for (OWLLiteral value : values) {
                if (firstTime) {
                    firstTime = false;
                } else {
                    sb.append(", ");
                }
                sb.append(value.getLiteral());
            }
            sb.append("; ");
        }
    }
}

