/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.codegeneration.impl;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.protege.owl.codegeneration.WrappedIndividual;
import org.protege.owl.codegeneration.impl.WrappedIndividualImpl;
import org.protege.owl.codegeneration.inference.CodeGenerationInference;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLOntology;

public class ProtegeJavaMapping {
    private CodeGenerationInference inference;
    private OWLDataFactory dataFactory;
    private OWLOntology ontology;
    private Map<OWLClass, JavaAndOwlBean> protegeMap = new HashMap<OWLClass, JavaAndOwlBean>();
    private Map<Class<?>, JavaAndOwlBean> interfaceMap = new HashMap();
    private Map<Class<?>, JavaAndOwlBean> implementationMap = new HashMap();

    public void initialize(OWLOntology ontology, CodeGenerationInference inference) {
        this.ontology = ontology;
        this.inference = inference;
        this.dataFactory = ontology.getOWLOntologyManager().getOWLDataFactory();
    }

    public void add(String protegeClassName, Class<?> javaInterface, Class<? extends WrappedIndividualImpl> javaImplementation) {
        OWLClass protegeClass = OWLManager.getOWLDataFactory().getOWLClass(IRI.create((String)protegeClassName));
        this.add(protegeClass, javaInterface, javaImplementation);
    }

    public void add(OWLClass protegeClass, Class<?> javaInterface, Class<? extends WrappedIndividualImpl> javaImplementation) {
        JavaAndOwlBean entry = new JavaAndOwlBean(protegeClass, javaInterface, javaImplementation);
        this.protegeMap.put(protegeClass, entry);
        this.interfaceMap.put(javaInterface, entry);
        this.implementationMap.put(javaImplementation, entry);
    }

    public Class<?> getJavaInterfaceFromOwlClass(OWLClass cls) {
        JavaAndOwlBean bean = this.protegeMap.get(cls);
        return bean != null ? bean.getJavaInterface() : null;
    }

    public OWLClass getOwlClassFromJavaInterface(Class<?> javaInterface) {
        JavaAndOwlBean bean = this.interfaceMap.get(javaInterface);
        return bean != null ? bean.getProtegeClass() : null;
    }

    public <X> X create(Class<? extends X> javaInterface, String name) {
        JavaAndOwlBean entry = this.interfaceMap.get(javaInterface);
        if (entry == null) {
            return null;
        }
        OWLClass cls = entry.getProtegeClass();
        OWLNamedIndividual individual = this.dataFactory.getOWLNamedIndividual(IRI.create((String)name));
        this.ontology.getOWLOntologyManager().addAxiom(this.ontology, (OWLAxiom)this.dataFactory.getOWLClassAssertionAxiom((OWLClassExpression)cls, (OWLIndividual)individual));
        return (X)this.constructImplementation(entry.getJavaImplementation(), individual.getIRI());
    }

    public boolean canAs(WrappedIndividual resource, Class<? extends WrappedIndividual> javaInterface) {
        if (javaInterface.isAssignableFrom(resource.getClass())) {
            return true;
        }
        return this.getJavaImplementation(resource.getOwlIndividual(), javaInterface) != null;
    }

    public <X extends WrappedIndividual> X as(WrappedIndividual resource, Class<? extends X> javaInterface) {
        if (javaInterface.isAssignableFrom(resource.getClass())) {
            return (X)((WrappedIndividual)javaInterface.cast(resource));
        }
        Class<? extends X> type = this.getJavaImplementation(resource.getOwlIndividual(), javaInterface);
        return (X)(type != null ? (WrappedIndividual)this.constructImplementation(type, resource.getOwlIndividual().getIRI()) : null);
    }

    private <X> X constructImplementation(Class<? extends X> implType, IRI id) {
        try {
            Constructor<X> con = implType.getConstructor(OWLOntology.class, IRI.class);
            return con.newInstance(this.ontology, id);
        }
        catch (Throwable t) {
            ClassCastException classcast = new ClassCastException("Resource " + id.toString() + " could not be cast to type " + implType);
            classcast.initCause(t);
            throw classcast;
        }
    }

    private <X> Class<? extends X> getJavaImplementation(OWLNamedIndividual resource, Class<? extends X> javaInterface) {
        Collection<OWLClass> protegeTypes = this.inference.getTypes(resource);
        for (OWLClass type : protegeTypes) {
            Class<? extends WrappedIndividualImpl> javaImplementationClass;
            JavaAndOwlBean entry = this.protegeMap.get(type);
            if (entry == null || !javaInterface.isAssignableFrom(javaImplementationClass = entry.getJavaImplementation())) continue;
            return javaImplementationClass.asSubclass(javaInterface);
        }
        return null;
    }

    private static class JavaAndOwlBean {
        private OWLClass protegeClass;
        private Class<?> javaInterface;
        private Class<? extends WrappedIndividualImpl> javaImplementation;

        public JavaAndOwlBean(OWLClass protegeClass, Class<?> javaInterface, Class<? extends WrappedIndividualImpl> javaImplementation) {
            this.protegeClass = protegeClass;
            this.javaInterface = javaInterface;
            this.javaImplementation = javaImplementation;
        }

        public OWLClass getProtegeClass() {
            return this.protegeClass;
        }

        public Class<?> getJavaInterface() {
            return this.javaInterface;
        }

        public Class<? extends WrappedIndividualImpl> getJavaImplementation() {
            return this.javaImplementation;
        }

        public String toString() {
            return "<Class: " + this.protegeClass + ">";
        }
    }
}

