/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.codegeneration.impl;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.HashSet;
import org.protege.owl.codegeneration.CodeGenerationRuntimeException;
import org.protege.owl.codegeneration.impl.WrappedIndividualImpl;
import org.protege.owl.codegeneration.inference.CodeGenerationInference;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public class FactoryHelper {
    private OWLOntology ontology;
    private OWLOntologyManager manager;
    private OWLDataFactory factory;
    private CodeGenerationInference inference;

    public FactoryHelper(OWLOntology ontology, CodeGenerationInference inference) {
        this.ontology = ontology;
        this.inference = inference;
        this.manager = ontology.getOWLOntologyManager();
        this.factory = this.manager.getOWLDataFactory();
    }

    public void flushOwlReasoner() {
        this.inference.flush();
    }

    public <X extends WrappedIndividualImpl> X createWrappedIndividual(String name, OWLClass type, Class<X> c) {
        OWLNamedIndividual i = this.factory.getOWLNamedIndividual(IRI.create((String)name));
        boolean inSignature = false;
        for (OWLOntology inImportClosure : this.ontology.getImportsClosure()) {
            if (!inImportClosure.containsEntityInSignature((OWLEntity)i)) continue;
            inSignature = true;
            break;
        }
        if (!inSignature) {
            this.manager.addAxiom(this.ontology, (OWLAxiom)this.factory.getOWLClassAssertionAxiom((OWLClassExpression)type, (OWLIndividual)i));
        } else if (!this.inference.canAs(i, type)) {
            return null;
        }
        return this.getWrappedIndividual(name, c);
    }

    public <X extends WrappedIndividualImpl> X getWrappedIndividual(String name, OWLClass type, Class<X> c) {
        IRI iri = IRI.create((String)name);
        OWLNamedIndividual i = this.factory.getOWLNamedIndividual(iri);
        if (!this.inference.canAs(i, type)) {
            return null;
        }
        return this.getWrappedIndividual(name, c);
    }

    private <X extends WrappedIndividualImpl> X getWrappedIndividual(String name, Class<X> c) {
        try {
            Constructor<X> constructor = c.getConstructor(OWLOntology.class, IRI.class);
            return (X)((WrappedIndividualImpl)constructor.newInstance(this.ontology, IRI.create((String)name)));
        }
        catch (Exception e) {
            throw new CodeGenerationRuntimeException(e);
        }
    }

    public <X extends WrappedIndividualImpl> Collection<X> getWrappedIndividuals(OWLClass owlClass, Class<X> c) {
        HashSet<X> wrappers = new HashSet<X>();
        for (OWLNamedIndividual i : this.inference.getIndividuals(owlClass)) {
            wrappers.add(this.getWrappedIndividual(i.getIRI().toString(), c));
        }
        return wrappers;
    }
}

