/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.codegeneration.impl;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.HashSet;
import org.protege.owl.codegeneration.CodeGenerationRuntimeException;
import org.protege.owl.codegeneration.HandledDatatypes;
import org.protege.owl.codegeneration.WrappedIndividual;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public class CodeGenerationHelper {
    private OWLOntology owlOntology;
    private OWLNamedIndividual owlIndividual;
    private OWLDataFactory owlDataFactory;
    private OWLOntologyManager manager;

    public CodeGenerationHelper(OWLOntology owlOntology, OWLNamedIndividual individual) {
        this.owlOntology = owlOntology;
        this.owlIndividual = individual;
        this.manager = owlOntology.getOWLOntologyManager();
        this.owlDataFactory = this.manager.getOWLDataFactory();
    }

    public OWLOntology getOwlOntology() {
        return this.owlOntology;
    }

    public OWLNamedIndividual getOwlIndividual() {
        return this.owlIndividual;
    }

    public <X> Collection<X> getPropertyValues(OWLNamedIndividual i, OWLObjectProperty p, Class<X> c) {
        try {
            Constructor<X> constructor = c.getConstructor(OWLOntology.class, IRI.class);
            HashSet<X> results = new HashSet<X>();
            for (OWLOntology imported : this.owlOntology.getImportsClosure()) {
                for (OWLIndividual j : i.getObjectPropertyValues((OWLObjectPropertyExpression)p, imported)) {
                    if (j.isAnonymous()) continue;
                    results.add(constructor.newInstance(this.owlOntology, j.asOWLNamedIndividual().getIRI()));
                }
            }
            return results;
        }
        catch (Exception e) {
            throw new CodeGenerationRuntimeException(e);
        }
    }

    public void addPropertyValue(OWLNamedIndividual i, OWLObjectProperty p, WrappedIndividual j) {
        OWLObjectPropertyAssertionAxiom axiom = this.owlDataFactory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)p, (OWLIndividual)i, (OWLIndividual)j.getOwlIndividual());
        this.manager.addAxiom(this.owlOntology, (OWLAxiom)axiom);
    }

    public void removePropertyValue(OWLNamedIndividual i, OWLObjectProperty p, WrappedIndividual j) {
        OWLObjectPropertyAssertionAxiom axiom = this.owlDataFactory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)p, (OWLIndividual)i, (OWLIndividual)j.getOwlIndividual());
        for (OWLOntology imported : this.owlOntology.getImportsClosure()) {
            this.manager.removeAxiom(imported, (OWLAxiom)axiom);
        }
    }

    public <X> Collection<X> getPropertyValues(OWLNamedIndividual i, OWLDataProperty p, Class<X> c) {
        HashSet<X> results = new HashSet<X>();
        for (OWLOntology imported : this.owlOntology.getImportsClosure()) {
            for (OWLLiteral l : i.getDataPropertyValues((OWLDataPropertyExpression)p, imported)) {
                results.add(c.cast(CodeGenerationHelper.getObjectFromLiteral(l)));
            }
        }
        return results;
    }

    public void addPropertyValue(OWLNamedIndividual i, OWLDataProperty p, Object o) {
        OWLLiteral literal = CodeGenerationHelper.getLiteralFromObject(this.owlDataFactory, o);
        if (literal == null) {
            throw new CodeGenerationRuntimeException("Invalid type for property value object " + o);
        }
        OWLDataPropertyAssertionAxiom axiom = this.owlDataFactory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)p, (OWLIndividual)i, literal);
        this.manager.addAxiom(this.owlOntology, (OWLAxiom)axiom);
    }

    public void removePropertyValue(OWLNamedIndividual i, OWLDataProperty p, Object o) {
        OWLLiteral literal = CodeGenerationHelper.getLiteralFromObject(this.owlDataFactory, o);
        if (literal == null) {
            throw new CodeGenerationRuntimeException("Invalid type for property value object " + o);
        }
        OWLDataPropertyAssertionAxiom axiom = this.owlDataFactory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)p, (OWLIndividual)i, literal);
        this.manager.removeAxiom(this.owlOntology, (OWLAxiom)axiom);
    }

    public static Object getObjectFromLiteral(OWLLiteral literal) {
        Object o = null;
        for (HandledDatatypes handled : HandledDatatypes.values()) {
            if (!handled.isMatch(literal.getDatatype())) continue;
            o = handled.getObject(literal);
            break;
        }
        if (o == null) {
            o = literal;
        }
        return o;
    }

    public static OWLLiteral getLiteralFromObject(OWLDataFactory owlDataFactory, Object o) {
        OWLLiteral literal = null;
        if (o instanceof OWLLiteral) {
            literal = (OWLLiteral)o;
        } else {
            HandledDatatypes handled;
            HandledDatatypes[] arr$ = HandledDatatypes.values();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (literal = (handled = arr$[i$]).getLiteral(owlDataFactory, o)) == null; ++i$) {
            }
        }
        return literal;
    }
}

