/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.codegeneration;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.protege.owl.codegeneration.CodeGenerationPhase;
import org.protege.owl.codegeneration.SubstitutionVariable;
import org.protege.owl.codegeneration.Worker;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObjectProperty;

public class JavaCodeGenerator {
    public static final Logger LOGGER = Logger.getLogger(JavaCodeGenerator.class);
    private Worker worker;

    public JavaCodeGenerator(Worker worker) {
        this.worker = worker;
        worker.initialize();
    }

    public void createAll() throws IOException {
        Collection<OWLClass> owlClassList = this.worker.getOwlClasses();
        this.printVocabularyCode(owlClassList);
        this.printFactoryClassCode(owlClassList);
        for (OWLClass owlClass : owlClassList) {
            this.createInterface(owlClass);
            this.createImplementation(owlClass);
        }
    }

    private void createInterface(OWLClass owlClass) throws IOException {
        File baseFile = this.worker.getInterfaceFile(owlClass);
        FileWriter fileWriter = new FileWriter(baseFile);
        PrintWriter printWriter = new PrintWriter(fileWriter);
        this.printInterfaceCode(owlClass, printWriter);
        printWriter.close();
    }

    private void printInterfaceCode(OWLClass owlClass, PrintWriter printWriter) {
        Collection<OWLObjectProperty> owlObjectProperties = this.worker.getObjectPropertiesForClass(owlClass);
        Collection<OWLDataProperty> owlDataProperties = this.worker.getDataPropertiesForClass(owlClass);
        EnumMap<SubstitutionVariable, String> substitutions = new EnumMap<SubstitutionVariable, String>(SubstitutionVariable.class);
        this.fillAndWriteTemplate(printWriter, CodeGenerationPhase.CREATE_INTERFACE_HEADER, substitutions, owlClass, null);
        for (OWLObjectProperty owlObjectProperty : owlObjectProperties) {
            this.fillAndWriteTemplate(printWriter, CodeGenerationPhase.CREATE_OBJECT_PROPERTY_INTERFACE, substitutions, owlClass, (OWLEntity)owlObjectProperty);
        }
        for (OWLDataProperty owlDataProperty : owlDataProperties) {
            this.fillAndWriteTemplate(printWriter, CodeGenerationPhase.CREATE_DATA_PROPERTY_INTERFACE, substitutions, owlClass, (OWLEntity)owlDataProperty);
        }
        this.fillAndWriteTemplate(printWriter, CodeGenerationPhase.CREATE_INTERFACE_TAIL, substitutions, owlClass, null);
    }

    private void createImplementation(OWLClass owlClass) throws IOException {
        File baseFile = this.worker.getImplementationFile(owlClass);
        FileWriter fileWriter = new FileWriter(baseFile);
        PrintWriter printWriter = new PrintWriter(fileWriter);
        this.printImplementationCode(owlClass, printWriter);
        printWriter.close();
    }

    private void printImplementationCode(OWLClass owlClass, PrintWriter printWriter) {
        Collection<OWLObjectProperty> owlObjectProperties = this.worker.getObjectPropertiesForClass(owlClass);
        Collection<OWLDataProperty> owlDataProperties = this.worker.getDataPropertiesForClass(owlClass);
        EnumMap<SubstitutionVariable, String> substitutions = new EnumMap<SubstitutionVariable, String>(SubstitutionVariable.class);
        this.fillAndWriteTemplate(printWriter, CodeGenerationPhase.CREATE_IMPLEMENTATION_HEADER, substitutions, owlClass, null);
        for (OWLObjectProperty owlObjectProperty : owlObjectProperties) {
            this.fillAndWriteTemplate(printWriter, CodeGenerationPhase.CREATE_OBJECT_PROPERTY_IMPLEMENTATION, substitutions, owlClass, (OWLEntity)owlObjectProperty);
        }
        for (OWLDataProperty owlDataProperty : owlDataProperties) {
            this.fillAndWriteTemplate(printWriter, CodeGenerationPhase.CREATE_DATA_PROPERTY_IMPLEMENTATION, substitutions, owlClass, (OWLEntity)owlDataProperty);
        }
        this.fillAndWriteTemplate(printWriter, CodeGenerationPhase.CREATE_IMPLEMENTATION_TAIL, substitutions, owlClass, null);
    }

    private void printVocabularyCode(Collection<OWLClass> owlClassList) throws IOException {
        File vocabularyFile = this.worker.getVocabularyFile();
        FileWriter vocabularyfileWriter = new FileWriter(vocabularyFile);
        PrintWriter vocabularyPrintWriter = new PrintWriter(vocabularyfileWriter);
        EnumMap<SubstitutionVariable, String> substitutions = new EnumMap<SubstitutionVariable, String>(SubstitutionVariable.class);
        this.fillAndWriteTemplate(vocabularyPrintWriter, CodeGenerationPhase.CREATE_VOCABULARY_HEADER, substitutions, null, null);
        for (OWLClass owlClass : owlClassList) {
            this.fillAndWriteTemplate(vocabularyPrintWriter, CodeGenerationPhase.CREATE_CLASS_VOCABULARY, substitutions, owlClass, null);
        }
        for (OWLObjectProperty owlObjectProperty : this.worker.getOwlObjectProperties()) {
            this.fillAndWriteTemplate(vocabularyPrintWriter, CodeGenerationPhase.CREATE_OBJECT_PROPERTY_VOCABULARY, substitutions, null, (OWLEntity)owlObjectProperty);
        }
        for (OWLDataProperty owlDataProperty : this.worker.getOwlDataProperties()) {
            this.fillAndWriteTemplate(vocabularyPrintWriter, CodeGenerationPhase.CREATE_DATA_PROPERTY_VOCABULARY, substitutions, null, (OWLEntity)owlDataProperty);
        }
        this.fillAndWriteTemplate(vocabularyPrintWriter, CodeGenerationPhase.CREATE_VOCABULARY_TAIL, substitutions, null, null);
        vocabularyPrintWriter.close();
    }

    private void printFactoryClassCode(Collection<OWLClass> owlClassList) throws IOException {
        FileWriter factoryFileWriter = null;
        PrintWriter factoryPrintWriter = null;
        File factoryFile = this.worker.getFactoryFile();
        factoryFileWriter = new FileWriter(factoryFile);
        factoryPrintWriter = new PrintWriter(factoryFileWriter);
        EnumMap<SubstitutionVariable, String> substitutions = new EnumMap<SubstitutionVariable, String>(SubstitutionVariable.class);
        this.fillAndWriteTemplate(factoryPrintWriter, CodeGenerationPhase.CREATE_FACTORY_HEADER, substitutions, null, null);
        for (OWLClass owlClass : owlClassList) {
            this.fillAndWriteTemplate(factoryPrintWriter, CodeGenerationPhase.CREATE_FACTORY_CLASS, substitutions, owlClass, null);
        }
        this.fillAndWriteTemplate(factoryPrintWriter, CodeGenerationPhase.CREATE_FACTORY_TAIL, substitutions, null, null);
        factoryPrintWriter.close();
    }

    private void fillAndWriteTemplate(PrintWriter writer, CodeGenerationPhase phase, Map<SubstitutionVariable, String> substitutions, OWLClass owlClass, OWLEntity owlProperty) {
        this.worker.configureSubstitutions(phase, substitutions, owlClass, owlProperty);
        String template = this.worker.getTemplate(phase, owlClass, owlProperty);
        JavaCodeGenerator.fillTemplate(writer, template, substitutions);
    }

    public static void fillTemplate(PrintWriter writer, String template, Map<SubstitutionVariable, String> substitutions) {
        for (Map.Entry<SubstitutionVariable, String> entry : substitutions.entrySet()) {
            SubstitutionVariable var = entry.getKey();
            String replacement = entry.getValue();
            template = template.replaceAll("\\$\\{" + var.getName() + "\\}", replacement);
        }
        writer.append(template);
    }
}

