/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.codegeneration;

import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.vocab.XSDVocabulary;

public enum HandledDatatypes {
    STRING(XSDVocabulary.STRING.getIRI(), "String", "String"){

        @Override
        public Object getObject(OWLLiteral literal) {
            return literal.getLiteral();
        }

        @Override
        public OWLLiteral getLiteral(OWLDataFactory factory, Object o) {
            if (o instanceof String) {
                return factory.getOWLLiteral((String)o);
            }
            return null;
        }
    }
    ,
    FLOAT(XSDVocabulary.FLOAT.getIRI(), "float", "Float"){

        @Override
        public Object getObject(OWLLiteral literal) {
            return Float.valueOf(Float.parseFloat(literal.getLiteral()));
        }

        @Override
        public OWLLiteral getLiteral(OWLDataFactory factory, Object o) {
            if (o instanceof Float) {
                return factory.getOWLLiteral(((Float)o).floatValue());
            }
            return null;
        }
    }
    ,
    BOOLEAN(XSDVocabulary.BOOLEAN.getIRI(), "boolean", "Boolean"){

        @Override
        public Object getObject(OWLLiteral literal) {
            return Boolean.parseBoolean(literal.getLiteral());
        }

        @Override
        public OWLLiteral getLiteral(OWLDataFactory factory, Object o) {
            if (o instanceof Boolean) {
                return factory.getOWLLiteral(((Boolean)o).booleanValue());
            }
            return null;
        }
    }
    ,
    INTEGER(XSDVocabulary.INTEGER.getIRI(), "int", "Integer"){

        @Override
        public Object getObject(OWLLiteral literal) {
            return Integer.parseInt(literal.getLiteral());
        }

        @Override
        public OWLLiteral getLiteral(OWLDataFactory factory, Object o) {
            if (o instanceof Integer) {
                return factory.getOWLLiteral(((Integer)o).intValue());
            }
            return null;
        }

        @Override
        public boolean isMatch(OWLDatatype dt) {
            return dt.getIRI().equals(XSDVocabulary.INT.getIRI()) || dt.getIRI().equals(XSDVocabulary.INTEGER.getIRI());
        }
    };

    private IRI iri;
    private String javaType;
    private String javaClass;

    private HandledDatatypes(IRI iri, String javaType, String javaClass) {
        this.iri = iri;
        this.javaType = javaType;
        this.javaClass = javaClass;
    }

    public IRI getIri() {
        return this.iri;
    }

    public String getJavaType() {
        return this.javaType;
    }

    public String getJavaClass() {
        return this.javaClass;
    }

    public boolean isMatch(OWLDatatype dt) {
        return dt.getIRI().equals(this.iri);
    }

    public abstract Object getObject(OWLLiteral var1);

    public abstract OWLLiteral getLiteral(OWLDataFactory var1, Object var2);
}

