/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.codegeneration;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.protege.owl.codegeneration.CodeGenerationOptions;
import org.protege.owl.codegeneration.CodeGenerationPhase;
import org.protege.owl.codegeneration.Constants;
import org.protege.owl.codegeneration.JavaCodeGenerator;
import org.protege.owl.codegeneration.SubstitutionVariable;
import org.protege.owl.codegeneration.Worker;
import org.protege.owl.codegeneration.inference.CodeGenerationInference;
import org.protege.owl.codegeneration.inference.SimpleInference;
import org.protege.owl.codegeneration.names.CodeGenerationNames;
import org.protege.owl.codegeneration.names.NamingUtilities;
import org.protege.owl.codegeneration.property.JavaPropertyDeclarationCache;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;

public class DefaultWorker
implements Worker {
    private EnumMap<CodeGenerationPhase, String> templateMap = new EnumMap(CodeGenerationPhase.class);
    private OWLOntology owlOntology;
    private CodeGenerationOptions options;
    private CodeGenerationNames names;
    private CodeGenerationInference inference;
    private JavaPropertyDeclarationCache propertyDeclarations;

    public static void generateCode(OWLOntology ontology, CodeGenerationOptions options, CodeGenerationNames names) throws IOException {
        DefaultWorker.generateCode(ontology, options, names, new SimpleInference(ontology));
    }

    public static void generateCode(OWLOntology ontology, CodeGenerationOptions options, CodeGenerationNames names, CodeGenerationInference inference) throws IOException {
        DefaultWorker worker = new DefaultWorker(ontology, options, names, inference);
        JavaCodeGenerator generator = new JavaCodeGenerator(worker);
        generator.createAll();
    }

    public DefaultWorker(OWLOntology ontology, CodeGenerationOptions options, CodeGenerationNames names, CodeGenerationInference inference) {
        this.owlOntology = ontology;
        this.options = options;
        this.names = names;
        this.inference = inference;
        this.propertyDeclarations = new JavaPropertyDeclarationCache(inference, names);
    }

    @Override
    public OWLOntology getOwlOntology() {
        return this.owlOntology;
    }

    @Override
    public Collection<OWLClass> getOwlClasses() {
        return new TreeSet<OWLClass>(this.inference.getOwlClasses());
    }

    @Override
    public Collection<OWLObjectProperty> getOwlObjectProperties() {
        return new TreeSet<OWLObjectProperty>(this.owlOntology.getObjectPropertiesInSignature(true));
    }

    @Override
    public Collection<OWLDataProperty> getOwlDataProperties() {
        return new TreeSet<OWLDataProperty>(this.owlOntology.getDataPropertiesInSignature(true));
    }

    @Override
    public void initialize() {
        String pack;
        File folder = this.options.getOutputFolder();
        if (folder != null && !folder.exists()) {
            folder.mkdirs();
        }
        if ((pack = this.options.getPackage()) != null) {
            pack = pack.replace('.', '/');
            File file = folder == null ? new File(pack) : new File(folder, pack);
            file.mkdirs();
            File f = new File(file, "impl");
            f.mkdirs();
        } else {
            File file = folder == null ? new File("impl") : new File(folder, "impl");
            file.mkdirs();
        }
    }

    @Override
    public Collection<OWLObjectProperty> getObjectPropertiesForClass(OWLClass owlClass) {
        return this.propertyDeclarations.getObjectPropertiesForClass(owlClass);
    }

    @Override
    public Collection<OWLDataProperty> getDataPropertiesForClass(OWLClass owlClass) {
        return this.propertyDeclarations.getDataPropertiesForClass(owlClass);
    }

    @Override
    public File getInterfaceFile(OWLClass owlClass) {
        String interfaceName = this.names.getInterfaceName(owlClass);
        return this.getInterfaceFile(interfaceName);
    }

    @Override
    public File getImplementationFile(OWLClass owlClass) {
        String implName = this.names.getImplementationName(owlClass);
        return this.getImplementationFile(implName);
    }

    @Override
    public File getVocabularyFile() {
        return this.getInterfaceFile("Vocabulary");
    }

    @Override
    public File getFactoryFile() {
        return this.getInterfaceFile(this.options.getFactoryClassName());
    }

    @Override
    public String getTemplate(CodeGenerationPhase phase, OWLClass owlClass, Object owlProperty) {
        String resource = "/" + phase.getTemplateName();
        String template = this.templateMap.get((Object)phase);
        if (template == null) {
            try {
                int charsRead;
                URL u = CodeGenerationOptions.class.getResource(resource);
                InputStreamReader reader = new InputStreamReader(u.openStream());
                StringBuffer buffer = new StringBuffer();
                char[] characters = new char[1024];
                while ((charsRead = reader.read(characters)) >= 0) {
                    buffer.append(characters, 0, charsRead);
                }
                template = buffer.toString();
                this.templateMap.put(phase, template);
                ((Reader)reader).close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return template;
    }

    @Override
    public void configureSubstitutions(CodeGenerationPhase phase, Map<SubstitutionVariable, String> substitutions, OWLClass owlClass, OWLEntity owlProperty) {
        switch (phase) {
            case CREATE_VOCABULARY_HEADER: 
            case CREATE_FACTORY_HEADER: {
                this.configureCommonSubstitutions(substitutions, owlClass, owlProperty);
                break;
            }
            case CREATE_CLASS_VOCABULARY: 
            case CREATE_FACTORY_CLASS: {
                this.configureClassSubstitutions(substitutions, owlClass);
                break;
            }
            case CREATE_OBJECT_PROPERTY_VOCABULARY: 
            case CREATE_DATA_PROPERTY_VOCABULARY: {
                this.configurePropertySubstitutions(substitutions, owlProperty);
                break;
            }
            case CREATE_INTERFACE_HEADER: 
            case CREATE_IMPLEMENTATION_HEADER: {
                this.configureCommonSubstitutions(substitutions, owlClass, owlProperty);
                this.configureClassSubstitutions(substitutions, owlClass);
                break;
            }
            case CREATE_DATA_PROPERTY_INTERFACE: 
            case CREATE_DATA_PROPERTY_IMPLEMENTATION: 
            case CREATE_OBJECT_PROPERTY_INTERFACE: 
            case CREATE_OBJECT_PROPERTY_IMPLEMENTATION: {
                this.configureClassSubstitutions(substitutions, owlClass);
                this.configurePropertySubstitutions(substitutions, owlProperty);
                this.propertyDeclarations.get(owlClass, owlProperty).configureSubstitutions(substitutions);
            }
        }
    }

    private void configureCommonSubstitutions(Map<SubstitutionVariable, String> substitutions, OWLClass owlClass, OWLEntity owlProperty) {
        substitutions.put(SubstitutionVariable.PACKAGE, this.options.getPackage());
        substitutions.put(SubstitutionVariable.DATE, new Date().toString());
        substitutions.put(SubstitutionVariable.USER, System.getProperty("user.name"));
        substitutions.put(SubstitutionVariable.FACTORY_CLASS_NAME, this.options.getFactoryClassName());
    }

    private void configureClassSubstitutions(Map<SubstitutionVariable, String> substitutions, OWLClass owlClass) {
        String upperCaseClassName = this.names.getClassName(owlClass).toUpperCase();
        substitutions.put(SubstitutionVariable.INTERFACE_NAME, this.names.getInterfaceName(owlClass));
        substitutions.put(SubstitutionVariable.IMPLEMENTATION_NAME, this.names.getImplementationName(owlClass));
        substitutions.put(SubstitutionVariable.JAVADOC, this.getJavadoc((OWLEntity)owlClass));
        substitutions.put(SubstitutionVariable.UPPERCASE_CLASS, upperCaseClassName);
        substitutions.put(SubstitutionVariable.VOCABULARY_CLASS, "CLASS_" + upperCaseClassName);
        substitutions.put(SubstitutionVariable.CLASS_IRI, owlClass.getIRI().toString());
        substitutions.put(SubstitutionVariable.INTERFACE_LIST, this.getSuperInterfaceList(owlClass));
    }

    private void configurePropertySubstitutions(Map<SubstitutionVariable, String> substitutions, OWLEntity owlProperty) {
        String propertyName;
        if (owlProperty instanceof OWLObjectProperty) {
            OWLObjectProperty owlObjectProperty = (OWLObjectProperty)owlProperty;
            propertyName = this.names.getObjectPropertyName(owlObjectProperty);
        } else {
            OWLDataProperty owlDataProperty = (OWLDataProperty)owlProperty;
            propertyName = this.names.getDataPropertyName(owlDataProperty);
        }
        String propertyCapitalized = NamingUtilities.convertInitialLetterToUpperCase(propertyName);
        String propertyUpperCase = propertyName.toUpperCase();
        if (owlProperty instanceof OWLObjectProperty) {
            substitutions.put(SubstitutionVariable.VOCABULARY_PROPERTY, "OBJECT_PROPERTY_" + propertyUpperCase);
        } else {
            substitutions.put(SubstitutionVariable.VOCABULARY_PROPERTY, "DATA_PROPERTY_" + propertyUpperCase);
        }
        substitutions.put(SubstitutionVariable.JAVADOC, this.getJavadoc(owlProperty));
        substitutions.put(SubstitutionVariable.PROPERTY, propertyName);
        substitutions.put(SubstitutionVariable.CAPITALIZED_PROPERTY, propertyCapitalized);
        substitutions.put(SubstitutionVariable.UPPERCASE_PROPERTY, propertyUpperCase);
        substitutions.put(SubstitutionVariable.PROPERTY_IRI, owlProperty.getIRI().toString());
    }

    private File getInterfaceFile(String name) {
        String pack = this.options.getPackage();
        pack = pack != null ? pack.replace('.', '/') + "/" : "";
        return new File(this.options.getOutputFolder(), pack + name + ".java");
    }

    private String getSuperInterfaceList(OWLClass owlClass) {
        String base = this.getBaseInterface(owlClass);
        if (base == null) {
            return "WrappedIndividual";
        }
        return base;
    }

    private String getBaseInterface(OWLClass owlClass) {
        String baseInterfaceString = "";
        for (OWLClass superClass : this.inference.getSuperClasses(owlClass)) {
            if (!this.inference.getOwlClasses().contains(superClass)) continue;
            baseInterfaceString = baseInterfaceString + (baseInterfaceString.equals("") ? "" : ", ") + this.names.getInterfaceName(superClass);
        }
        if (baseInterfaceString.equals("")) {
            return null;
        }
        return baseInterfaceString;
    }

    private File getImplementationFile(String implName) {
        String pack = this.options.getPackage();
        pack = pack != null ? pack.replace('.', '/') + "/" : "";
        return new File(this.options.getOutputFolder(), pack + "impl/" + implName + ".java");
    }

    private String getJavadoc(OWLEntity e) {
        OWLAnnotation javadocAnnotation;
        StringBuffer sb = new StringBuffer();
        Set annotations = e.getAnnotations(this.owlOntology, Constants.JAVADOC);
        if (annotations.size() == 1 && (javadocAnnotation = (OWLAnnotation)annotations.iterator().next()).getValue() instanceof OWLLiteral) {
            sb.append('\n');
            sb.append(((OWLLiteral)javadocAnnotation.getValue()).getLiteral());
        }
        return sb.toString();
    }
}

