/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.codegeneration;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.protege.editor.owl.codegeneration.GenerateCodeCallback;
import org.protege.editor.owl.model.inference.NoOpReasoner;
import org.protege.owl.codegeneration.CodeGenerationOptions;

public class JavaCodeGeneratorPanel
extends JPanel {
    private static final long serialVersionUID = 4160225251535243881L;
    private GenerateCodeCallback generateCodeCallback;
    private JTextField factoryClassNameTextField;
    private JFileChooser fileChooser = new JFileChooser(".");
    private CodeGenerationOptions options;
    private JTextField packageTextField;
    private JTextField rootFolderTextField;
    private JCheckBox useReasonerCheckBox;
    private JButton okButton;
    private JButton cancelButton;

    public JavaCodeGeneratorPanel(CodeGenerationOptions options, GenerateCodeCallback generateCodeWithOptions) {
        this.options = options;
        this.generateCodeCallback = generateCodeWithOptions;
        Border border = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        this.setBorder(border);
        this.packageTextField = new JTextField();
        if (options.getPackage() != null) {
            this.packageTextField.setText(options.getPackage());
        }
        this.rootFolderTextField = new JTextField();
        if (options.getOutputFolder() != null) {
            this.rootFolderTextField.setText(options.getOutputFolder().getAbsolutePath());
        }
        this.fileChooser.setDialogTitle("Select output folder");
        this.fileChooser.setFileSelectionMode(1);
        this.factoryClassNameTextField = new JTextField();
        if (options.getFactoryClassName() != null) {
            this.factoryClassNameTextField.setText(options.getFactoryClassName());
        }
        this.useReasonerCheckBox = new JCheckBox("Use Reasoner");
        if (generateCodeWithOptions.getOWLModelManager().getReasoner() instanceof NoOpReasoner) {
            this.useReasonerCheckBox.setEnabled(false);
            options.setUseReasoner(false);
        }
        this.useReasonerCheckBox.setSelected(options.useReasoner());
        this.setLayout(new BoxLayout(this, 1));
        JButton selectFolder = new JButton("Select folder...");
        selectFolder.setAction(new AbstractAction(){
            private static final long serialVersionUID = 3783359547867594508L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaCodeGeneratorPanel.this.selectFolder();
            }
        });
        URL url = JavaCodeGeneratorPanel.class.getResource("select_folder.gif");
        selectFolder.setIcon(new ImageIcon(url));
        this.okButton = new JButton("Ok");
        this.cancelButton = new JButton("Cancel");
        JPanel rootOutPutFolderPanel = new JPanel(new BorderLayout(5, 5));
        rootOutPutFolderPanel.add((Component)new JLabel("Root output folder"), "West");
        rootOutPutFolderPanel.add((Component)selectFolder, "East");
        rootOutPutFolderPanel.add((Component)this.rootFolderTextField, "South");
        this.add(this.getComponentWithNonStretchingVertically(rootOutPutFolderPanel));
        this.add(Box.createVerticalStrut(8));
        JPanel packageNameJPanel = new JPanel(new BorderLayout());
        packageNameJPanel.add((Component)new JLabel("Java package"), "West");
        this.add(packageNameJPanel);
        this.add(this.getComponentWithNonStretchingVertically(this.packageTextField));
        this.add(Box.createVerticalStrut(8));
        JPanel factoryClassNameJPanel = new JPanel(new BorderLayout());
        factoryClassNameJPanel.add((Component)new JLabel("Factory class name"), "West");
        this.add(factoryClassNameJPanel);
        this.add(this.getComponentWithNonStretchingVertically(this.factoryClassNameTextField));
        this.add(Box.createVerticalStrut(8));
        this.add(this.createCheckBoxPanel(this.useReasonerCheckBox));
        this.add(Box.createVerticalStrut(8));
        JPanel buttonJPanel = new JPanel(new FlowLayout(1, 10, 10));
        buttonJPanel.add(this.okButton);
        buttonJPanel.add(this.cancelButton);
        this.add(buttonJPanel);
        this.setVisible(true);
        this.setButtonListeners();
        this.packageTextField.requestFocus();
    }

    private void setButtonListeners() {
        this.okButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                File newFile = null;
                String rootFolder = JavaCodeGeneratorPanel.this.rootFolderTextField.getText().trim();
                if (rootFolder.length() > 0) {
                    newFile = new File(rootFolder);
                }
                JavaCodeGeneratorPanel.this.options.setOutputFolder(newFile);
                JavaCodeGeneratorPanel.this.options.setPackage(JavaCodeGeneratorPanel.this.packageTextField.getText().trim().length() > 0 ? JavaCodeGeneratorPanel.this.packageTextField.getText().trim() : null);
                JavaCodeGeneratorPanel.this.options.setFactoryClassName(JavaCodeGeneratorPanel.this.factoryClassNameTextField.getText().trim().length() > 0 ? JavaCodeGeneratorPanel.this.factoryClassNameTextField.getText().trim() : "MyFactory");
                JavaCodeGeneratorPanel.this.options.setUseReasoner(JavaCodeGeneratorPanel.this.useReasonerCheckBox.isSelected());
                if (JavaCodeGeneratorPanel.this.options.getPackage() == null) {
                    JOptionPane.showMessageDialog(null, "Enter package name.", "Error", 0);
                } else {
                    JavaCodeGeneratorPanel.this.generateCodeCallback.okClicked();
                }
            }
        });
        this.cancelButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                JavaCodeGeneratorPanel.this.generateCodeCallback.cancelClicked();
            }
        });
    }

    private JPanel createCheckBoxPanel(Component comp) {
        JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.add("West", comp);
        southPanel.add("Center", new JPanel());
        southPanel.setPreferredSize(new Dimension(300, 24));
        return southPanel;
    }

    public void ok() {
        File newFile = null;
        String rootFolder = this.rootFolderTextField.getText().trim();
        if (rootFolder.length() > 0) {
            newFile = new File(rootFolder);
        }
        this.options.setOutputFolder(newFile);
        this.options.setUseReasoner(this.useReasonerCheckBox.isSelected());
        this.options.setFactoryClassName(this.factoryClassNameTextField.getText());
        String pack = this.packageTextField.getText().trim();
        this.options.setPackage(pack.length() > 0 ? pack : null);
    }

    private void selectFolder() {
        if (this.fileChooser.showDialog(this, "Select") == 0) {
            File file = this.fileChooser.getSelectedFile();
            this.rootFolderTextField.setText(file.toString());
        }
    }

    private JPanel getComponentWithNonStretchingVertically(JComponent component) {
        JPanel componentPanel = new JPanel(new BorderLayout());
        componentPanel.add((Component)component, "North");
        JPanel flowJPanel = new JPanel(new FlowLayout());
        componentPanel.add((Component)flowJPanel, "West");
        return componentPanel;
    }
}

