/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.codegeneration;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.protege.editor.core.ProtegeApplication;
import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;
import org.protege.editor.owl.codegeneration.GenerateCodeCallback;
import org.protege.editor.owl.codegeneration.JavaCodeGeneratorPanel;
import org.protege.editor.owl.codegeneration.ProtegeNames;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.ui.action.ProtegeOWLAction;
import org.protege.owl.codegeneration.CodeGenerationOptions;
import org.protege.owl.codegeneration.DefaultWorker;
import org.protege.owl.codegeneration.Utilities;
import org.protege.owl.codegeneration.inference.CodeGenerationInference;
import org.protege.owl.codegeneration.inference.ReasonerBasedInference;
import org.protege.owl.codegeneration.inference.SimpleInference;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public class GenerateProtegeOwlJavaCodeAction
extends ProtegeOWLAction
implements GenerateCodeCallback {
    public static final Logger LOGGER = Logger.getLogger(GenerateProtegeOwlJavaCodeAction.class);
    public static final String CODE_GENERATION_PREFERENCES = "CODE_GENERATION_PREFERENCES";
    public static final String PACKAGE_PREFS_KEY = "package";
    public static final String FOLDER_PREFS_KEY = "folder";
    public static final String FACTORY_PREFS_KEY = "factory";
    private Preferences codeGenerationPreferences = PreferencesManager.getInstance().getPreferencesForSet("CODE_GENERATION_PREFERENCES", GenerateProtegeOwlJavaCodeAction.class);
    private static final long serialVersionUID = 1L;
    private CodeGenerationOptions options;
    private JFrame codeGenOptionFrame;

    public void initialise() throws Exception {
        this.options = new CodeGenerationOptions();
        this.options.setFactoryClassName(this.codeGenerationPreferences.getString(FACTORY_PREFS_KEY, "MyFactory"));
        this.options.setPackage(this.codeGenerationPreferences.getString(PACKAGE_PREFS_KEY, ""));
        String folder = this.codeGenerationPreferences.getString(FOLDER_PREFS_KEY, null);
        if (folder == null) {
            folder = new File("").getAbsolutePath().toString();
        }
        this.options.setOutputFolder(new File(folder));
    }

    public void dispose() throws Exception {
    }

    public void actionPerformed(ActionEvent e) {
        this.showGeneratorPanel();
    }

    private void showGeneratorPanel() {
        JavaCodeGeneratorPanel javaCodeGeneratorPanel = new JavaCodeGeneratorPanel(this.options, this);
        this.codeGenOptionFrame = new JFrame("Generate Protege-OWL Java Code");
        this.codeGenOptionFrame.setDefaultCloseOperation(1);
        this.codeGenOptionFrame.add(javaCodeGeneratorPanel);
        this.codeGenOptionFrame.setSize(300, 370);
        this.codeGenOptionFrame.setVisible(true);
        GenerateProtegeOwlJavaCodeAction.center(this.codeGenOptionFrame);
    }

    public static void center(Component component) {
        Dimension screenSize = component.getToolkit().getScreenSize();
        int BORDER_SIZE = 50;
        screenSize.width -= BORDER_SIZE;
        screenSize.height -= BORDER_SIZE;
        Dimension componentSize = component.getSize();
        int xPos = (screenSize.width - componentSize.width) / 2;
        xPos = Math.max(xPos, 0);
        int yPos = (screenSize.height - componentSize.height) / 2;
        yPos = Math.max(yPos, 0);
        component.setLocation(new Point(xPos, yPos));
    }

    @Override
    public void okClicked() {
        CodeGenerationInference inference;
        this.codeGenOptionFrame.setVisible(false);
        this.codeGenerationPreferences.putString(FACTORY_PREFS_KEY, this.options.getFactoryClassName());
        this.codeGenerationPreferences.putString(PACKAGE_PREFS_KEY, this.options.getPackage());
        this.codeGenerationPreferences.putString(FOLDER_PREFS_KEY, this.options.getOutputFolder().toString());
        OWLModelManager owlModelManager = this.getOWLModelManager();
        OWLOntology owlOntology = owlModelManager.getActiveOntology();
        if (this.options.useReasoner()) {
            OWLReasoner reasoner = owlModelManager.getOWLReasonerManager().getCurrentReasoner();
            inference = new ReasonerBasedInference(owlOntology, reasoner);
        } else {
            inference = new SimpleInference(owlOntology);
        }
        try {
            Utilities.deleteFolder(this.options.getOutputFolder());
            DefaultWorker.generateCode(owlOntology, this.options, new ProtegeNames(owlModelManager, this.options), inference);
            JOptionPane.showMessageDialog(null, "Java code successfully generated.", "Information", 1);
            LOGGER.info((Object)("Java code successfully generated in folder " + this.options.getOutputFolder() + "."));
        }
        catch (IOException e) {
            ProtegeApplication.getErrorLog().logError((Throwable)e);
        }
    }

    @Override
    public void cancelClicked() {
        this.codeGenOptionFrame.setVisible(false);
    }
}

