/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.rdf.repository;

import java.util.ArrayList;
import java.util.List;
import org.openrdf.model.BNode;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.repository.RepositoryException;
import org.protege.editor.owl.rdf.SparqlResultSet;
import org.protege.owl.rdf.api.OwlTripleStore;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;

public class QueryHandler
implements TupleQueryResultHandler {
    private OwlTripleStore triples;
    private OWLDataFactory factory;
    private SparqlResultSet queryResult;

    public QueryHandler(OwlTripleStore triples, OWLDataFactory factory) {
        this.triples = triples;
        this.factory = factory;
    }

    public SparqlResultSet getQueryResult() {
        return this.queryResult;
    }

    public void startQueryResult(List<String> bindingNames) throws TupleQueryResultHandlerException {
        this.queryResult = new SparqlResultSet(bindingNames);
    }

    public void handleSolution(BindingSet bindingSet) throws TupleQueryResultHandlerException {
        try {
            ArrayList<Object> row = new ArrayList<Object>();
            for (int i = 0; i < this.queryResult.getColumnCount(); ++i) {
                String columnName = this.queryResult.getColumnName(i);
                Binding binding = bindingSet.getBinding(columnName);
                Value v = binding != null ? binding.getValue() : (Value)null;
                row.add(this.convertValue(v));
            }
            this.queryResult.addRow(row);
        }
        catch (RepositoryException re) {
            throw new TupleQueryResultHandlerException((Throwable)re);
        }
    }

    private Object convertValue(Value v) throws RepositoryException {
        Value converted = v;
        if (v instanceof BNode) {
            OWLClassExpression ce = this.triples.parseClassExpression((BNode)v);
            if (ce != null) {
                converted = ce;
            }
        } else if (v instanceof URI) {
            converted = IRI.create((String)((URI)v).stringValue());
        }
        return converted;
    }

    public void endQueryResult() throws TupleQueryResultHandlerException {
    }
}

