/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.rdf.repository;

import java.util.Map;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.protege.editor.owl.rdf.SparqlReasoner;
import org.protege.editor.owl.rdf.SparqlReasonerException;
import org.protege.editor.owl.rdf.SparqlResultSet;
import org.protege.editor.owl.rdf.repository.QueryHandler;
import org.protege.owl.rdf.Utilities;
import org.protege.owl.rdf.api.OwlTripleStore;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.util.NamespaceUtil;

public class BasicSparqlReasoner
implements SparqlReasoner {
    private OWLOntologyManager manager;
    private OwlTripleStore triples;

    public BasicSparqlReasoner(OWLOntologyManager manager) {
        this.manager = manager;
    }

    @Override
    public String getSampleQuery() {
        StringBuffer sb = new StringBuffer();
        NamespaceUtil nsUtil = new NamespaceUtil();
        for (Map.Entry entry : nsUtil.getNamespace2PrefixMap().entrySet()) {
            String ns = (String)entry.getKey();
            String prefix = (String)entry.getValue();
            sb.append("PREFIX ");
            sb.append(prefix);
            sb.append(": <");
            sb.append(ns);
            sb.append(">\n");
        }
        sb.append("SELECT ?subject ?object\n\tWHERE { ?subject rdfs:subClassOf ?object }");
        return sb.toString();
    }

    @Override
    public void precalculate() throws SparqlReasonerException {
        if (this.triples == null) {
            try {
                this.triples = Utilities.getOwlTripleStore((OWLOntologyManager)this.manager, (boolean)true);
            }
            catch (RepositoryException e) {
                throw new SparqlReasonerException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SparqlResultSet executeQuery(String query) throws SparqlReasonerException {
        SparqlResultSet sparqlResultSet;
        block6: {
            this.precalculate();
            RepositoryConnection connection = null;
            try {
                connection = this.triples.getRepository().getConnection();
                TupleQuery tquery = connection.prepareTupleQuery(QueryLanguage.SPARQL, query);
                QueryHandler handler = new QueryHandler(this.triples, this.manager.getOWLDataFactory());
                tquery.evaluate((TupleQueryResultHandler)handler);
                sparqlResultSet = handler.getQueryResult();
                if (connection == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        connection.close();
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new SparqlReasonerException(e);
                }
            }
            connection.close();
        }
        return sparqlResultSet;
    }

    @Override
    public void dispose() {
    }
}

