/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.rdf;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.table.TableCellRenderer;
import org.protege.editor.core.ProtegeApplication;
import org.protege.editor.owl.rdf.SparqlInferenceFactory;
import org.protege.editor.owl.rdf.SparqlReasoner;
import org.protege.editor.owl.rdf.SparqlReasonerException;
import org.protege.editor.owl.rdf.SparqlResultSet;
import org.protege.editor.owl.rdf.SwingResultModel;
import org.protege.editor.owl.rdf.repository.BasicSparqlReasonerFactory;
import org.protege.editor.owl.ui.renderer.OWLCellRenderer;
import org.protege.editor.owl.ui.table.BasicOWLTable;
import org.protege.editor.owl.ui.view.AbstractOWLViewComponent;

public class SparqlQueryView
extends AbstractOWLViewComponent {
    private static final long serialVersionUID = -1370725700740073290L;
    private SparqlReasoner reasoner;
    private JTextPane queryPane;
    private JButton executeQuery;
    private SwingResultModel resultModel;

    protected void initialiseOWLView() throws Exception {
        this.initializeReasoner();
        this.setLayout(new BorderLayout());
        this.add(this.createCenterComponent(), "Center");
        this.add(this.createBottomComponent(), "South");
    }

    private void initializeReasoner() {
        try {
            List<BasicSparqlReasonerFactory> plugins = Collections.singletonList(new BasicSparqlReasonerFactory());
            this.reasoner = ((SparqlInferenceFactory)plugins.iterator().next()).createReasoner(this.getOWLModelManager().getOWLOntologyManager());
            this.reasoner.precalculate();
        }
        catch (SparqlReasonerException e) {
            ProtegeApplication.getErrorLog().logError((Throwable)e);
        }
    }

    private JComponent createCenterComponent() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 1));
        this.queryPane = new JTextPane();
        this.queryPane.setText(this.reasoner.getSampleQuery());
        panel.add(this.queryPane);
        this.resultModel = new SwingResultModel();
        BasicOWLTable results = new BasicOWLTable(this.resultModel){
            private static final long serialVersionUID = 9143285439978520141L;

            protected boolean isHeaderVisible() {
                return true;
            }
        };
        OWLCellRenderer renderer = new OWLCellRenderer(this.getOWLEditorKit());
        renderer.setWrap(false);
        results.setDefaultRenderer(Object.class, (TableCellRenderer)renderer);
        JScrollPane scrollableResults = new JScrollPane((Component)results);
        panel.add(scrollableResults);
        return panel;
    }

    private JComponent createBottomComponent() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(1));
        this.executeQuery = new JButton("Execute");
        this.executeQuery.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String query = SparqlQueryView.this.queryPane.getText();
                    SparqlResultSet result = SparqlQueryView.this.reasoner.executeQuery(query);
                    SparqlQueryView.this.resultModel.setResults(result);
                }
                catch (SparqlReasonerException ex) {
                    ProtegeApplication.getErrorLog().logError((Throwable)ex);
                    JOptionPane.showMessageDialog((Component)SparqlQueryView.this.getOWLWorkspace(), ex.getMessage() + "\nSee the logs for more information.");
                }
            }
        });
        panel.add(this.executeQuery);
        return panel;
    }

    protected void disposeOWLView() {
        if (this.reasoner != null) {
            this.reasoner.dispose();
            this.reasoner = null;
        }
    }
}

