/*
 * Decompiled with CFR 0.152.
 */
package org.coode.dlquery;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.coode.dlquery.DLQueryListCellRenderer;
import org.coode.dlquery.DLQueryResultsSection;
import org.coode.dlquery.DLQueryResultsSectionItem;
import org.protege.editor.core.ui.list.MList;
import org.protege.editor.core.ui.list.MListButton;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.OWLClassExpressionComparator;
import org.protege.editor.owl.ui.explanation.ExplanationManager;
import org.protege.editor.owl.ui.framelist.ExplainButton;
import org.protege.editor.owl.ui.renderer.LinkedObjectComponent;
import org.protege.editor.owl.ui.renderer.LinkedObjectComponentMediator;
import org.protege.editor.owl.ui.view.Copyable;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public class ResultsList
extends MList
implements LinkedObjectComponent,
Copyable {
    private static final long serialVersionUID = 8184853513690586368L;
    private OWLEditorKit owlEditorKit;
    private boolean showSuperClasses;
    private boolean showAncestorClasses;
    private boolean showDescendantClasses;
    private boolean showSubClasses;
    private boolean showInstances;
    private boolean showEquivalentClasses;
    private LinkedObjectComponentMediator mediator;
    private List<ChangeListener> copyListeners = new ArrayList<ChangeListener>();

    public ResultsList(OWLEditorKit owlEditorKit) {
        this.owlEditorKit = owlEditorKit;
        this.setCellRenderer((ListCellRenderer)((Object)new DLQueryListCellRenderer(owlEditorKit)));
        this.mediator = new LinkedObjectComponentMediator(owlEditorKit, (LinkedObjectComponent)this);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                ChangeEvent ev = new ChangeEvent((Object)ResultsList.this);
                for (ChangeListener l : ResultsList.this.copyListeners) {
                    l.stateChanged(ev);
                }
            }
        });
    }

    public boolean isShowAncestorClasses() {
        return this.showAncestorClasses;
    }

    public void setShowAncestorClasses(boolean showAncestorClasses) {
        this.showAncestorClasses = showAncestorClasses;
    }

    public boolean isShowDescendantClasses() {
        return this.showDescendantClasses;
    }

    public void setShowDescendantClasses(boolean showDescendantClasses) {
        this.showDescendantClasses = showDescendantClasses;
    }

    public boolean isShowInstances() {
        return this.showInstances;
    }

    public void setShowInstances(boolean showInstances) {
        this.showInstances = showInstances;
    }

    public boolean isShowSubClasses() {
        return this.showSubClasses;
    }

    public void setShowSubClasses(boolean showSubClasses) {
        this.showSubClasses = showSubClasses;
    }

    public boolean isShowSuperClasses() {
        return this.showSuperClasses;
    }

    public void setShowSuperClasses(boolean showSuperClasses) {
        this.showSuperClasses = showSuperClasses;
    }

    public boolean isShowEquivalentClasses() {
        return this.showEquivalentClasses;
    }

    public void setShowEquivalentClasses(boolean showEquivalentClasses) {
        this.showEquivalentClasses = showEquivalentClasses;
    }

    private List<OWLClass> toSortedList(Set<OWLClass> clses) {
        OWLClassExpressionComparator descriptionComparator = new OWLClassExpressionComparator(this.owlEditorKit.getModelManager());
        ArrayList<OWLClass> list = new ArrayList<OWLClass>(clses);
        Collections.sort(list, descriptionComparator);
        return list;
    }

    public void setOWLClassExpression(OWLClassExpression description) {
        HashSet<OWLClass> resultSet;
        OWLClass owlNothing;
        Collection<Object> results;
        ArrayList<Object> data = new ArrayList<Object>();
        OWLDataFactory factory = this.owlEditorKit.getOWLModelManager().getOWLDataFactory();
        OWLReasoner reasoner = this.owlEditorKit.getModelManager().getReasoner();
        if (this.showEquivalentClasses) {
            List<OWLClass> results2 = this.toSortedList(reasoner.getEquivalentClasses(description).getEntities());
            data.add(new DLQueryResultsSection("Equivalent classes (" + results2.size() + ")"));
            for (OWLClass oWLClass : results2) {
                data.add(new DLQueryResultsSectionItem((OWLObject)oWLClass, (OWLAxiom)factory.getOWLEquivalentClassesAxiom(description, (OWLClassExpression)oWLClass)));
            }
        }
        if (this.showAncestorClasses) {
            results = this.toSortedList(reasoner.getSuperClasses(description, false).getFlattened());
            data.add(new DLQueryResultsSection("Ancestor classes (" + results.size() + ")"));
            for (OWLClass oWLClass : results) {
                data.add(new DLQueryResultsSectionItem((OWLObject)oWLClass, (OWLAxiom)factory.getOWLSubClassOfAxiom(description, (OWLClassExpression)oWLClass)));
            }
        }
        if (this.showSuperClasses) {
            results = this.toSortedList(reasoner.getSuperClasses(description, true).getFlattened());
            data.add(new DLQueryResultsSection("Super classes (" + results.size() + ")"));
            for (OWLClass oWLClass : results) {
                data.add(new DLQueryResultsSectionItem((OWLObject)oWLClass, (OWLAxiom)factory.getOWLSubClassOfAxiom(description, (OWLClassExpression)oWLClass)));
            }
        }
        if (this.showSubClasses) {
            owlNothing = this.owlEditorKit.getOWLModelManager().getOWLDataFactory().getOWLNothing();
            resultSet = new HashSet<OWLClass>();
            for (Node clsSet : reasoner.getSubClasses(description, true)) {
                if (clsSet.contains((OWLObject)owlNothing)) continue;
                resultSet.addAll(clsSet.getEntities());
            }
            List<OWLClass> list = this.toSortedList(resultSet);
            data.add(new DLQueryResultsSection("Sub classes (" + list.size() + ")"));
            for (OWLClass subClass : list) {
                data.add(new DLQueryResultsSectionItem((OWLObject)subClass, (OWLAxiom)factory.getOWLSubClassOfAxiom((OWLClassExpression)subClass, description)));
            }
        }
        if (this.showDescendantClasses) {
            owlNothing = this.owlEditorKit.getOWLModelManager().getOWLDataFactory().getOWLNothing();
            resultSet = new HashSet();
            for (Node clsSet : reasoner.getSubClasses(description, false)) {
                if (clsSet.contains((OWLObject)owlNothing)) continue;
                resultSet.addAll(clsSet.getEntities());
            }
            List<OWLClass> list = this.toSortedList(resultSet);
            data.add(new DLQueryResultsSection("Descendant classes (" + list.size() + ")"));
            for (OWLClass cls : list) {
                data.add(new DLQueryResultsSectionItem((OWLObject)cls, (OWLAxiom)factory.getOWLSubClassOfAxiom((OWLClassExpression)cls, description)));
            }
        }
        if (this.showInstances) {
            results = reasoner.getInstances(description, false).getFlattened();
            data.add(new DLQueryResultsSection("Instances (" + results.size() + ")"));
            for (OWLNamedIndividual oWLNamedIndividual : results) {
                data.add(new DLQueryResultsSectionItem((OWLObject)oWLNamedIndividual, (OWLAxiom)factory.getOWLClassAssertionAxiom(description, (OWLIndividual)oWLNamedIndividual)));
            }
        }
        this.setListData(data.toArray());
    }

    protected List<MListButton> getButtons(Object value) {
        if (value instanceof DLQueryResultsSectionItem) {
            final OWLAxiom axiom = ((DLQueryResultsSectionItem)value).getAxiom();
            ArrayList<MListButton> buttons = new ArrayList<MListButton>();
            buttons.add((MListButton)new ExplainButton(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExplanationManager em = ResultsList.this.owlEditorKit.getOWLModelManager().getExplanationManager();
                    em.handleExplain((Frame)SwingUtilities.getAncestorOfClass(Frame.class, (Component)((Object)ResultsList.this)), axiom);
                }
            }));
            return buttons;
        }
        return Collections.emptyList();
    }

    public JComponent getComponent() {
        return this;
    }

    public OWLObject getLinkedObject() {
        return this.mediator.getLinkedObject();
    }

    public Point getMouseCellLocation() {
        Rectangle r = this.getMouseCellRect();
        if (r == null) {
            return null;
        }
        Point mousePos = this.getMousePosition();
        if (mousePos == null) {
            return null;
        }
        return new Point(mousePos.x - r.x, mousePos.y - r.y);
    }

    public Rectangle getMouseCellRect() {
        Point mousePos = this.getMousePosition();
        if (mousePos == null) {
            return null;
        }
        int sel = this.locationToIndex(mousePos);
        if (sel == -1) {
            return null;
        }
        return this.getCellBounds(sel, sel);
    }

    public void setLinkedObject(OWLObject object) {
        this.mediator.setLinkedObject(object);
    }

    public boolean canCopy() {
        return this.getSelectedIndices().length > 0;
    }

    public List<OWLObject> getObjectsToCopy() {
        ArrayList<OWLObject> copyObjects = new ArrayList<OWLObject>();
        for (Object sel : this.getSelectedValues()) {
            if (!(sel instanceof DLQueryResultsSectionItem)) continue;
            copyObjects.add(((DLQueryResultsSectionItem)sel).getOWLObject());
        }
        return copyObjects;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.copyListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.copyListeners.remove(changeListener);
    }
}

