/*
 * Decompiled with CFR 0.152.
 */
package org.coode.dlquery;

import java.util.HashSet;
import java.util.Set;
import org.coode.dlquery.ReasonerQueryInvoker;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.classexpression.OWLClassExpressionLeafNode;
import org.protege.editor.owl.model.classexpression.OWLClassExpressionNodeDifference;
import org.protege.editor.owl.model.classexpression.OWLClassExpressionNodePossibly;
import org.protege.editor.owl.model.classexpression.OWLClassExpressionNodeUnion;
import org.protege.editor.owl.model.classexpression.OWLClassExpressionNodeVisitor;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public class OWLClassExpressionNodeQueryVisitor<O extends OWLObject>
implements OWLClassExpressionNodeVisitor {
    private OWLModelManager owlModelManager;
    private OWLReasoner reasoner;
    private ReasonerQueryInvoker<O> queryInvoker;
    private Set<O> results;

    public OWLClassExpressionNodeQueryVisitor(OWLModelManager manager, OWLReasoner reasoner, ReasonerQueryInvoker<O> queryInvoker) {
        this.owlModelManager = manager;
        this.reasoner = reasoner;
        this.queryInvoker = queryInvoker;
        this.results = new HashSet<O>();
    }

    public void reset() {
        this.results.clear();
    }

    public Set<O> getResults() {
        return new HashSet<O>(this.results);
    }

    public void visit(OWLClassExpressionNodeDifference node) {
        node.getLeftNode().accept((OWLClassExpressionNodeVisitor)this);
        Set<O> leftResults = this.results;
        node.getRightNode().accept((OWLClassExpressionNodeVisitor)this);
        Set<O> rightResults = this.results;
        this.results = new HashSet<O>();
        this.results.addAll(leftResults);
        this.results.remove(node.getRightNode().getClassExpression());
        this.results.removeAll(rightResults);
    }

    public void visit(OWLClassExpressionNodeUnion node) {
        node.getLeftNode().accept((OWLClassExpressionNodeVisitor)this);
        Set<O> leftResults = this.results;
        node.getRightNode().accept((OWLClassExpressionNodeVisitor)this);
        Set<O> rightResults = this.results;
        this.results = new HashSet<O>();
        this.results.addAll(leftResults);
        this.results.addAll(rightResults);
    }

    public void visit(OWLClassExpressionNodePossibly node) {
        OWLClassExpression leftDesc = node.getLeftNode().getClassExpression();
        OWLClassExpression rightDesc = node.getRightNode().getClassExpression();
        OWLObjectComplementOf negRightDesc = this.owlModelManager.getOWLDataFactory().getOWLObjectComplementOf(rightDesc);
        Set<O> leftResults = this.queryInvoker.getAnswer(this.reasoner, leftDesc);
        Set<O> rightResults = this.queryInvoker.getAnswer(this.reasoner, (OWLClassExpression)negRightDesc);
        this.results = new HashSet<O>();
        this.results.addAll(leftResults);
        this.results.removeAll(rightResults);
    }

    public void visit(OWLClassExpressionLeafNode node) {
        this.results = this.queryInvoker.getAnswer(this.reasoner, node.getClassExpression());
    }
}

