/*
 * Decompiled with CFR 0.152.
 */
package org.protege.common.log;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.protege.common.CommonProtegeProperties;

public class ProtegeRotatingAppender
extends FileAppender {
    private static final String ROTATION_COUNT_MARKER = "%u";
    private Integer rotationCount;
    private File directory;
    private String prefix;
    private String suffix;

    public ProtegeRotatingAppender() {
    }

    ProtegeRotatingAppender(Layout layout, String directory, String filename, int rotationCount) {
        this.setLayout(layout);
        this.setDirectory(directory);
        this.setRelativeFile(filename);
        this.setRotationCount(rotationCount);
    }

    public void setDirectory(String dirName) {
        this.directory = new File(CommonProtegeProperties.getDataDirectory(), dirName);
        if (!this.directory.exists() && !this.directory.mkdir()) {
            this.directory = null;
        }
        this.initializeIfReady();
    }

    public void setRelativeFile(String filename) {
        int marker = filename.lastIndexOf(ROTATION_COUNT_MARKER);
        this.prefix = filename.substring(0, marker);
        this.suffix = filename.substring(marker + ROTATION_COUNT_MARKER.length());
        this.initializeIfReady();
    }

    public void setRotationCount(int rotationCount) {
        this.rotationCount = rotationCount;
        this.initializeIfReady();
    }

    public int getRotationCount() {
        return this.rotationCount;
    }

    private boolean configured() {
        return this.directory != null && this.prefix != null && this.rotationCount != null;
    }

    private void initializeIfReady() {
        if (this.configured()) {
            this.setFile(this.getNextLogFile());
        }
    }

    private String getNextLogFile() {
        HashMap<Integer, File> matchingLogFiles = new HashMap<Integer, File>();
        int lastMatch = -1;
        for (File f : this.directory.getAbsoluteFile().listFiles()) {
            Integer count = this.matchingFile(f);
            if (count == null) continue;
            matchingLogFiles.put(count, f);
            if (lastMatch >= count) continue;
            lastMatch = count;
        }
        for (Map.Entry entry : matchingLogFiles.entrySet()) {
            if ((Integer)entry.getKey() > lastMatch - this.rotationCount + 1) continue;
            ((File)entry.getValue()).delete();
        }
        return new File(this.directory, this.prefix + (lastMatch + 1) + this.suffix).getAbsolutePath();
    }

    private Integer matchingFile(File f) {
        String relativeName = f.getName();
        if (!relativeName.startsWith(this.prefix) || !relativeName.endsWith(this.suffix) || relativeName.length() < this.prefix.length() + this.suffix.length()) {
            return null;
        }
        String countString = relativeName.substring(this.prefix.length(), relativeName.length() - this.suffix.length());
        try {
            return Integer.parseInt(countString);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

