/*
 * Decompiled with CFR 0.152.
 */
package org.protege.ontograf.common;

import ca.uvic.cs.chisel.cajun.graph.AbstractGraph;
import ca.uvic.cs.chisel.cajun.graph.node.DefaultGraphNode;
import ca.uvic.cs.chisel.cajun.graph.node.GraphNode;
import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventFilter;
import org.protege.ontograf.common.ProtegeGraphModel;
import org.protege.ontograf.ui.FrameTooltipNode;
import org.semanticweb.owlapi.model.OWLEntity;

public class ProtegeInputEventHandler
extends PBasicInputEventHandler {
    private static final int DOUBLE_CLICK = 2;
    private ProtegeGraphModel graphModel;
    private AbstractGraph graph;
    private FrameTooltipNode toolTip;
    private DefaultGraphNode currentNode;

    public ProtegeInputEventHandler(ProtegeGraphModel graphModel, AbstractGraph graph) {
        this.graphModel = graphModel;
        this.graph = graph;
        PInputEventFilter filter = new PInputEventFilter();
        filter.rejectAllEventTypes();
        filter.setAcceptsMousePressed(true);
        filter.setAcceptsMouseMoved(true);
        this.setEventFilter(filter);
    }

    public void mouseMoved(PInputEvent event) {
        if (event.getPickedNode() instanceof GraphNode) {
            if (!event.getPickedNode().equals(this.currentNode)) {
                this.showToolTip((DefaultGraphNode)event.getPickedNode());
            }
        } else if (this.currentNode != null) {
            this.hideToolTip(this.currentNode);
            this.currentNode = null;
        }
    }

    public void mousePressed(PInputEvent event) {
        this.hideToolTip(this.currentNode);
        if (event.isLeftMouseButton()) {
            if (event.getClickCount() == 2) {
                if (event.getPickedNode() instanceof GraphNode) {
                    this.expandCollapseNode((GraphNode)event.getPickedNode());
                }
            } else if (event.getClickCount() == 1 && event.isControlDown()) {
                this.showToolTip((DefaultGraphNode)event.getPickedNode());
                this.currentNode = null;
            }
        }
    }

    private void hideToolTip(DefaultGraphNode node) {
        PCamera camera = this.graph.getCanvas().getCamera();
        if (this.toolTip != null) {
            camera.removeChild((PNode)this.toolTip);
            camera.repaint();
            this.toolTip = null;
        }
    }

    private void showToolTip(DefaultGraphNode node) {
        PCamera camera = this.graph.getCanvas().getCamera();
        this.hideToolTip(node);
        this.toolTip = new FrameTooltipNode(this.graphModel.getOwlModelManager(), this.graph, (PNode)node, (OWLEntity)node.getUserObject());
        camera.addChild((PNode)this.toolTip);
        camera.repaint();
        this.currentNode = node;
    }

    private void expandCollapseNode(GraphNode graphNode) {
        graphNode.setHighlighted(false);
        graphNode.moveToFront();
        if (this.graphModel.isExpanded(graphNode)) {
            this.graphModel.collapseNode(graphNode);
        } else {
            this.graphModel.expandNode(graphNode);
        }
        this.graph.performLayout();
    }
}

