/*
 * Decompiled with CFR 0.152.
 */
package org.protege.ontograf.actions;

import ca.uvic.cs.chisel.cajun.actions.CajunAction;
import ca.uvic.cs.chisel.cajun.graph.GraphModel;
import ca.uvic.cs.chisel.cajun.graph.node.DefaultGraphNode;
import ca.uvic.cs.chisel.cajun.graph.node.GraphNode;
import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.ontograf.common.GraphController;
import org.protege.ontograf.common.util.IconConstants;
import org.protege.ontograf.ui.OntoGrafFileFilter;
import org.semanticweb.owlapi.model.OWLEntity;

public class SaveGraphAction
extends CajunAction {
    private static final long serialVersionUID = 7241297162054742885L;
    private static final String ACTION_NAME = "Save Current Graph";
    private JFileChooser fileChooser;
    private Component parent;
    private GraphController controller;

    public SaveGraphAction(Component parent, GraphController controller) {
        super(ACTION_NAME, IconConstants.ICON_SAVE_GRAPH);
        this.putValue("ShortDescription", ACTION_NAME);
        this.parent = parent;
        this.controller = controller;
        this.fileChooser = new JFileChooser();
        this.fileChooser.setDialogTitle("Save graph configuration to a file");
        this.fileChooser.addChoosableFileFilter(new OntoGrafFileFilter(new String[]{"graph"}, "OntoGraf File"));
    }

    public void doAction() {
        String msg;
        int opt;
        File file;
        int result = this.fileChooser.showSaveDialog(this.parent);
        if (result == 1) {
            return;
        }
        String filePath = this.fileChooser.getSelectedFile().getPath();
        if (!filePath.contains(".graph")) {
            filePath = filePath + ".graph";
        }
        if ((file = new File(filePath)).exists() && (opt = JOptionPane.showConfirmDialog(this.parent, msg = "The file " + file.toString() + " already exists.\nDo you want to overwrite this existing file?", "Export Warning", 0, 2)) == 1) {
            return;
        }
        try {
            PrintStream out = new PrintStream(file);
            GraphModel model = this.controller.getGraph().getModel();
            OWLModelManager owlModelManager = this.controller.getModel().getOwlModelManager();
            out.println(owlModelManager.getActiveOntology().getOntologyID().getOntologyIRI().toString());
            for (GraphNode node : model.getAllNodes()) {
                if (!(node instanceof DefaultGraphNode)) continue;
                DefaultGraphNode graphNode = (DefaultGraphNode)node;
                OWLEntity entity = (OWLEntity)graphNode.getUserObject();
                out.println(entity.getIRI().toString() + "," + graphNode.getX() + "," + graphNode.getY());
            }
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }
}

