/*
 * Decompiled with CFR 0.152.
 */
package org.protege.ontograf.actions;

import ca.uvic.cs.chisel.cajun.actions.CajunAction;
import ca.uvic.cs.chisel.cajun.graph.FlatGraph;
import ca.uvic.cs.chisel.cajun.graph.node.GraphNode;
import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;
import java.util.Set;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.ontograf.common.GraphController;
import org.protege.ontograf.common.ProtegeGraphModel;
import org.protege.ontograf.common.util.IconConstants;
import org.protege.ontograf.ui.OntoGrafFileFilter;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLEntity;

public class OpenGraphAction
extends CajunAction {
    private static final long serialVersionUID = 7241297162054742885L;
    private static final String ACTION_NAME = "Open Saved Graph";
    private JFileChooser fileChooser;
    private Component parent;
    private GraphController controller;

    public OpenGraphAction(Component parent, GraphController controller) {
        super(ACTION_NAME, IconConstants.ICON_OPEN_GRAPH);
        this.putValue("ShortDescription", ACTION_NAME);
        this.parent = parent;
        this.controller = controller;
        this.fileChooser = new JFileChooser();
        this.fileChooser.setDialogTitle("Open graph configuration file");
        this.fileChooser.addChoosableFileFilter(new OntoGrafFileFilter(new String[]{"graph"}, "OntoGraf File"));
    }

    public void doAction() {
        int result = this.fileChooser.showOpenDialog(this.parent);
        if (result == 1) {
            return;
        }
        File file = this.fileChooser.getSelectedFile();
        this.loadFromFile(file);
    }

    public void loadFromFile(File file) {
        this.controller.clear();
        ProtegeGraphModel model = this.controller.getModel();
        FlatGraph graph = (FlatGraph)this.controller.getGraph();
        OWLModelManager owlModelManager = this.controller.getModel().getOwlModelManager();
        boolean found = true;
        try {
            String activeOntologyUri;
            String ontologyUri;
            Scanner scanner = new Scanner(file);
            if (scanner.hasNextLine() && !(ontologyUri = scanner.nextLine()).equals(activeOntologyUri = owlModelManager.getActiveOntology().getOntologyID().getOntologyIRI().toString())) {
                JOptionPane.showMessageDialog(this.parent, "Sorry, but the graph description does not correspond to your active ontology.");
                return;
            }
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                String[] items = line.split(",");
                if (items.length != 3) continue;
                String uri = items[0];
                double x = Double.parseDouble(items[1]);
                double y = Double.parseDouble(items[2]);
                Set entities = owlModelManager.getOWLEntityFinder().getEntities(IRI.create((String)uri));
                if (entities != null && entities.size() > 0) {
                    for (OWLEntity owlEntity : entities) {
                        model.show(owlEntity, graph.getFilterManager());
                        GraphNode node = model.getNode(owlEntity);
                        node.setLocation(x, y);
                    }
                    continue;
                }
                found = false;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        if (!found) {
            JOptionPane.showMessageDialog(this.parent, "Some of the graph entities in the file could not be found within your currenlty loaded ontology.\nPlease make sure this saved graph corresponds to your active ontology.");
        }
    }
}

