/*
 * Decompiled with CFR 0.152.
 */
package org.protege.ontograf.actions;

import ca.uvic.cs.chisel.cajun.actions.CajunAction;
import ca.uvic.cs.chisel.cajun.graph.GraphModel;
import ca.uvic.cs.chisel.cajun.graph.arc.DefaultGraphArc;
import ca.uvic.cs.chisel.cajun.graph.arc.GraphArc;
import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.protege.ontograf.common.GraphController;
import org.protege.ontograf.common.util.IconConstants;
import org.protege.ontograf.ui.OntoGrafFileFilter;

public class ExportAsDotAction
extends CajunAction {
    private static final long serialVersionUID = 7241297162054742885L;
    private static final String ACTION_NAME = "Export Graph to DOT";
    private JFileChooser fileChooser;
    private Component parent;
    private GraphController controller;

    public ExportAsDotAction(Component parent, GraphController controller) {
        super(ACTION_NAME, IconConstants.ICON_EXPORT_DOT_GRAPH);
        this.putValue("ShortDescription", ACTION_NAME);
        this.parent = parent;
        this.controller = controller;
        this.fileChooser = new JFileChooser();
        this.fileChooser.setDialogTitle("Save graph as DOT file");
        this.fileChooser.addChoosableFileFilter(new OntoGrafFileFilter(new String[]{"dot"}, "DOT File"));
    }

    public void doAction() {
        String msg;
        int opt;
        File file;
        int result = this.fileChooser.showSaveDialog(this.parent);
        if (result == 1) {
            return;
        }
        String filePath = this.fileChooser.getSelectedFile().getPath();
        if (!filePath.contains(".dot")) {
            filePath = filePath + ".dot";
        }
        if ((file = new File(filePath)).exists() && (opt = JOptionPane.showConfirmDialog(this.parent, msg = "The file " + file.toString() + " already exists.\nDo you want to overwrite this existing file?", "Export Warning", 0, 2)) == 1) {
            return;
        }
        try {
            PrintStream out = new PrintStream(file);
            GraphModel model = this.controller.getGraph().getModel();
            out.println("digraph g {");
            for (GraphArc arc : model.getAllArcs()) {
                if (!(arc instanceof DefaultGraphArc)) continue;
                DefaultGraphArc graphArc = (DefaultGraphArc)arc;
                out.println("\t\"" + graphArc.getSource().getText() + "\" -> \"" + graphArc.getDestination().getText() + "\" [label=\"" + graphArc.getType() + "\"]");
            }
            out.println("}");
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }
}

