/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.diff.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.log4j.Logger;
import org.protege.owl.diff.Engine;
import org.protege.owl.diff.align.AlignmentAlgorithm;
import org.protege.owl.diff.present.Changes;
import org.protege.owl.diff.present.EntityBasedDiff;
import org.protege.owl.diff.present.PresentationAlgorithm;
import org.protege.owl.diff.util.ClassLoaderWrapper;
import org.semanticweb.owlapi.model.OWLEntity;

public class Util {
    public static final Logger LOGGER = Logger.getLogger(Util.class);

    private Util() {
    }

    public static String getStats(Engine e) {
        int created = 0;
        int deleted = 0;
        int refactored = 0;
        int otherwiseChanged = 0;
        Changes changes = e.getChanges();
        for (EntityBasedDiff diff : changes.getEntityBasedDiffs()) {
            OWLEntity sourceEntity = diff.getSourceEntity();
            OWLEntity targetEntity = diff.getTargetEntity();
            if (sourceEntity == null) {
                ++created;
                continue;
            }
            if (targetEntity == null) {
                ++deleted;
                continue;
            }
            if (!sourceEntity.equals(targetEntity)) {
                ++refactored;
                continue;
            }
            ++otherwiseChanged;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(created);
        sb.append(" entities created, ");
        sb.append(deleted);
        sb.append(" entities deleted, ");
        sb.append(refactored);
        sb.append(" entities renamed, ");
        sb.append(otherwiseChanged);
        sb.append(" entities modified only.");
        return sb.toString();
    }

    public static List<Class<? extends AlignmentAlgorithm>> createDeclaredAlignmentAlgorithms(ClassLoader cl) throws IOException {
        return Util.createDeclaredAlignmentAlgorithms(Util.wrapClassLoader(cl));
    }

    public static List<Class<? extends AlignmentAlgorithm>> createDeclaredAlignmentAlgorithms(ClassLoaderWrapper cl) throws IOException {
        return Util.createDeclaredAlgorithms(cl, AlignmentAlgorithm.class, "META-INF/services/org.protege.owl.diff.AlignmentAlgorithms");
    }

    public static List<Class<? extends PresentationAlgorithm>> createDeclaredPresentationAlgorithms(ClassLoader cl) throws IOException {
        return Util.createDeclaredPresentationAlgorithms(Util.wrapClassLoader(cl));
    }

    public static List<Class<? extends PresentationAlgorithm>> createDeclaredPresentationAlgorithms(ClassLoaderWrapper cl) throws IOException {
        return Util.createDeclaredAlgorithms(cl, PresentationAlgorithm.class, "META-INF/services/org.protege.owl.diff.PresentationAlgorithms");
    }

    private static ClassLoaderWrapper wrapClassLoader(final ClassLoader cl) {
        return new ClassLoaderWrapper(){

            @Override
            public Enumeration<URL> getResources(String name) throws IOException {
                return cl.getResources(name);
            }

            @Override
            public Class<?> loadClass(String name) throws ClassNotFoundException {
                return cl.loadClass(name);
            }
        };
    }

    private static <X> List<Class<? extends X>> createDeclaredAlgorithms(ClassLoaderWrapper cl, Class<? extends X> toImplement, String resourceName) throws IOException {
        ArrayList<Class<X>> algorithms = new ArrayList<Class<X>>();
        Enumeration<URL> resources = cl.getResources(resourceName);
        while (resources != null && resources.hasMoreElements()) {
            URL url = resources.nextElement();
            algorithms.addAll(Util.createDeclaredAlignmentAlgorithms(cl, url, toImplement));
        }
        return algorithms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static <X> List<Class<? extends X>> createDeclaredAlignmentAlgorithms(ClassLoaderWrapper cl, URL url, Class<? extends X> toImplement) throws IOException {
        block10: {
            algorithms = new ArrayList<Class<X>>();
            factoryReader = new BufferedReader(new InputStreamReader(url.openStream()));
            while (true) lbl-1000:
            // 6 sources

            {
                success = false;
                name = factoryReader.readLine();
                if (name == null) {
                    break block10;
                }
                if ((name = name.trim()).startsWith("#") || name.equals("")) continue;
                try {
                    clazz = cl.loadClass(name);
                    if (!toImplement.isAssignableFrom(clazz)) ** GOTO lbl-1000
                    algorithms.add(clazz.asSubclass(toImplement));
                    success = true;
                }
                catch (Exception e) {
                    Util.LOGGER.warn((Object)"Exception caught", (Throwable)e);
                }
                finally {
                    if (success) continue;
                    Util.LOGGER.warn((Object)("Problems reading " + toImplement + " instances from " + cl));
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
            finally {
                factoryReader.close();
            }
        }
        return algorithms;
    }

    public static OWLEntity getMatchingSourceEntity(Engine engine, OWLEntity target) {
        OWLEntity targetForCandidateSoure;
        Changes changes = engine.getChanges();
        if (changes == null) {
            return null;
        }
        EntityBasedDiff diff = changes.getTargetDiffMap().get(target);
        OWLEntity possibleMatchingSource = diff != null ? diff.getSourceEntity() : target;
        if (possibleMatchingSource != null && !target.equals(targetForCandidateSoure = engine.getOwlDiffMap().getEntityMap().get(possibleMatchingSource))) {
            LOGGER.warn((Object)"Presentation algorithm seems out of synchronization with alignment algorithm for the match:");
            LOGGER.warn((Object)("\t" + possibleMatchingSource + " --> " + target));
            possibleMatchingSource = null;
        }
        return possibleMatchingSource;
    }
}

