/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.diff.util;

import java.util.Collection;
import java.util.TreeSet;
import org.protege.owl.diff.present.AxiomDescribesEntitiesDetector;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;

public class GetAxiomSourceVisitor
implements OWLAxiomVisitor,
AxiomDescribesEntitiesDetector {
    private Collection<OWLEntity> sources = new TreeSet<OWLEntity>();
    private OWLOntology ontology;
    private OWLDataFactory factory;

    public GetAxiomSourceVisitor(OWLOntology ontology, OWLDataFactory factory) {
        this.ontology = ontology;
        this.factory = factory;
    }

    public Collection<OWLEntity> getSources() {
        return this.sources;
    }

    public void reset() {
        this.sources = new TreeSet<OWLEntity>();
    }

    @Override
    public Collection<OWLEntity> getSources(OWLAxiom axiom) {
        this.reset();
        axiom.accept((OWLAxiomVisitor)this);
        return this.sources;
    }

    private void add(OWLClassExpression c) {
        if (!c.isAnonymous()) {
            this.sources.add((OWLEntity)c.asOWLClass());
        }
    }

    private void add(OWLObjectPropertyExpression p) {
        if (!p.isAnonymous()) {
            this.sources.add((OWLEntity)p.asOWLObjectProperty());
        }
    }

    private void add(OWLDataPropertyExpression p) {
        if (!p.isAnonymous()) {
            this.sources.add((OWLEntity)p.asOWLDataProperty());
        }
    }

    private void add(OWLIndividual i) {
        if (!i.isAnonymous()) {
            this.sources.add((OWLEntity)i.asOWLNamedIndividual());
        }
    }

    public void visit(OWLDeclarationAxiom axiom) {
        this.sources.add(axiom.getEntity());
    }

    public void visit(OWLSubClassOfAxiom axiom) {
        this.add(axiom.getSubClass());
    }

    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        this.add(axiom.getSubject());
    }

    public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        this.add((OWLObjectPropertyExpression)axiom.getProperty());
    }

    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        this.add((OWLObjectPropertyExpression)axiom.getProperty());
    }

    public void visit(OWLDisjointClassesAxiom axiom) {
        for (OWLClassExpression expr : axiom.getClassExpressions()) {
            this.add(expr);
        }
    }

    public void visit(OWLDataPropertyDomainAxiom axiom) {
        this.add((OWLDataPropertyExpression)axiom.getProperty());
    }

    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        this.add((OWLObjectPropertyExpression)axiom.getProperty());
    }

    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        for (OWLObjectPropertyExpression pe : axiom.getProperties()) {
            this.add(pe);
        }
    }

    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        this.add(axiom.getSubject());
    }

    public void visit(OWLDifferentIndividualsAxiom axiom) {
        for (OWLIndividual i : axiom.getIndividuals()) {
            this.add(i);
        }
    }

    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        for (OWLDataPropertyExpression p : axiom.getProperties()) {
            this.add(p);
        }
    }

    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        for (OWLObjectPropertyExpression p : axiom.getProperties()) {
            this.add(p);
        }
    }

    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        this.add((OWLObjectPropertyExpression)axiom.getProperty());
    }

    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        this.add(axiom.getSubject());
    }

    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        this.add((OWLObjectPropertyExpression)axiom.getProperty());
    }

    public void visit(OWLSubObjectPropertyOfAxiom axiom) {
        this.add((OWLObjectPropertyExpression)axiom.getSubProperty());
    }

    public void visit(OWLDisjointUnionAxiom axiom) {
        this.add((OWLClassExpression)axiom.getOWLClass());
    }

    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        this.add((OWLObjectPropertyExpression)axiom.getProperty());
    }

    public void visit(OWLDataPropertyRangeAxiom axiom) {
        this.add((OWLDataPropertyExpression)axiom.getProperty());
    }

    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        this.add((OWLDataPropertyExpression)axiom.getProperty());
    }

    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        for (OWLDataPropertyExpression pe : axiom.getProperties()) {
            this.add(pe);
        }
    }

    public void visit(OWLClassAssertionAxiom axiom) {
        this.add(axiom.getIndividual());
    }

    public void visit(OWLEquivalentClassesAxiom axiom) {
        for (OWLClassExpression c : axiom.getClassExpressions()) {
            this.add(c);
        }
    }

    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        this.add(axiom.getSubject());
    }

    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        this.add((OWLObjectPropertyExpression)axiom.getProperty());
    }

    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        this.add((OWLObjectPropertyExpression)axiom.getProperty());
    }

    public void visit(OWLSubDataPropertyOfAxiom axiom) {
        this.add((OWLDataPropertyExpression)axiom.getSubProperty());
    }

    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        this.add((OWLObjectPropertyExpression)axiom.getProperty());
    }

    public void visit(OWLSameIndividualAxiom axiom) {
        for (OWLIndividual i : axiom.getIndividuals()) {
            this.add(i);
        }
    }

    public void visit(OWLSubPropertyChainOfAxiom axiom) {
        this.add(axiom.getSuperProperty());
    }

    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        this.add(axiom.getFirstProperty());
        this.add(axiom.getSecondProperty());
    }

    public void visit(OWLHasKeyAxiom axiom) {
    }

    public void visit(OWLDatatypeDefinitionAxiom axiom) {
    }

    public void visit(SWRLRule rule) {
    }

    public void visit(OWLAnnotationAssertionAxiom axiom) {
        OWLAnnotationSubject subject = axiom.getSubject();
        if (subject instanceof IRI) {
            IRI iri = (IRI)subject;
            if (this.ontology.containsClassInSignature(iri)) {
                this.sources.add((OWLEntity)this.factory.getOWLClass(iri));
            }
            if (this.ontology.containsDatatypeInSignature(iri)) {
                this.sources.add((OWLEntity)this.factory.getOWLDatatype(iri));
            }
            if (this.ontology.containsObjectPropertyInSignature(iri)) {
                this.sources.add((OWLEntity)this.factory.getOWLObjectProperty(iri));
            }
            if (this.ontology.containsDataPropertyInSignature(iri)) {
                this.sources.add((OWLEntity)this.factory.getOWLDataProperty(iri));
            }
            if (this.ontology.containsAnnotationPropertyInSignature(iri)) {
                this.sources.add((OWLEntity)this.factory.getOWLAnnotationProperty(iri));
            }
            if (this.ontology.containsIndividualInSignature(iri)) {
                this.sources.add((OWLEntity)this.factory.getOWLNamedIndividual(iri));
            }
        }
    }

    public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        this.sources.add((OWLEntity)axiom.getSubProperty());
    }

    public void visit(OWLAnnotationPropertyDomainAxiom axiom) {
        this.sources.add((OWLEntity)axiom.getProperty());
    }

    public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
        this.sources.add((OWLEntity)axiom.getProperty());
    }
}

