/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.diff.util;

import java.util.Map;
import org.protege.owl.diff.align.OwlDiffMap;
import org.protege.owl.diff.align.util.UnmappedEntityException;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.util.OWLObjectDuplicator;

public class DiffDuplicator
extends OWLObjectDuplicator {
    private OwlDiffMap diffs;

    public DiffDuplicator(OwlDiffMap diffs) {
        super(diffs.getOWLDataFactory());
        this.diffs = diffs;
    }

    public void visit(OWLClass cls) {
        this.handleEntity((OWLEntity)cls);
    }

    public void visit(OWLObjectProperty property) {
        this.handleEntity((OWLEntity)property);
    }

    public void visit(OWLDataProperty property) {
        this.handleEntity((OWLEntity)property);
    }

    public void visit(OWLAnnotationProperty property) {
        this.handleEntity((OWLEntity)property);
    }

    public void visit(OWLNamedIndividual property) {
        this.handleEntity((OWLEntity)property);
    }

    public void visit(OWLDatatype datatype) {
        this.setLastObject(datatype);
    }

    public void visit(OWLAnonymousIndividual individual) {
        Map<OWLAnonymousIndividual, OWLAnonymousIndividual> individualMap = this.diffs.getAnonymousIndividualMap();
        if (!individualMap.containsKey(individual)) {
            throw new UnmappedEntityException("Entity map should contain all referenced anonymous individuals");
        }
        this.setLastObject(individualMap.get(individual));
    }

    public void visit(IRI iri) {
        OWLDataFactory factory = this.diffs.getOWLDataFactory();
        OWLClass cls = factory.getOWLClass(iri);
        Map<OWLEntity, OWLEntity> entityMap = this.diffs.getEntityMap();
        if (entityMap.containsKey(cls)) {
            this.setLastObject(entityMap.get(cls).getIRI());
            return;
        }
        OWLObjectProperty op = factory.getOWLObjectProperty(iri);
        if (entityMap.containsKey(op)) {
            this.setLastObject(entityMap.get(op).getIRI());
            return;
        }
        OWLDataProperty dp = factory.getOWLDataProperty(iri);
        if (entityMap.containsKey(dp)) {
            this.setLastObject(entityMap.get(dp).getIRI());
            return;
        }
        OWLNamedIndividual i = factory.getOWLNamedIndividual(iri);
        if (entityMap.containsKey(i)) {
            this.setLastObject(entityMap.get(i).getIRI());
            return;
        }
        this.setLastObject(iri);
    }

    private void handleEntity(OWLEntity entity) {
        Map<OWLEntity, OWLEntity> entityMap = this.diffs.getEntityMap();
        if (!entityMap.containsKey(entity)) {
            throw new UnmappedEntityException("Entity map should contain all referenced entities");
        }
        this.setLastObject(entityMap.get(entity));
    }
}

