/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.diff.service;

import java.util.HashSet;
import java.util.Set;
import org.protege.owl.diff.DifferencePosition;
import org.protege.owl.diff.Engine;
import org.protege.owl.diff.align.OwlDiffMap;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;

public class SiblingService {
    private OwlDiffMap diffs;

    public static SiblingService get(Engine e) {
        SiblingService s = e.getService(SiblingService.class);
        if (s == null) {
            s = new SiblingService(e);
            e.addService(s);
        }
        return s;
    }

    private SiblingService(Engine e) {
        this.diffs = e.getOwlDiffMap();
    }

    public Set<OWLClass> getSourceSuperClasses(OWLClass c) {
        HashSet<OWLClass> superClasses = new HashSet<OWLClass>();
        for (OWLClassExpression ce : c.getSuperClasses(this.diffs.getSourceOntology())) {
            if (ce.isAnonymous()) continue;
            superClasses.add(ce.asOWLClass());
        }
        return superClasses;
    }

    public Set<OWLClass> getSubClasses(OWLClass c, DifferencePosition position) {
        HashSet<OWLClass> subClasses = new HashSet<OWLClass>();
        for (OWLClassExpression ce : c.getSubClasses(position.getOntology(this.diffs))) {
            if (ce.isAnonymous()) continue;
            subClasses.add(ce.asOWLClass());
        }
        return subClasses;
    }
}

