/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.diff.service;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.protege.owl.diff.Engine;
import org.protege.owl.diff.align.OwlDiffMap;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;

public final class RetirementClassService {
    public static final String RETIREMENT_CLASS_PROPERTY = "retirement.class.prefix";
    public static final String RETIREMENT_STATUS_PROPERTY = "retirement.status.property";
    public static final String RETIREMENT_STATUS_STRING = "retirement.status.string";
    public static final String RETIREMENT_META_PROPERTIES = "retirement.meta.property.";
    private String retirementClassPrefix;
    private OWLAnnotationProperty retirementStatusProperty;
    private Set<OWLAnnotationProperty> retirementMetaProperties;
    private String retirementStatusString;
    private OWLDataFactory factory;

    public static RetirementClassService get(Engine e) {
        RetirementClassService rcs = e.getService(RetirementClassService.class);
        if (rcs == null) {
            rcs = new RetirementClassService(e.getOwlDiffMap(), e.getParameters());
            e.addService(rcs);
        }
        return rcs;
    }

    private RetirementClassService(OwlDiffMap diffMap, Map<String, String> parameters) {
        String retirementMetaProperty;
        this.factory = diffMap.getOWLDataFactory();
        this.retirementClassPrefix = parameters.get(RETIREMENT_CLASS_PROPERTY);
        String retirementStatusPropertyName = parameters.get(RETIREMENT_STATUS_PROPERTY);
        this.retirementStatusString = parameters.get(RETIREMENT_STATUS_STRING);
        if (retirementStatusPropertyName != null && this.retirementStatusString != null) {
            this.retirementStatusProperty = diffMap.getOWLDataFactory().getOWLAnnotationProperty(IRI.create((String)retirementStatusPropertyName));
        }
        this.retirementMetaProperties = new HashSet<OWLAnnotationProperty>();
        int i = 0;
        while ((retirementMetaProperty = parameters.get(RETIREMENT_META_PROPERTIES + i++)) != null) {
            this.retirementMetaProperties.add(this.factory.getOWLAnnotationProperty(IRI.create((String)retirementMetaProperty)));
        }
    }

    public boolean isDisabled() {
        return this.retirementClassPrefix == null;
    }

    public boolean isRetirementAxiom(OWLAxiom axiom) {
        boolean ret = false;
        if (axiom instanceof OWLSubClassOfAxiom) {
            OWLSubClassOfAxiom subClassAxiom = (OWLSubClassOfAxiom)axiom;
            ret = !subClassAxiom.getSubClass().isAnonymous() && !subClassAxiom.getSuperClass().isAnonymous() && subClassAxiom.getSuperClass().asOWLClass().getIRI().toString().startsWith(this.retirementClassPrefix);
        } else if (axiom instanceof OWLAnnotationAssertionAxiom && this.retirementStatusProperty != null) {
            OWLAnnotationAssertionAxiom annotationAxiom = (OWLAnnotationAssertionAxiom)axiom;
            OWLAnnotationProperty property = annotationAxiom.getAnnotation().getProperty();
            if (property.equals(this.retirementStatusProperty)) {
                ret = annotationAxiom.getAnnotation().getValue() instanceof OWLLiteral && ((OWLLiteral)annotationAxiom.getAnnotation().getValue()).getLiteral().equals(this.retirementStatusString);
            } else if (property.equals(this.factory.getOWLDeprecated())) {
                ret = annotationAxiom.getAnnotation().getValue() instanceof OWLLiteral && ((OWLLiteral)annotationAxiom.getAnnotation().getValue()).getLiteral().toLowerCase().equals("true");
            } else if (this.retirementMetaProperties.contains(property)) {
                ret = true;
            }
        }
        return ret;
    }
}

