/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.diff.service;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import org.protege.owl.diff.DifferencePosition;
import org.protege.owl.diff.Engine;
import org.protege.owl.diff.present.EntityBasedDiff;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologySetProvider;
import org.semanticweb.owlapi.util.AnnotationValueShortFormProvider;
import org.semanticweb.owlapi.util.IRIShortFormProvider;
import org.semanticweb.owlapi.util.OWLOntologyImportsClosureSetProvider;
import org.semanticweb.owlapi.util.ShortFormProvider;
import uk.ac.manchester.cs.owl.owlapi.mansyntaxrenderer.ManchesterOWLSyntaxObjectRenderer;

public class RenderingService {
    public static final String NO_LANGUAGE_SET = "";
    private OWLDataFactory factory;
    private Engine engine;
    private WriterDelegate sourceWriter = new WriterDelegate();
    private ManchesterOWLSyntaxObjectRenderer sourceRenderer;
    private WriterDelegate targetWriter = new WriterDelegate();
    private ManchesterOWLSyntaxObjectRenderer targetRenderer;
    private Map<String, OWLEntity> targetNameToEntityMap;

    public static RenderingService get(Engine e) {
        RenderingService renderer = e.getService(RenderingService.class);
        if (renderer == null) {
            renderer = new RenderingService(e);
            e.addService(renderer);
        }
        return renderer;
    }

    public static ShortFormProvider getDefaultShortFormProvider(OWLOntology ontology) {
        List<OWLAnnotationProperty> annotationProperties = Collections.singletonList(OWLManager.getOWLDataFactory().getRDFSLabel());
        List<String> langs = RenderingService.getDefaultLanguages();
        return RenderingService.getShortFormProvider(ontology, annotationProperties, langs);
    }

    public static ShortFormProvider getShortFormProvider(OWLOntology ontology, List<OWLAnnotationProperty> annotationProperties, List<String> langs) {
        HashMap<OWLAnnotationProperty, List<String>> preferredLanguageMap = new HashMap<OWLAnnotationProperty, List<String>>();
        for (OWLAnnotationProperty annotationProperty : annotationProperties) {
            preferredLanguageMap.put(annotationProperty, langs);
        }
        OWLOntologyImportsClosureSetProvider ontologies = new OWLOntologyImportsClosureSetProvider(ontology.getOWLOntologyManager(), ontology);
        return new AnnotationValueShortFormProvider(annotationProperties, preferredLanguageMap, (OWLOntologySetProvider)ontologies);
    }

    public static List<String> getDefaultLanguages() {
        ArrayList<String> langs = new ArrayList<String>();
        Locale locale = Locale.getDefault();
        if (locale != null && locale.getLanguage() != null && !locale.getLanguage().equals(NO_LANGUAGE_SET)) {
            langs.add(locale.getLanguage());
            if (locale.getCountry() != null && !locale.getCountry().equals(NO_LANGUAGE_SET)) {
                langs.add(locale.getLanguage() + "-" + locale.getCountry());
            }
        }
        langs.add(NO_LANGUAGE_SET);
        String en = Locale.ENGLISH.getLanguage();
        if (!langs.contains(en)) {
            langs.add(en);
        }
        return langs;
    }

    private RenderingService(Engine e) {
        this.engine = e;
        this.factory = e.getOWLDataFactory();
    }

    public void setSourceShortFormProvider(ShortFormProvider sourceShortFormProvider) {
        this.setSourceShortFormProvider(sourceShortFormProvider, this.getIRIShortFormProvider(sourceShortFormProvider));
    }

    public void setSourceShortFormProvider(ShortFormProvider sourceShortFormProvider, IRIShortFormProvider sourceIRIShortFormProvider) {
        this.sourceRenderer = this.getRenderer(this.sourceWriter, sourceShortFormProvider, sourceIRIShortFormProvider);
    }

    public void setTargetShortFormProvider(ShortFormProvider targetShortFormProvider) {
        this.setTargetShortFormProvider(targetShortFormProvider, this.getIRIShortFormProvider(targetShortFormProvider));
    }

    public void setTargetShortFormProvider(ShortFormProvider targetShortFormProvider, IRIShortFormProvider targetIRIShortFormProvider) {
        this.targetRenderer = this.getRenderer(this.targetWriter, targetShortFormProvider, targetIRIShortFormProvider);
    }

    public boolean isReady() {
        return this.sourceRenderer != null && this.targetRenderer != null;
    }

    public String renderSourceObject(OWLObject o) {
        if (this.engine.getOwlDiffMap() == null) {
            return NO_LANGUAGE_SET;
        }
        if (this.sourceRenderer == null) {
            this.setSourceShortFormProvider(RenderingService.getDefaultShortFormProvider(this.engine.getOwlDiffMap().getSourceOntology()));
        }
        return this.render(o, DifferencePosition.SOURCE);
    }

    public String renderTargetObject(OWLObject o) {
        if (this.engine.getOwlDiffMap() == null) {
            return NO_LANGUAGE_SET;
        }
        if (this.targetRenderer == null) {
            this.setTargetShortFormProvider(RenderingService.getDefaultShortFormProvider(this.engine.getOwlDiffMap().getTargetOntology()));
        }
        return this.render(o, DifferencePosition.TARGET);
    }

    public String renderDiff(EntityBasedDiff diff) {
        StringBuffer diffDescription = new StringBuffer();
        diffDescription.append(diff.getDiffTypeDescription());
        diffDescription.append(": ");
        switch (diff.getDiffType()) {
            case CREATED: {
                diffDescription.append(this.renderTargetObject((OWLObject)diff.getTargetEntity()));
                break;
            }
            case DELETED: {
                diffDescription.append(this.renderSourceObject((OWLObject)diff.getSourceEntity()));
                break;
            }
            case EQUIVALENT: {
                break;
            }
            case MODIFIED: 
            case RENAMED: 
            case RENAMED_AND_MODIFIED: {
                diffDescription.append(this.renderSourceObject((OWLObject)diff.getSourceEntity()));
            }
        }
        return diffDescription.toString();
    }

    private String render(OWLObject o, DifferencePosition position) {
        WriterDelegate writer = position == DifferencePosition.TARGET ? this.targetWriter : this.sourceWriter;
        writer.reset();
        ManchesterOWLSyntaxObjectRenderer renderer = position == DifferencePosition.TARGET ? this.targetRenderer : this.sourceRenderer;
        o.accept((OWLObjectVisitor)renderer);
        return writer.toString();
    }

    private ManchesterOWLSyntaxObjectRenderer getRenderer(WriterDelegate writer, ShortFormProvider shortFormProvider, final IRIShortFormProvider iriShortFormProvider) {
        return new ManchesterOWLSyntaxObjectRenderer(writer, shortFormProvider){

            public void visit(IRI iri) {
                this.write(iriShortFormProvider.getShortForm(iri));
            }
        };
    }

    private IRIShortFormProvider getIRIShortFormProvider(final ShortFormProvider shortFormProvider) {
        return new IRIShortFormProvider(){

            public String getShortForm(IRI uri) {
                return shortFormProvider.getShortForm((OWLEntity)RenderingService.this.factory.getOWLClass(uri));
            }
        };
    }

    public OWLEntity getTargetEntityByRendering(String rendering) {
        if (this.targetNameToEntityMap == null) {
            this.targetNameToEntityMap = new HashMap<String, OWLEntity>();
            TreeSet<String> toRemove = new TreeSet<String>();
            for (OWLEntity e : this.engine.getOwlDiffMap().getTargetOntology().getSignature()) {
                String eRendering = this.renderTargetObject((OWLObject)e);
                if (eRendering == null) continue;
                if (this.targetNameToEntityMap.get(eRendering) != null) {
                    toRemove.add(eRendering);
                    continue;
                }
                this.targetNameToEntityMap.put(eRendering, e);
            }
            for (String ambiguousRendering : toRemove) {
                this.targetNameToEntityMap.remove(ambiguousRendering);
            }
        }
        return this.targetNameToEntityMap.get(rendering);
    }

    private static class WriterDelegate
    extends Writer {
        private StringWriter delegate;

        private void reset() {
            this.delegate = new StringWriter();
        }

        public String toString() {
            return this.delegate.getBuffer().toString();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        @Override
        public void flush() throws IOException {
            this.delegate.flush();
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            this.delegate.write(cbuf, off, len);
        }
    }
}

