/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.diff.service;

import java.util.HashSet;
import java.util.Set;
import org.protege.owl.diff.DifferencePosition;
import org.protege.owl.diff.Engine;
import org.protege.owl.diff.align.AlignmentAlgorithm;
import org.protege.owl.diff.align.AlignmentExplanation;
import org.protege.owl.diff.align.algorithms.DeferDeprecationAlgorithm;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLOntology;

public class DeprecationDeferralService {
    private boolean initialized = false;
    private boolean deprecationDeferralEnabled;
    private Engine engine;
    private Set<DeferredMatchBean> deferredMatches = new HashSet<DeferredMatchBean>();

    public static DeprecationDeferralService get(Engine e) {
        DeprecationDeferralService dds = e.getService(DeprecationDeferralService.class);
        if (dds == null) {
            dds = new DeprecationDeferralService(e);
            e.addService(dds);
        }
        return dds;
    }

    private DeprecationDeferralService(Engine e) {
        this.engine = e;
    }

    private void ensureInitialized() {
        if (!this.initialized) {
            this.deprecationDeferralEnabled = false;
            for (AlignmentAlgorithm a : this.engine.getAlignmentAlgorithms()) {
                if (!(a instanceof DeferDeprecationAlgorithm)) continue;
                this.deprecationDeferralEnabled = true;
            }
            this.initialized = true;
        }
    }

    public boolean checkDeprecation(OWLEntity sourceEntity, OWLEntity targetEntity) {
        this.ensureInitialized();
        return this.deprecationDeferralEnabled && !this.isDeprecated(sourceEntity, DifferencePosition.SOURCE) && this.isDeprecated(targetEntity, DifferencePosition.TARGET);
    }

    public boolean isDeprecated(OWLEntity e, DifferencePosition position) {
        OWLOntology ontology = position.getOntology(this.engine.getOwlDiffMap());
        for (OWLOntology ont : ontology.getImportsClosure()) {
            for (OWLAnnotation annotation : e.getAnnotations(ont, this.engine.getOWLDataFactory().getOWLDeprecated())) {
                OWLLiteral value;
                if (!(annotation.getValue() instanceof OWLLiteral) || !(value = (OWLLiteral)annotation.getValue()).isBoolean() || !value.parseBoolean()) continue;
                return true;
            }
        }
        return false;
    }

    public void addMatch(OWLEntity sourceEntity, OWLEntity targetEntity, AlignmentExplanation explanation) {
        this.deferredMatches.add(new DeferredMatchBean(sourceEntity, targetEntity, explanation));
        this.engine.getOwlDiffMap().setMatchBlocked(sourceEntity, targetEntity, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DeferredMatchBean> getDeferredMatches() {
        try {
            Set<DeferredMatchBean> set = this.deferredMatches;
            return set;
        }
        finally {
            this.deferredMatches = new HashSet<DeferredMatchBean>();
        }
    }

    public static class DeferredMatchBean {
        private OWLEntity sourceEntity;
        private OWLEntity targetEntity;
        private AlignmentExplanation explanation;

        public DeferredMatchBean(OWLEntity sourceEntity, OWLEntity targetEntity, AlignmentExplanation explanation) {
            this.sourceEntity = sourceEntity;
            this.targetEntity = targetEntity;
            this.explanation = explanation;
        }

        public OWLEntity getSourceEntity() {
            return this.sourceEntity;
        }

        public OWLEntity getTargetEntity() {
            return this.targetEntity;
        }

        public AlignmentExplanation getExplanation() {
            return this.explanation;
        }
    }
}

