/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.diff.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.protege.owl.diff.Engine;
import org.protege.owl.diff.align.OwlDiffMap;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLOntology;

public class CodeToEntityMapper {
    public static final Logger LOGGER = Logger.getLogger(CodeToEntityMapper.class);
    public static final String CODE_ANNOTATION_PROPERTY = "code.annotation.property";
    private OwlDiffMap diffMap;
    private OWLAnnotationProperty codeProperty;
    private Map<String, Collection<OWLEntity>> targetCodeToEntityMap;

    public static CodeToEntityMapper get(Engine e) {
        CodeToEntityMapper mapper = e.getService(CodeToEntityMapper.class);
        if (mapper == null) {
            mapper = new CodeToEntityMapper(e.getOwlDiffMap(), e.getParameters());
            e.addService(mapper);
        }
        return mapper;
    }

    private CodeToEntityMapper(OwlDiffMap diffMap, Map<String, String> parameters) {
        this.diffMap = diffMap;
        String codeName = parameters.get(CODE_ANNOTATION_PROPERTY);
        if (codeName == null) {
            return;
        }
        IRI codeIri = IRI.create((String)codeName);
        this.codeProperty = diffMap.getOWLDataFactory().getOWLAnnotationProperty(codeIri);
        if (!diffMap.getSourceOntology().containsAnnotationPropertyInSignature(codeIri)) {
            LOGGER.warn((Object)("Source ontology does not have selected code annotation " + codeName));
        } else if (!diffMap.getTargetOntology().containsAnnotationPropertyInSignature(codeIri)) {
            LOGGER.warn((Object)("Target ontology does not have selected code annotation " + codeName));
        }
    }

    public boolean codeNotPresent() {
        return this.codeProperty == null || !this.diffMap.getSourceOntology().containsAnnotationPropertyInSignature(this.codeProperty.getIRI()) || !this.diffMap.getTargetOntology().containsAnnotationPropertyInSignature(this.codeProperty.getIRI());
    }

    public OWLAnnotationProperty getCodeProperty() {
        return this.codeProperty;
    }

    public String getCode(OWLOntology ontology, OWLEntity entity) {
        for (OWLAnnotation annotation : entity.getAnnotations(ontology)) {
            OWLAnnotationValue value;
            if (!annotation.getProperty().equals(this.codeProperty) || !((value = annotation.getValue()) instanceof OWLLiteral)) continue;
            return ((OWLLiteral)value).getLiteral();
        }
        return null;
    }

    public Collection<OWLEntity> getTargetEntities(String code) {
        Collection<OWLEntity> targetEntities = this.getTargetCodeToEntityMap().get(code);
        if (targetEntities == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableCollection(targetEntities);
    }

    private Map<String, Collection<OWLEntity>> getTargetCodeToEntityMap() {
        if (this.targetCodeToEntityMap == null) {
            this.targetCodeToEntityMap = this.generateCodeToEntityMap(this.diffMap.getTargetOntology());
        }
        return Collections.unmodifiableMap(this.targetCodeToEntityMap);
    }

    private Map<String, Collection<OWLEntity>> generateCodeToEntityMap(OWLOntology ontology) {
        HashMap<String, ArrayList<OWLEntity>> codeToEntityMap = new HashMap<String, ArrayList<OWLEntity>>();
        for (OWLEntity entity : ontology.getSignature()) {
            String code = this.getCode(ontology, entity);
            if (code == null) continue;
            ArrayList<OWLEntity> entities = (ArrayList<OWLEntity>)codeToEntityMap.get(code);
            if (entities == null) {
                entities = new ArrayList<OWLEntity>();
                codeToEntityMap.put(code, entities);
            }
            entities.add(entity);
        }
        return Collections.unmodifiableMap(codeToEntityMap);
    }
}

