/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.diff.present.algorithms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.protege.owl.diff.Engine;
import org.protege.owl.diff.align.OwlDiffMap;
import org.protege.owl.diff.present.Changes;
import org.protege.owl.diff.present.EntityBasedDiff;
import org.protege.owl.diff.present.MatchDescription;
import org.protege.owl.diff.present.MatchedAxiom;
import org.protege.owl.diff.present.algorithms.AbstractAnalyzerAlgorithm;
import org.protege.owl.diff.service.CodeToEntityMapper;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.util.OWLObjectDuplicator;
import org.semanticweb.owlapi.vocab.XSDVocabulary;

public class IdentifySplitConcepts
extends AbstractAnalyzerAlgorithm {
    public static final MatchDescription SPLIT = new MatchDescription("Split Operation", 0);
    public static final MatchDescription COPIED_FROM_SPLIT = new MatchDescription("Copied by split operation", 2);
    public static final OWLDatatype STRING_DATATYPE = OWLManager.getOWLDataFactory().getOWLDatatype(XSDVocabulary.STRING.getIRI());
    public static final String SPLIT_FROM_ANNOTATION_PROPERTY = "split.from.annotation";
    private Changes changes;
    private OwlDiffMap diffMap;
    private CodeToEntityMapper mapper;
    private boolean disabled = false;
    private OWLAnnotationProperty splitFromProperty;

    @Override
    public void initialise(Engine e) {
        this.changes = e.getChanges();
        this.diffMap = this.changes.getRawDiffMap();
        this.mapper = CodeToEntityMapper.get(e);
        OWLDataFactory factory = this.diffMap.getOWLDataFactory();
        String splitFromPropertyName = e.getParameters().get(SPLIT_FROM_ANNOTATION_PROPERTY);
        if (splitFromPropertyName == null) {
            this.disabled = true;
            return;
        }
        this.splitFromProperty = factory.getOWLAnnotationProperty(IRI.create((String)splitFromPropertyName));
    }

    @Override
    public void apply() {
        if (this.disabled) {
            return;
        }
        for (EntityBasedDiff diff : this.changes.getEntityBasedDiffs()) {
            this.apply(diff);
        }
    }

    private void apply(EntityBasedDiff diff) {
        IRI iriOfNewlyCreatedClass = null;
        String code = null;
        MatchedAxiom splitAxiomWithBadDescription = null;
        MatchedAxiom splitFrom = null;
        for (MatchedAxiom match : diff.getAxiomMatches()) {
            if (!match.getDescription().equals(MatchedAxiom.AXIOM_ADDED) || !this.isSplitFromAnnotationAssertion(match.getTargetAxiom())) continue;
            splitAxiomWithBadDescription = match;
            splitFrom = new MatchedAxiom(null, match.getTargetAxiom(), SPLIT);
            iriOfNewlyCreatedClass = (IRI)((OWLAnnotationAssertionAxiom)match.getTargetAxiom()).getSubject();
            code = ((OWLLiteral)((OWLAnnotationAssertionAxiom)match.getTargetAxiom()).getValue()).getLiteral();
            break;
        }
        if (splitFrom != null) {
            this.changes.removeMatch(splitAxiomWithBadDescription);
            this.changes.addMatch(splitFrom);
            this.handleNewSplitAxioms(iriOfNewlyCreatedClass, code, diff);
        }
    }

    private boolean isSplitFromAnnotationAssertion(OWLAxiom axiom) {
        return axiom instanceof OWLAnnotationAssertionAxiom && ((OWLAnnotationAssertionAxiom)axiom).getProperty().equals(this.splitFromProperty) && this.diffMap.getUnmatchedTargetAxioms().contains(axiom) && ((OWLAnnotationAssertionAxiom)axiom).getSubject() instanceof IRI && ((OWLAnnotationAssertionAxiom)axiom).getValue() instanceof OWLLiteral && ((OWLLiteral)((OWLAnnotationAssertionAxiom)axiom).getValue()).getDatatype().equals(STRING_DATATYPE);
    }

    private void handleNewSplitAxioms(IRI iriOfNewlyCreatedClass, String code, EntityBasedDiff diff) {
        OWLDataFactory factory = this.diffMap.getOWLDataFactory();
        OWLClass newlyCreatedClass = factory.getOWLClass(iriOfNewlyCreatedClass);
        OWLClass classThatWasSplit = this.getClassThatWasSplit(code);
        if (classThatWasSplit != null) {
            this.handleNewSplitAxioms(newlyCreatedClass, classThatWasSplit, diff);
        }
    }

    private void handleNewSplitAxioms(OWLClass newlyCreatedClass, OWLClass classThatWasSplit, EntityBasedDiff diff) {
        OWLOntology sourceOntology = this.diffMap.getSourceOntology();
        Map<OWLClass, IRI> newTargetToSplitSource = Collections.singletonMap(newlyCreatedClass, classThatWasSplit.getIRI());
        OWLObjectDuplicator duplicator = new OWLObjectDuplicator(newTargetToSplitSource, this.diffMap.getOWLDataFactory());
        Set<OWLClassExpression> inferredParents = this.getInferredParents(sourceOntology, classThatWasSplit);
        for (MatchedAxiom match : new ArrayList<MatchedAxiom>(diff.getAxiomMatches())) {
            if (!match.getDescription().equals(MatchedAxiom.AXIOM_ADDED) || !this.cameFromSourceOntology((OWLAxiom)duplicator.duplicateObject((OWLObject)match.getTargetAxiom()), sourceOntology, classThatWasSplit, inferredParents)) continue;
            MatchedAxiom modifiedBySplit = new MatchedAxiom(null, match.getTargetAxiom(), COPIED_FROM_SPLIT);
            this.changes.removeMatch(match);
            this.changes.addMatch(modifiedBySplit);
        }
    }

    private boolean cameFromSourceOntology(OWLAxiom axiom, OWLOntology sourceOntology, OWLClass child, Set<OWLClassExpression> inferredParents) {
        if (sourceOntology.containsAxiom(axiom)) {
            return true;
        }
        if (axiom instanceof OWLSubClassOfAxiom) {
            return ((OWLSubClassOfAxiom)axiom).getSubClass().equals(child) && inferredParents.contains(((OWLSubClassOfAxiom)axiom).getSuperClass());
        }
        return false;
    }

    private Set<OWLClassExpression> getInferredParents(OWLOntology sourceOntology, OWLClass child) {
        return this.getInferredParents(sourceOntology, child, new TreeSet<OWLClass>());
    }

    private Set<OWLClassExpression> getInferredParents(OWLOntology sourceOntology, OWLClass child, Set<OWLClass> viewed) {
        TreeSet<OWLClassExpression> result = new TreeSet<OWLClassExpression>();
        if (!viewed.contains(child)) {
            viewed.add(child);
            TreeSet parents = new TreeSet();
            parents.addAll(child.getSuperClasses(sourceOntology));
            parents.addAll(child.getEquivalentClasses(sourceOntology));
            for (OWLClassExpression parent : parents) {
                if (parent instanceof OWLClass) {
                    result.add(parent);
                    result.addAll(this.getInferredParents(sourceOntology, (OWLClass)parent, viewed));
                    continue;
                }
                if (parent instanceof OWLObjectIntersectionOf) {
                    Set inferredParents = ((OWLObjectIntersectionOf)parent).getOperands();
                    result.addAll(inferredParents);
                    for (OWLClassExpression inferredParent : inferredParents) {
                        if (!(inferredParent instanceof OWLClass)) continue;
                        result.addAll(this.getInferredParents(sourceOntology, (OWLClass)inferredParent, viewed));
                    }
                    continue;
                }
                result.add(parent);
            }
        }
        return result;
    }

    private OWLClass getClassThatWasSplit(String code) {
        if (code == null) {
            return null;
        }
        Collection<OWLEntity> possiblySplitEntities = this.mapper.getTargetEntities(code);
        OWLClass classThatWasSplit = null;
        for (OWLEntity possiblySplityEntity : possiblySplitEntities) {
            if (!(possiblySplityEntity instanceof OWLClass)) continue;
            if (classThatWasSplit != null) {
                return null;
            }
            classThatWasSplit = (OWLClass)possiblySplityEntity;
            EntityBasedDiff classThatWasSplitDiff = this.changes.getTargetDiffMap().get(classThatWasSplit);
            if (classThatWasSplitDiff == null) continue;
            classThatWasSplit = (OWLClass)classThatWasSplitDiff.getSourceEntity();
        }
        return classThatWasSplit;
    }
}

