/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.diff.present.algorithms;

import java.util.ArrayList;
import org.protege.owl.diff.Engine;
import org.protege.owl.diff.present.Changes;
import org.protege.owl.diff.present.EntityBasedDiff;
import org.protege.owl.diff.present.MatchDescription;
import org.protege.owl.diff.present.MatchedAxiom;
import org.protege.owl.diff.present.algorithms.AbstractAnalyzerAlgorithm;
import org.protege.owl.diff.service.RetirementClassService;

public class IdentifyRetiredConcepts
extends AbstractAnalyzerAlgorithm {
    public static final MatchDescription RETIRED = new MatchDescription("Retired", 0);
    public static final MatchDescription DELETED_DUE_TO_RETIRE = new MatchDescription("Deleted Axiom Due to Retire Operation", 2);
    public static final int DEFAULT_IDENTIFY_RETIRED_CONCEPTS_PRIORITY = 7;
    private Changes changes;
    private RetirementClassService retiredClassService;

    public IdentifyRetiredConcepts() {
        this.setPriority(7);
    }

    @Override
    public void initialise(Engine e) {
        this.changes = e.getChanges();
        this.retiredClassService = RetirementClassService.get(e);
    }

    @Override
    public void apply() {
        for (EntityBasedDiff diff : this.changes.getEntityBasedDiffs()) {
            this.apply(diff);
        }
    }

    private void apply(EntityBasedDiff diff) {
        if (this.retiredClassService.isDisabled()) {
            return;
        }
        ArrayList<MatchedAxiom> retiringMatches = new ArrayList<MatchedAxiom>();
        ArrayList<MatchedAxiom> deletedAxiomMatches = new ArrayList<MatchedAxiom>();
        for (MatchedAxiom match : diff.getAxiomMatches()) {
            if (match.isFinal()) continue;
            if (match.getDescription().equals(MatchedAxiom.AXIOM_ADDED) && this.retiredClassService.isRetirementAxiom(match.getTargetAxiom())) {
                retiringMatches.add(match);
                continue;
            }
            if (!match.getDescription().equals(MatchedAxiom.AXIOM_DELETED)) continue;
            deletedAxiomMatches.add(match);
        }
        for (MatchedAxiom match : retiringMatches) {
            MatchedAxiom newRetired = new MatchedAxiom(null, match.getTargetAxiom(), RETIRED);
            newRetired.setFinal(true);
            this.changes.removeMatch(match);
            this.changes.addMatch(newRetired);
        }
        if (!retiringMatches.isEmpty()) {
            for (MatchedAxiom deletedAxiomMatch : deletedAxiomMatches) {
                MatchedAxiom deletedDueToRetire = new MatchedAxiom(deletedAxiomMatch.getSourceAxiom(), null, DELETED_DUE_TO_RETIRE);
                deletedDueToRetire.setFinal(true);
                this.changes.removeMatch(deletedAxiomMatch);
                this.changes.addMatch(deletedDueToRetire);
            }
        }
    }
}

