/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.diff.present.algorithms;

import org.protege.owl.diff.Engine;
import org.protege.owl.diff.present.Changes;
import org.protege.owl.diff.present.EntityBasedDiff;
import org.protege.owl.diff.present.MatchDescription;
import org.protege.owl.diff.present.MatchedAxiom;
import org.protege.owl.diff.present.algorithms.AbstractAnalyzerAlgorithm;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;

public class IdentifyRenameOperation
extends AbstractAnalyzerAlgorithm {
    public static final MatchDescription RENAMED_CHANGE_DESCRIPTION = new MatchDescription("Renamed", 1);
    private Changes changes;
    private OWLDataFactory factory;

    @Override
    public void initialise(Engine engine) {
        this.changes = engine.getChanges();
        this.factory = engine.getOWLDataFactory();
    }

    @Override
    public void apply() {
        for (EntityBasedDiff diff : this.changes.getEntityBasedDiffs()) {
            this.apply(diff);
        }
    }

    private void apply(EntityBasedDiff diff) {
        OWLEntity sourceEntity = diff.getSourceEntity();
        OWLEntity targetEntity = diff.getTargetEntity();
        if (sourceEntity != null && targetEntity != null && !sourceEntity.equals(targetEntity)) {
            this.changes.addMatch(new MatchedAxiom((OWLAxiom)this.factory.getOWLDeclarationAxiom(sourceEntity), (OWLAxiom)this.factory.getOWLDeclarationAxiom(targetEntity), RENAMED_CHANGE_DESCRIPTION));
        }
    }
}

