/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.diff.present.algorithms;

import java.util.HashSet;
import org.protege.owl.diff.Engine;
import org.protege.owl.diff.present.Changes;
import org.protege.owl.diff.present.EntityBasedDiff;
import org.protege.owl.diff.present.MatchDescription;
import org.protege.owl.diff.present.MatchedAxiom;
import org.protege.owl.diff.present.algorithms.AbstractAnalyzerAlgorithm;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;

public class IdentifyOrphanedAnnotations
extends AbstractAnalyzerAlgorithm {
    public static final MatchDescription ORPHANED_ANNOTATION = new MatchDescription("Annotation is orphaned", 2);
    private Changes changes;
    private OWLOntology sourceOntology;
    private OWLOntology targetOntology;

    @Override
    public void initialise(Engine e) {
        this.changes = e.getChanges();
        this.sourceOntology = e.getOwlDiffMap().getSourceOntology();
        this.targetOntology = e.getOwlDiffMap().getTargetOntology();
    }

    @Override
    public void apply() {
        for (EntityBasedDiff diff : this.changes.getEntityBasedDiffs()) {
            this.apply(diff);
        }
    }

    private void apply(EntityBasedDiff diff) {
        OWLEntity sourceEntity = diff.getSourceEntity();
        OWLEntity targetEntity = diff.getTargetEntity();
        if (sourceEntity != null && targetEntity != null && !sourceEntity.equals(targetEntity) && !this.targetOntology.containsEntityInSignature(sourceEntity.getIRI())) {
            this.searchForOrphanedAnnotations(diff, sourceEntity, targetEntity);
        }
    }

    private void searchForOrphanedAnnotations(EntityBasedDiff diff, OWLEntity sourceEntity, OWLEntity targetEntity) {
        HashSet<OWLAnnotationAssertionAxiom> orphans = new HashSet<OWLAnnotationAssertionAxiom>();
        for (OWLAnnotationAssertionAxiom axiom : this.sourceOntology.getAnnotationAssertionAxioms((OWLAnnotationSubject)sourceEntity.getIRI())) {
            if (!this.targetOntology.containsAxiom((OWLAxiom)axiom)) continue;
            orphans.add(axiom);
        }
        for (OWLAnnotationAssertionAxiom orphan : orphans) {
            this.changes.addMatch(new MatchedAxiom((OWLAxiom)orphan, (OWLAxiom)orphan, ORPHANED_ANNOTATION));
        }
    }
}

