/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.diff.present.algorithms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.protege.owl.diff.Engine;
import org.protege.owl.diff.align.OwlDiffMap;
import org.protege.owl.diff.present.Changes;
import org.protege.owl.diff.present.EntityBasedDiff;
import org.protege.owl.diff.present.MatchDescription;
import org.protege.owl.diff.present.MatchedAxiom;
import org.protege.owl.diff.present.algorithms.AbstractAnalyzerAlgorithm;
import org.protege.owl.diff.service.CodeToEntityMapper;
import org.protege.owl.diff.service.RetirementClassService;
import org.protege.owl.diff.util.DiffDuplicator;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.util.OWLObjectDuplicator;

public class IdentifyMergedConcepts
extends AbstractAnalyzerAlgorithm {
    public static final MatchDescription MERGE = new MatchDescription("Merge Operation", 0);
    public static final MatchDescription MERGE_AXIOM = new MatchDescription("Axiom modified by merge", 2);
    public static final MatchDescription RETIRED_DUE_TO_MERGE = new MatchDescription("Retired Due to Merge", 2);
    public static final String MERGED_INTO_ANNOTATION_PROPERTY = "merged.into.annotation";
    private Changes changes;
    private CodeToEntityMapper mapper;
    private boolean disabled = false;
    private OWLAnnotationProperty mergedIntoProperty;
    private Map<OWLEntity, IRI> mergedFromMap = new HashMap<OWLEntity, IRI>();
    private OWLObjectDuplicator sourceToTarget;
    private OWLObjectDuplicator mergeDuplicator;
    private RetirementClassService retiredClassService;

    public IdentifyMergedConcepts() {
        this.setPriority(8);
    }

    @Override
    public void initialise(Engine e) {
        this.changes = e.getChanges();
        OwlDiffMap diffMap = this.changes.getRawDiffMap();
        this.mapper = CodeToEntityMapper.get(e);
        OWLDataFactory factory = diffMap.getOWLDataFactory();
        String mergedIntoPropertyName = e.getParameters().get(MERGED_INTO_ANNOTATION_PROPERTY);
        if (mergedIntoPropertyName == null) {
            this.disabled = true;
            return;
        }
        this.mergedIntoProperty = factory.getOWLAnnotationProperty(IRI.create((String)mergedIntoPropertyName));
        this.retiredClassService = RetirementClassService.get(e);
        HashMap<IRI, IRI> mergedIntoMap = new HashMap<IRI, IRI>();
        for (OWLAxiom axiom : diffMap.getTargetOntology().getReferencingAxioms((OWLEntity)this.mergedIntoProperty)) {
            if (!this.isMergedIntoAxiom(axiom)) continue;
            OWLAnnotationAssertionAxiom annotationAssertion = (OWLAnnotationAssertionAxiom)axiom;
            IRI retiringEntity = (IRI)annotationAssertion.getSubject();
            String code = ((OWLLiteral)annotationAssertion.getAnnotation().getValue()).getLiteral();
            Collection<OWLEntity> keptEntities = this.mapper.getTargetEntities(code);
            if (retiringEntity == null || keptEntities == null || keptEntities.isEmpty()) continue;
            OWLEntity keptEntity = keptEntities.iterator().next();
            mergedIntoMap.put(retiringEntity, keptEntity.getIRI());
            this.mergedFromMap.put(keptEntity, retiringEntity);
        }
        this.sourceToTarget = new DiffDuplicator(diffMap);
        this.mergeDuplicator = new OWLObjectDuplicator(diffMap.getOWLDataFactory(), mergedIntoMap);
    }

    @Override
    public void apply() {
        if (this.disabled) {
            return;
        }
        OwlDiffMap diffMap = this.changes.getRawDiffMap();
        OWLDataFactory factory = diffMap.getOWLDataFactory();
        for (Map.Entry<OWLEntity, IRI> entry : this.mergedFromMap.entrySet()) {
            OWLEntity keptEntity = entry.getKey();
            OWLEntity retiringEntity = factory.getOWLEntity(keptEntity.getEntityType(), entry.getValue());
            EntityBasedDiff keptEntityDiff = this.changes.getTargetDiffMap().get(keptEntity);
            EntityBasedDiff retiringEntityDiff = this.changes.getTargetDiffMap().get(retiringEntity);
            if (retiringEntityDiff != null) {
                this.handleMergeDeclaration(retiringEntityDiff, keptEntityDiff);
                this.handleRetire(retiringEntityDiff);
            }
            this.handleAxiomAdjustments(keptEntityDiff, keptEntityDiff);
            if (retiringEntityDiff == null) continue;
            this.handleAxiomAdjustments(retiringEntityDiff, keptEntityDiff);
        }
    }

    private void handleMergeDeclaration(EntityBasedDiff retiringEntityDiff, EntityBasedDiff keptEntityDiff) {
        MatchedAxiom mergeDecl = null;
        for (MatchedAxiom match : retiringEntityDiff.getAxiomMatches()) {
            if (match.isFinal() || !match.getDescription().equals(MatchedAxiom.AXIOM_ADDED) || !this.isMergedIntoAxiom(match.getTargetAxiom())) continue;
            mergeDecl = match;
            break;
        }
        if (mergeDecl != null) {
            MatchedAxiom newMergeDecl = new MatchedAxiom(null, mergeDecl.getTargetAxiom(), MERGE);
            newMergeDecl.setFinal(true);
            this.changes.removeMatch(mergeDecl);
            this.changes.addMatch(newMergeDecl);
        }
    }

    private void handleRetire(EntityBasedDiff diff) {
        ArrayList<MatchedAxiom> retiringMatches = new ArrayList<MatchedAxiom>();
        for (MatchedAxiom match : diff.getAxiomMatches()) {
            if (match.isFinal() || !match.getDescription().equals(MatchedAxiom.AXIOM_ADDED) || !this.retiredClassService.isRetirementAxiom(match.getTargetAxiom())) continue;
            retiringMatches.add(match);
        }
        for (MatchedAxiom match : retiringMatches) {
            MatchedAxiom newRetired = new MatchedAxiom(null, match.getTargetAxiom(), RETIRED_DUE_TO_MERGE);
            newRetired.setFinal(true);
            this.changes.removeMatch(match);
            this.changes.addMatch(newRetired);
        }
    }

    private void handleAxiomAdjustments(EntityBasedDiff retiringEntityDiff, EntityBasedDiff keptEntityDiff) {
        if (retiringEntityDiff.getSourceEntity() == null) {
            return;
        }
        OWLEntity retiringEntity = retiringEntityDiff.getSourceEntity();
        OWLOntology sourceOntology = this.changes.getRawDiffMap().getSourceOntology();
        OWLOntology targetOntology = this.changes.getRawDiffMap().getTargetOntology();
        for (OWLAxiom axiom : sourceOntology.getReferencingAxioms(retiringEntity)) {
            OWLAxiom targetAxiom = (OWLAxiom)this.mergeDuplicator.duplicateObject(this.sourceToTarget.duplicateObject((OWLObject)axiom));
            MatchedAxiom axiomAdded = new MatchedAxiom(null, targetAxiom, MatchedAxiom.AXIOM_ADDED);
            MatchedAxiom axiomRemoved = new MatchedAxiom(axiom, null, MatchedAxiom.AXIOM_DELETED);
            MatchedAxiom axiomMerged = new MatchedAxiom(axiom, targetAxiom, MERGE_AXIOM);
            if (!this.changes.containsMatch(axiomAdded)) continue;
            this.changes.removeMatch(axiomAdded);
            this.changes.addMatch(axiomMerged);
            if (!this.changes.containsMatch(axiomRemoved)) continue;
            this.changes.removeMatch(axiomRemoved);
        }
    }

    private boolean isMergedIntoAxiom(OWLAxiom axiom) {
        boolean ret = false;
        if (axiom instanceof OWLAnnotationAssertionAxiom) {
            OWLAnnotationAssertionAxiom annotationAssertion = (OWLAnnotationAssertionAxiom)axiom;
            OWLAnnotation annotation = annotationAssertion.getAnnotation();
            ret = annotation.getProperty().equals(this.mergedIntoProperty) && annotationAssertion.getSubject() instanceof IRI && annotation.getValue() instanceof OWLLiteral;
        }
        return ret;
    }
}

