/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.diff.present.algorithms;

import org.protege.owl.diff.Engine;
import org.protege.owl.diff.present.Changes;
import org.protege.owl.diff.present.EntityBasedDiff;
import org.protege.owl.diff.present.MatchDescription;
import org.protege.owl.diff.present.MatchedAxiom;
import org.protege.owl.diff.present.algorithms.AbstractAnalyzerAlgorithm;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationValue;

public class IdentifyDeprecatedEntity
extends AbstractAnalyzerAlgorithm {
    public static final int IDENTIFY_DEPRECATED_ENTITY_PRIORITY = 5;
    public static final MatchDescription AXIOM_IS_DEPRECATION = new MatchDescription("Deprecated", 0);
    public static final OWLAnnotation DEPRECATE_ANNOTATION = OWLManager.getOWLDataFactory().getOWLAnnotation(OWLManager.getOWLDataFactory().getOWLDeprecated(), (OWLAnnotationValue)OWLManager.getOWLDataFactory().getOWLLiteral(true));
    private Changes changes;

    public IdentifyDeprecatedEntity() {
        this.setPriority(5);
    }

    @Override
    public void initialise(Engine e) {
        this.changes = e.getChanges();
    }

    @Override
    public void apply() {
        for (EntityBasedDiff diff : this.changes.getEntityBasedDiffs()) {
            this.apply(diff);
        }
    }

    public void apply(EntityBasedDiff diff) {
        MatchedAxiom deprecatedMatch = null;
        for (MatchedAxiom match : diff.getAxiomMatches()) {
            if (!match.getDescription().equals(MatchedAxiom.AXIOM_ADDED) || !(match.getTargetAxiom() instanceof OWLAnnotationAssertionAxiom) || !((OWLAnnotationAssertionAxiom)match.getTargetAxiom()).getAnnotation().equals(DEPRECATE_ANNOTATION)) continue;
            deprecatedMatch = match;
        }
        if (deprecatedMatch != null) {
            diff.setDiffTypeDescription("Deprecated");
            this.changes.removeMatch(deprecatedMatch);
            this.changes.addMatch(new MatchedAxiom(null, deprecatedMatch.getTargetAxiom(), AXIOM_IS_DEPRECATION));
        }
    }
}

