/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.diff.present.algorithms;

import org.protege.owl.diff.Engine;
import org.protege.owl.diff.align.OwlDiffMap;
import org.protege.owl.diff.present.Changes;
import org.protege.owl.diff.present.EntityBasedDiff;
import org.protege.owl.diff.present.MatchedAxiom;
import org.protege.owl.diff.present.algorithms.AbstractAnalyzerAlgorithm;
import org.protege.owl.diff.present.algorithms.IdentifyDeprecatedEntity;
import org.protege.owl.diff.service.DeprecationDeferralService;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLEntity;

public class IdentifyDeprecatedAndReplaced
extends AbstractAnalyzerAlgorithm {
    public static final String DEPRECATED_AND_REPLACED_DIFF_TYPE = "Deprecated and replaced";
    private OWLDataFactory factory;
    private OwlDiffMap diffMap;
    private Changes changes;
    private DeprecationDeferralService dds;

    public IdentifyDeprecatedAndReplaced() {
        this.setPriority(6);
    }

    @Override
    public void initialise(Engine e) {
        this.diffMap = e.getOwlDiffMap();
        this.changes = e.getChanges();
        this.factory = this.diffMap.getOWLDataFactory();
        this.dds = DeprecationDeferralService.get(e);
    }

    @Override
    public void apply() {
        for (EntityBasedDiff diff : this.changes.getEntityBasedDiffs()) {
            this.apply(diff);
        }
    }

    public void apply(EntityBasedDiff diff) {
        OWLEntity created = diff.getTargetEntity();
        if (diff.getDiffType() == EntityBasedDiff.DiffType.CREATED && this.diffMap.getSourceOntology().containsEntityInSignature(created) && this.dds.checkDeprecation(created, created)) {
            diff.setDiffTypeDescription(DEPRECATED_AND_REPLACED_DIFF_TYPE);
            OWLDeclarationAxiom declaration = this.factory.getOWLDeclarationAxiom(created);
            OWLAnnotationAssertionAxiom deprecated = this.factory.getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)created.getIRI(), IdentifyDeprecatedEntity.DEPRECATE_ANNOTATION);
            MatchedAxiom declarationMatch = null;
            MatchedAxiom deprecationMatch = null;
            for (MatchedAxiom match : diff.getAxiomMatches()) {
                if (match.getDescription().equals(MatchedAxiom.AXIOM_ADDED) && match.getTargetAxiom().equalsIgnoreAnnotations((OWLAxiom)declaration)) {
                    declarationMatch = match;
                    continue;
                }
                if (!match.getDescription().equals(MatchedAxiom.AXIOM_ADDED) || !match.getTargetAxiom().equalsIgnoreAnnotations((OWLAxiom)deprecated)) continue;
                deprecationMatch = match;
            }
            if (deprecationMatch != null) {
                this.changes.removeMatch(deprecationMatch);
                this.changes.addMatch(new MatchedAxiom(null, deprecationMatch.getTargetAxiom(), IdentifyDeprecatedEntity.AXIOM_IS_DEPRECATION));
            }
            if (declarationMatch != null) {
                this.changes.removeMatch(declarationMatch);
            }
        }
    }
}

