/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.diff.present.algorithms;

import org.protege.owl.diff.Engine;
import org.protege.owl.diff.present.Changes;
import org.protege.owl.diff.present.EntityBasedDiff;
import org.protege.owl.diff.present.MatchDescription;
import org.protege.owl.diff.present.MatchedAxiom;
import org.protege.owl.diff.present.algorithms.AbstractAnalyzerAlgorithm;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;

public class IdentifyChangedSuperclass
extends AbstractAnalyzerAlgorithm {
    public static final MatchDescription CHANGED_SUPERCLASS = new MatchDescription("Superclass changed");
    private Changes changes;

    @Override
    public void initialise(Engine e) {
        this.changes = e.getChanges();
    }

    @Override
    public void apply() {
        for (EntityBasedDiff diff : this.changes.getEntityBasedDiffs()) {
            this.match(diff);
        }
    }

    private void match(EntityBasedDiff diff) {
        this.matchAnonymousSuperClasses(diff, true);
        this.matchAnonymousSuperClasses(diff, false);
    }

    private void matchAnonymousSuperClasses(EntityBasedDiff diff, boolean anonymousOnly) {
        MatchedAxiom sourceAxiom = null;
        MatchedAxiom targetAxiom = null;
        for (MatchedAxiom correspondence : diff.getAxiomMatches()) {
            if (correspondence.getDescription().equals(MatchedAxiom.AXIOM_ADDED) && correspondence.getTargetAxiom() instanceof OWLSubClassOfAxiom && (!anonymousOnly || ((OWLSubClassOfAxiom)correspondence.getTargetAxiom()).getSuperClass().isAnonymous())) {
                if (targetAxiom != null) {
                    return;
                }
                targetAxiom = correspondence;
            }
            if (!correspondence.getDescription().equals(MatchedAxiom.AXIOM_DELETED) || !(correspondence.getSourceAxiom() instanceof OWLSubClassOfAxiom) || anonymousOnly && !((OWLSubClassOfAxiom)correspondence.getSourceAxiom()).getSuperClass().isAnonymous()) continue;
            if (sourceAxiom != null) {
                return;
            }
            sourceAxiom = correspondence;
        }
        if (sourceAxiom != null && targetAxiom != null) {
            MatchedAxiom newMatch = new MatchedAxiom(sourceAxiom.getSourceAxiom(), targetAxiom.getTargetAxiom(), CHANGED_SUPERCLASS);
            this.changes.addMatch(newMatch);
            this.changes.removeMatch(sourceAxiom);
            this.changes.removeMatch(targetAxiom);
        }
    }
}

