/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.diff.present.algorithms;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.protege.owl.diff.DifferencePosition;
import org.protege.owl.diff.Engine;
import org.protege.owl.diff.present.Changes;
import org.protege.owl.diff.present.EntityBasedDiff;
import org.protege.owl.diff.present.MatchDescription;
import org.protege.owl.diff.present.MatchedAxiom;
import org.protege.owl.diff.present.algorithms.AbstractAnalyzerAlgorithm;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;

public class IdentifyChangedAnnotation
extends AbstractAnalyzerAlgorithm {
    public static final int IDENTIFY_CHANGED_ANNOTATION_PRIORITY = 5;
    public static final MatchDescription CHANGED_ANNOTATION = new MatchDescription("Annotation Changed");
    private Changes changes;

    @Override
    public void initialise(Engine e) {
        this.changes = e.getChanges();
    }

    @Override
    public void apply() {
        for (EntityBasedDiff diff : this.changes.getEntityBasedDiffs()) {
            this.match(diff);
        }
    }

    private void match(EntityBasedDiff diff) {
        this.matchAnnotations(diff);
    }

    private void matchAnnotations(EntityBasedDiff diff) {
        HashMap<OWLAnnotationProperty, Set<MatchedAxiom>> sourceAxioms = new HashMap<OWLAnnotationProperty, Set<MatchedAxiom>>();
        HashMap<OWLAnnotationProperty, Set<MatchedAxiom>> targetAxioms = new HashMap<OWLAnnotationProperty, Set<MatchedAxiom>>();
        for (MatchedAxiom correspondence : diff.getAxiomMatches()) {
            if (this.isCandidateMatch(diff, correspondence, DifferencePosition.SOURCE)) {
                this.addAnnotationAssertionMatch(sourceAxioms, correspondence, (OWLAnnotationAssertionAxiom)correspondence.getSourceAxiom());
            }
            if (!this.isCandidateMatch(diff, correspondence, DifferencePosition.TARGET)) continue;
            this.addAnnotationAssertionMatch(targetAxioms, correspondence, (OWLAnnotationAssertionAxiom)correspondence.getTargetAxiom());
        }
        for (OWLAnnotationProperty p : sourceAxioms.keySet()) {
            Set sourceMatches = (Set)sourceAxioms.get(p);
            Set targetMatches = (Set)targetAxioms.get(p);
            if (sourceMatches == null || sourceMatches.size() != 1 || targetMatches == null || targetMatches.size() != 1) continue;
            MatchedAxiom deleted = (MatchedAxiom)sourceMatches.iterator().next();
            MatchedAxiom added = (MatchedAxiom)targetMatches.iterator().next();
            this.changes.removeMatch(deleted);
            this.changes.removeMatch(added);
            MatchedAxiom changed = new MatchedAxiom(deleted.getSourceAxiom(), added.getTargetAxiom(), CHANGED_ANNOTATION);
            this.changes.addMatch(changed);
        }
    }

    private boolean isCandidateMatch(EntityBasedDiff diff, MatchedAxiom match, DifferencePosition position) {
        MatchDescription expectedMatchDescription = position == DifferencePosition.SOURCE ? MatchedAxiom.AXIOM_DELETED : MatchedAxiom.AXIOM_ADDED;
        OWLEntity entity = position.getEntity(diff);
        OWLAxiom axiom = position.getAxiom(match);
        return match.getDescription().equals(expectedMatchDescription) && axiom instanceof OWLAnnotationAssertionAxiom && entity != null && ((OWLAnnotationAssertionAxiom)axiom).getSubject().equals(entity.getIRI());
    }

    private boolean isIdenticalAnnotation(MatchedAxiom deleted, MatchedAxiom added) {
        return ((OWLAnnotationAssertionAxiom)deleted.getSourceAxiom()).getAnnotation().equals(((OWLAnnotationAssertionAxiom)added.getTargetAxiom()).getAnnotation());
    }

    private void addAnnotationAssertionMatch(Map<OWLAnnotationProperty, Set<MatchedAxiom>> map, MatchedAxiom match, OWLAnnotationAssertionAxiom axiom) {
        OWLAnnotationProperty p = axiom.getProperty();
        Set<MatchedAxiom> matches = map.get(p);
        if (matches == null) {
            matches = new HashSet<MatchedAxiom>();
            map.put(p, matches);
        }
        matches.add(match);
    }
}

